/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public final class InternalStatsAction
extends AbstractAction
implements ProfilingStateListener {
    public InternalStatsAction() {
        this.putValue("Name", NbBundle.getMessage(InternalStatsAction.class, (String)"LBL_InternalStatsAction"));
        this.putValue("ShortDescription", NbBundle.getMessage(InternalStatsAction.class, (String)"HINT_InternalStatsAction"));
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.updateEnabledState();
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            String stats = Profiler.getDefault().getTargetAppRunner().getInternalStats();
            HTMLTextArea textArea = new HTMLTextArea(stats);
            textArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InternalStatsAction.class, (String)"CAPTION_InternalStatisticsInstrHotswap"));
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            p.add((Component)new JScrollPane((Component)textArea), "Center");
            DialogDisplayer.getDefault().createDialog(new DialogDescriptor((Object)p, NbBundle.getMessage(InternalStatsAction.class, (String)"CAPTION_InternalStatisticsInstrHotswap"), true, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, null, null)).setVisible(true);
        }
        catch (ClientUtils.TargetAppOrVMTerminated e) {
            ProfilerDialogs.displayWarning((String)MessageFormat.format(NbBundle.getMessage(InternalStatsAction.class, (String)"MSG_NotAvailableNow"), e.getMessage()));
        }
    }

    public void profilingStateChanged(ProfilingStateEvent e) {
        this.updateEnabledState();
    }

    public void threadsMonitoringChanged() {
    }

    public void instrumentationChanged(int oldInstrType, int currentInstrType) {
    }

    private void updateEnabledState() {
        this.setEnabled(Profiler.getDefault().getProfilingState() == 4);
    }
}

