/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.selector.api.SelectionTreeBuilderFactory;
import org.netbeans.modules.profiler.selector.spi.SelectionTreeBuilder;
import org.netbeans.modules.profiler.selector.ui.ProgressDisplayer;
import org.netbeans.modules.profiler.selector.ui.RootSelectorTree;
import org.netbeans.modules.profiler.ui.panels.ProfilerProgressDisplayer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public final class ClassSelectRootMethodsPanel
extends JPanel {
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(ClassSelectRootMethodsPanel.class, (String)"SelectRootMethodsPanel_OkButtonText");
    private static final String HELP_CTX_KEY = "ClassSelectRootMethodsPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ClassSelectRootMethodsPanel.HelpCtx");
    private static final Dimension PREFERRED_TOPTREE_DIMENSION = new Dimension(500, 250);
    private JButton okButton;
    private RootSelectorTree advancedLogicalPackageTree;

    public static final ClassSelectRootMethodsPanel getDefault() {
        return Singleton.INSTANCE;
    }

    private ClassSelectRootMethodsPanel() {
        this.init(this);
    }

    private void init(Container container) {
        this.okButton = new JButton(OK_BUTTON_TEXT);
        ProgressDisplayer pd = new ProgressDisplayer(){
            ProfilerProgressDisplayer pd = null;

            public synchronized void showProgress(String message) {
                this.pd = ProfilerProgressDisplayer.showProgress(message);
            }

            public synchronized void showProgress(String message, ProgressDisplayer.ProgressController controller) {
                this.pd = ProfilerProgressDisplayer.showProgress(message, (Cancellable)controller);
            }

            public synchronized void showProgress(String caption, String message, ProgressDisplayer.ProgressController controller) {
                this.pd = ProfilerProgressDisplayer.showProgress(caption, message, (Cancellable)controller);
            }

            public synchronized boolean isOpened() {
                return this.pd != null;
            }

            public synchronized void close() {
                if (this.pd != null) {
                    this.pd.close();
                    this.pd = null;
                }
            }
        };
        this.advancedLogicalPackageTree = new RootSelectorTree(pd, RootSelectorTree.DEFAULT_FILTER);
        container.setLayout(new GridBagLayout());
        this.advancedLogicalPackageTree.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        JScrollPane advancedLogicalPackageTreeScrollPane = new JScrollPane((Component)this.advancedLogicalPackageTree);
        advancedLogicalPackageTreeScrollPane.setPreferredSize(PREFERRED_TOPTREE_DIMENSION);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        container.add((Component)advancedLogicalPackageTreeScrollPane, gridBagConstraints);
    }

    public ClientUtils.SourceCodeSelection[] getRootMethods(final FileObject javaFile, final ClientUtils.SourceCodeSelection[] currentSelection) {
        this.advancedLogicalPackageTree.reset();
        this.updateSelector(new Runnable(){

            @Override
            public void run() {
                List builders = SelectionTreeBuilderFactory.buildersFor((FileObject)javaFile);
                ClassSelectRootMethodsPanel.this.advancedLogicalPackageTree.setContext(Lookups.fixed((Object[])builders.toArray(new SelectionTreeBuilder[builders.size()])));
                ClassSelectRootMethodsPanel.this.advancedLogicalPackageTree.setSelection(currentSelection);
                List builderTypes = ClassSelectRootMethodsPanel.this.advancedLogicalPackageTree.getBuilderTypes();
                if (builderTypes.size() > 0) {
                    ClassSelectRootMethodsPanel.this.advancedLogicalPackageTree.setBuilderType((SelectionTreeBuilder.Type)builderTypes.get(0));
                }
            }
        });
        DialogDescriptor dd = new DialogDescriptor((Object)this, NbBundle.getMessage(this.getClass(), (String)"SelectRootMethodsPanel_Title"), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, null, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.pack();
        d.setVisible(true);
        if (dd.getValue().equals(this.okButton)) {
            ClientUtils.SourceCodeSelection[] selection = this.advancedLogicalPackageTree.getSelection();
            return selection;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelector(Runnable updater) {
        final ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(this.getClass(), (String)"SelectRootMethodsPanel_ParsingProjectStructureMessage"));
        CommonUtils.runInEventDispatchThreadAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                ph.setInitialDelay(500);
                ph.start();
            }
        });
        try {
            this.advancedLogicalPackageTree.setEnabled(false);
            this.okButton.setEnabled(false);
            updater.run();
        }
        finally {
            ph.finish();
            this.okButton.setEnabled(true);
            this.advancedLogicalPackageTree.setEnabled(true);
        }
    }

    private static final class Singleton {
        private static final ClassSelectRootMethodsPanel INSTANCE = new ClassSelectRootMethodsPanel();

        private Singleton() {
        }
    }
}

