/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.ide;

import java.io.File;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.AppChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.api.DeploymentChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.plugins.spi.IncrementalDeployment;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.TomcatManagerImpl;
import org.netbeans.modules.tomcat5.TomcatModule;
import org.netbeans.modules.tomcat5.progress.ProgressEventSupport;
import org.netbeans.modules.tomcat5.progress.Status;
import org.openide.util.RequestProcessor;

public class TomcatIncrementalDeployment
extends IncrementalDeployment {
    private TomcatManager tm;

    public TomcatIncrementalDeployment(DeploymentManager dm) {
        this.tm = (TomcatManager)dm;
    }

    public boolean canFileDeploy(Target target, J2eeModule j2eeModule) {
        return j2eeModule.getModuleType().equals(ModuleType.WAR);
    }

    public File getDirectoryForModule(TargetModuleID module) {
        return null;
    }

    public File getDirectoryForNewApplication(Target target, J2eeModule module, ModuleConfiguration configuration) {
        if (module.getModuleType().equals(ModuleType.WAR)) {
            return null;
        }
        throw new IllegalArgumentException("ModuleType:" + module == null ? null : module.getModuleType() + " Configuration:" + configuration);
    }

    public File getDirectoryForNewModule(File appDir, String uri, J2eeModule module, ModuleConfiguration configuration) {
        throw new UnsupportedOperationException();
    }

    public ProgressObject incrementalDeploy(final TargetModuleID module, AppChangeDescriptor changes) {
        if (changes.descriptorChanged() || changes.serverDescriptorChanged() || changes.classesChanged()) {
            TomcatManagerImpl tmi = new TomcatManagerImpl(this.tm);
            if (changes.serverDescriptorChanged()) {
                new TomcatManagerImpl(this.tm).remove((TomcatModule)module);
                tmi.incrementalRedeploy((TomcatModule)module);
            } else if (changes.descriptorChanged()) {
                new TomcatManagerImpl(this.tm).stop((TomcatModule)module);
                tmi.start((TomcatModule)module);
            } else {
                tmi.reload((TomcatModule)module);
            }
            return tmi;
        }
        final P p = new P(module);
        p.supp.fireHandleProgressEvent(module, new Status(ActionType.EXECUTE, CommandType.DISTRIBUTE, "", StateType.COMPLETED));
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    p.supp.fireHandleProgressEvent(module, new Status(ActionType.EXECUTE, CommandType.DISTRIBUTE, "", StateType.COMPLETED));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        return p;
    }

    public ProgressObject initialDeploy(Target target, J2eeModule app, ModuleConfiguration configuration, File dir) {
        TomcatManagerImpl tmi = new TomcatManagerImpl(this.tm);
        File contextXml = new File(dir.getAbsolutePath() + "/META-INF/context.xml");
        tmi.initialDeploy(target, contextXml, dir);
        return tmi;
    }

    public void notifyDeployment(TargetModuleID module) {
        if (this.tm.isTomcat50() && this.tm.getTomcatProperties().getOpenContextLogOnRun()) {
            this.tm.openLog(module);
        }
    }

    public ProgressObject deployOnSave(TargetModuleID module, DeploymentChangeDescriptor desc) {
        return this.incrementalDeploy(module, (AppChangeDescriptor)desc);
    }

    public boolean isDeployOnSaveSupported() {
        return true;
    }

    private static class P
    implements ProgressObject {
        ProgressEventSupport supp = new ProgressEventSupport(this);
        TargetModuleID tmid;

        P(TargetModuleID tmid) {
            this.tmid = tmid;
        }

        public void addProgressListener(ProgressListener progressListener) {
            this.supp.addProgressListener(progressListener);
        }

        public void removeProgressListener(ProgressListener progressListener) {
            this.supp.removeProgressListener(progressListener);
        }

        public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
            return null;
        }

        public DeploymentStatus getDeploymentStatus() {
            return this.supp.getDeploymentStatus();
        }

        public TargetModuleID[] getResultTargetModuleIDs() {
            return new TargetModuleID[]{this.tmid};
        }

        public boolean isCancelSupported() {
            return false;
        }

        public boolean isStopSupported() {
            return false;
        }

        public void cancel() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("");
        }

        public void stop() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("");
        }
    }
}

