/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompileLineStorage;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.spi.configurations.PkgConfigManager;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.Utilities;

public class LogReader {
    private static boolean TRACE = Boolean.getBoolean("cnd.dwarfdiscovery.trace.read.log");
    private String workingDir;
    private String guessWorkingDir;
    private String baseWorkingDir;
    private final String root;
    private final String fileName;
    private List<SourceFileProperties> result;
    private final PathMap pathMapper;
    private final ProjectProxy project;
    private final ArrayList<List<String>> makeStack = new ArrayList();
    private static final String CURRENT_DIRECTORY = "Current working directory";
    private static final String ENTERING_DIRECTORY = "Entering directory";
    private static final String LEAVING_DIRECTORY = "Leaving directory";
    private static final String LABEL_CD = "cd ";
    private static final String INVOKE_GNU_C = "gcc ";
    private static final String INVOKE_GNU_C2 = "gcc.exe ";
    private static final String INVOKE_SUN_C = "cc ";
    private static final String INVOKE_GNU_Cpp = "g++ ";
    private static final String INVOKE_GNU_Cpp2 = "g++.exe ";
    private static final String INVOKE_GNU_Cpp3 = "c++ ";
    private static final String INVOKE_GNU_Cpp4 = "c++.exe ";
    private static final String INVOKE_SUN_Cpp = "CC ";
    private static final String INVOKE_MSVC_Cpp = "cl ";
    private static final String INVOKE_GNU_Fortran1 = "gfortran ";
    private static final String INVOKE_GNU_Fortran2 = "gfortran.exe ";
    private static final String INVOKE_GNU_Fortran3 = "g95.exe ";
    private static final String INVOKE_GNU_Fortran4 = "g90.exe ";
    private static final String INVOKE_GNU_Fortran5 = "g77.exe ";
    private static final String INVOKE_GNU_Fortran6 = "g95 ";
    private static final String INVOKE_GNU_Fortran7 = "g90 ";
    private static final String INVOKE_GNU_Fortran8 = "g77 ";
    private static final String INVOKE_SUN_Fortran = "ffortran ";
    private static final String INVOKE_SUN_Fortran1 = "f95 ";
    private static final String INVOKE_SUN_Fortran2 = "f90 ";
    private static final String INVOKE_SUN_Fortran3 = "f77 ";
    private static final String MAKE_DELIMITER = ";";
    private static final String PKG_CONFIG_PATTERN = "pkg-config ";
    private static final String ECHO_PATTERN = "echo ";
    private HashSet<String> subFolders;
    private Map<String, List<String>> findBase;

    public LogReader(String fileName, String root, ProjectProxy project) {
        this.root = root.length() > 0 ? CndFileUtils.normalizeFile((File)new File(root)).getAbsolutePath() : root;
        this.fileName = fileName;
        this.project = project;
        this.pathMapper = this.getPathMapper(project);
        this.setWorkingDir(root);
    }

    private String convertPath(String path) {
        String local;
        if (this.pathMapper != null && CndPathUtilitities.isPathAbsolute((CharSequence)path) && (local = this.pathMapper.getLocalPath(path)) != null) {
            return local;
        }
        return path;
    }

    private PathMap getPathMapper(ProjectProxy project) {
        Project p = project.getProject();
        if (p != null) {
            return RemoteSyncSupport.getPathMap((Project)p);
        }
        return null;
    }

    private MakeConfiguration getConfiguration(ProjectProxy project) {
        MakeConfigurationDescriptor confDescr;
        ConfigurationDescriptorProvider pdp;
        if (project != null && project.getProject() != null && (pdp = (ConfigurationDescriptorProvider)project.getProject().getLookup().lookup(ConfigurationDescriptorProvider.class)) != null && pdp.gotDescriptor() && (confDescr = pdp.getConfigurationDescriptor()) != null) {
            return confDescr.getActiveConfiguration();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(Progress progress, AtomicBoolean isStoped, CompileLineStorage storage) {
        if (TRACE) {
            System.out.println("LogReader is run for " + this.fileName);
        }
        Pattern pattern = Pattern.compile(";|\\|\\||&&");
        this.result = new ArrayList<SourceFileProperties>();
        File file = new File(this.fileName);
        if (file.exists() && file.canRead()) {
            try {
                MakeConfiguration conf = this.getConfiguration(this.project);
                PkgConfigManager.PkgConfig pkgConfig = PkgConfigManager.getDefault().getPkgConfig(conf);
                BufferedReader in = new BufferedReader(new FileReader(file));
                long length = file.length();
                long read = 0L;
                int done = 0;
                if (length <= 0L) {
                    progress = null;
                }
                if (progress != null) {
                    progress.start(100);
                }
                int nFoundFiles = 0;
                try {
                    while (!isStoped.get()) {
                        String oneMoreLine;
                        String line = in.readLine();
                        if (line == null) {
                            break;
                        }
                        read += (long)(line.length() + 1);
                        line = line.trim();
                        while (line.endsWith("\\") && (oneMoreLine = in.readLine()) != null) {
                            line = line.substring(0, line.length() - 1) + " " + oneMoreLine.trim();
                        }
                        line = LogReader.trimBackApostropheCalls(line, pkgConfig);
                        String[] cmds = pattern.split(line);
                        for (int i = 0; i < cmds.length; ++i) {
                            if (!this.parseLine(cmds[i], storage)) continue;
                            ++nFoundFiles;
                        }
                        if (read * 100L / length <= (long)done || done >= 100) continue;
                        ++done;
                        if (progress == null) continue;
                        progress.increment(null);
                    }
                }
                finally {
                    if (progress != null) {
                        progress.done();
                    }
                }
                if (TRACE) {
                    System.out.println("Files found: " + nFoundFiles);
                    System.out.println("Files included in result: " + this.result.size());
                }
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public List<SourceFileProperties> getResults(Progress progress, AtomicBoolean isStoped, CompileLineStorage storage) {
        if (this.result == null) {
            this.run(progress, isStoped, storage);
            if (this.subFolders != null) {
                this.subFolders.clear();
                this.subFolders = null;
                this.findBase.clear();
                this.findBase = null;
            }
        }
        return this.result;
    }

    private int getMakeLevel(String line) {
        int i2;
        int i1 = line.indexOf(91);
        if (i1 > 0 && (i2 = line.indexOf(93)) > i1) {
            String s = line.substring(i1 + 1, i2);
            try {
                int res = Integer.parseInt(s);
                return res;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return -1;
    }

    private void enterMakeStack(String dir, int level) {
        if (level < 0) {
            return;
        }
        for (int i = this.makeStack.size(); i <= level; ++i) {
            this.makeStack.add(new ArrayList());
        }
        List<String> list = this.makeStack.get(level);
        list.add(dir);
    }

    private boolean leaveMakeStack(String dir, int level) {
        if (level < 0) {
            return false;
        }
        if (this.makeStack.size() <= level) {
            return false;
        }
        List<String> list = this.makeStack.get(level);
        for (String s : list) {
            if (!s.equals(dir)) continue;
            list.remove(s);
            return true;
        }
        return false;
    }

    private List<String> getMakeTop(int level) {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = Math.min(this.makeStack.size(), level - 1); i >= 0; --i) {
            List<String> list = this.makeStack.get(i);
            if (list.size() <= 0) continue;
            if (res.isEmpty()) {
                res.addAll(list);
                continue;
            }
            if (list.size() <= 1) continue;
            res.addAll(list);
        }
        return res;
    }

    private boolean checkDirectoryChange(String line) {
        String d;
        String dir;
        String workDir = null;
        String message = null;
        if (line.startsWith(CURRENT_DIRECTORY)) {
            workDir = this.convertPath(line.substring(CURRENT_DIRECTORY.length() + 1).trim());
            if (TRACE) {
                message = "**>> by [Current working directory] ";
            }
        } else if (line.indexOf(ENTERING_DIRECTORY) >= 0) {
            String dirMessage = line.substring(line.indexOf(ENTERING_DIRECTORY) + ENTERING_DIRECTORY.length() + 1).trim();
            workDir = this.convertPath(dirMessage.replaceAll("`|'|\"", ""));
            if (TRACE) {
                message = "**>> by [Entering directory] ";
            }
            this.baseWorkingDir = workDir;
            this.enterMakeStack(workDir, this.getMakeLevel(line));
        } else if (line.indexOf(LEAVING_DIRECTORY) >= 0) {
            List<String> paths;
            int level;
            String dirMessage = line.substring(line.indexOf(LEAVING_DIRECTORY) + LEAVING_DIRECTORY.length() + 1).trim();
            workDir = this.convertPath(dirMessage.replaceAll("`|'|\"", ""));
            if (TRACE) {
                message = "**>> by [Leaving directory] ";
            }
            if (this.leaveMakeStack(workDir, level = this.getMakeLevel(line)) && (paths = this.getMakeTop(level)).size() == 1) {
                this.baseWorkingDir = paths.get(0);
            }
        } else if (line.startsWith(LABEL_CD)) {
            int end = line.indexOf(MAKE_DELIMITER);
            workDir = this.convertPath((end == -1 ? line : line.substring(0, end)).substring(LABEL_CD.length()).trim());
            if (TRACE) {
                message = "**>> by [ cd ] ";
            }
            if (workDir.startsWith("/")) {
                this.baseWorkingDir = workDir;
            }
        } else if (line.startsWith("/") && line.indexOf(" ") < 0) {
            workDir = this.convertPath(line.trim());
            if (TRACE) {
                message = "**>> by [just path string] ";
            }
        }
        if (workDir == null || workDir.length() == 0) {
            return false;
        }
        if (Utilities.isWindows() && workDir.startsWith("/cygdrive/") && workDir.length() > 11) {
            workDir = "" + workDir.charAt(10) + ":" + workDir.substring(11);
        }
        if (workDir.charAt(0) == '/' || workDir.charAt(0) == '\\' || workDir.length() > 1 && workDir.charAt(1) == ':') {
            if (new File(workDir).exists()) {
                if (TRACE) {
                    System.err.print(message);
                }
                this.setWorkingDir(workDir);
                return true;
            }
            String netFile = this.fixNetHost(workDir);
            if (netFile != null) {
                this.setWorkingDir(netFile);
            }
        }
        if (new File(dir = this.workingDir + File.separator + workDir).exists()) {
            if (TRACE) {
                System.err.print(message);
            }
            this.setWorkingDir(dir);
            return true;
        }
        if (Utilities.isWindows() && workDir.length() > 3 && workDir.charAt(0) == '/' && workDir.charAt(2) == '/' && new File(d = "" + workDir.charAt(1) + ":" + workDir.substring(2)).exists()) {
            if (TRACE) {
                System.err.print(message);
            }
            this.setWorkingDir(d);
            return true;
        }
        if (this.baseWorkingDir != null && new File(dir = this.baseWorkingDir + File.separator + workDir).exists()) {
            if (TRACE) {
                System.err.print(message);
            }
            this.setWorkingDir(dir);
            return true;
        }
        return false;
    }

    private String fixNetHost(String dir) {
        int i;
        if (this.root.startsWith("/net/") && (i = this.root.indexOf(47, 5)) > 0) {
            String netFile;
            String localPath = this.root.substring(i);
            String prefix = this.root.substring(0, i);
            if (dir.startsWith(localPath) && new File(netFile = prefix + dir).exists()) {
                return netFile;
            }
        }
        return null;
    }

    private static int[] foundCompiler(String line, String ... patterns) {
        for (String pattern : patterns) {
            int start = line.indexOf(pattern);
            if (start < 0) continue;
            int prev = 32;
            if (start > 0) {
                prev = line.charAt(start - 1);
            }
            if (prev != 32 && prev != 9 && prev != 47 && prev != 92) continue;
            int end = start + pattern.length();
            return new int[]{start, end};
        }
        return null;
    }

    static LineInfo testCompilerInvocation(String line) {
        int[] res;
        LineInfo li = new LineInfo(line);
        int start = 0;
        int end = -1;
        if (li.compilerType == CompilerType.UNKNOWN && (res = LogReader.foundCompiler(line, INVOKE_GNU_C, INVOKE_GNU_C2)) != null) {
            start = res[0];
            end = res[1];
            li.compilerType = CompilerType.C;
            li.compiler = "gcc";
        }
        if (li.compilerType == CompilerType.UNKNOWN && (res = LogReader.foundCompiler(line, INVOKE_GNU_Cpp, INVOKE_GNU_Cpp2, INVOKE_GNU_Cpp3, INVOKE_GNU_Cpp4)) != null) {
            start = res[0];
            end = res[1];
            li.compilerType = CompilerType.CPP;
            li.compiler = "g++";
        }
        if (li.compilerType == CompilerType.UNKNOWN && (res = LogReader.foundCompiler(line, INVOKE_SUN_C)) != null) {
            start = res[0];
            end = res[1];
            li.compilerType = CompilerType.C;
            li.compiler = "cc";
        }
        if (li.compilerType == CompilerType.UNKNOWN && (res = LogReader.foundCompiler(line, INVOKE_SUN_Cpp)) != null) {
            start = res[0];
            end = res[1];
            li.compilerType = CompilerType.CPP;
            li.compiler = "CC";
        }
        if (li.compilerType == CompilerType.UNKNOWN && (res = LogReader.foundCompiler(line, INVOKE_GNU_Fortran1, INVOKE_GNU_Fortran2, INVOKE_GNU_Fortran3, INVOKE_GNU_Fortran4, INVOKE_GNU_Fortran5, INVOKE_GNU_Fortran6, INVOKE_GNU_Fortran7, INVOKE_GNU_Fortran8)) != null) {
            start = res[0];
            end = res[1];
            li.compilerType = CompilerType.FORTRAN;
            li.compiler = "gfortran";
        }
        if (li.compilerType == CompilerType.UNKNOWN && (res = LogReader.foundCompiler(line, INVOKE_SUN_Fortran, INVOKE_SUN_Fortran1, INVOKE_SUN_Fortran2, INVOKE_SUN_Fortran3)) != null) {
            start = res[0];
            end = res[1];
            li.compilerType = CompilerType.FORTRAN;
            li.compiler = "ffortran";
        }
        if (li.compilerType == CompilerType.UNKNOWN && (res = LogReader.foundCompiler(line, INVOKE_MSVC_Cpp)) != null) {
            start = res[0];
            end = res[1];
            li.compilerType = CompilerType.CPP;
            li.compiler = "cl";
        }
        if (li.compilerType != CompilerType.UNKNOWN) {
            li.compileLine = line.substring(start);
            while (end < line.length() && (line.charAt(end) == ' ' || line.charAt(end) == '\t')) {
                ++end;
            }
            if (end >= line.length() || line.charAt(end) != '-') {
                li.compilerType = CompilerType.UNKNOWN;
            }
        }
        return li;
    }

    private void setWorkingDir(String workingDir) {
        if (TRACE) {
            System.err.println("**>> new working dir: " + workingDir);
        }
        this.workingDir = CndFileUtils.normalizeFile((File)new File(workingDir)).getAbsolutePath();
    }

    private void setGuessWorkingDir(String workingDir) {
        if (TRACE) {
            System.err.println("**>> alternative guess working dir: " + workingDir);
        }
        this.guessWorkingDir = CndFileUtils.normalizeFile((File)new File(workingDir)).getAbsolutePath();
    }

    private boolean parseLine(String line, CompileLineStorage storage) {
        if (this.checkDirectoryChange(line)) {
            return false;
        }
        if (this.workingDir == null) {
            return false;
        }
        if (!this.workingDir.startsWith(this.root)) {
            return false;
        }
        LineInfo li = LogReader.testCompilerInvocation(line);
        if (li.compilerType != CompilerType.UNKNOWN) {
            this.gatherLine(li, storage);
            return true;
        }
        return false;
    }

    static String trimBackApostropheCalls(String line, PkgConfigManager.PkgConfig pkgConfig) {
        int j;
        int i = line.indexOf(96);
        if (line.lastIndexOf(96) == i) {
            return line;
        }
        if (i < 0 || i == line.length() - 1) {
            return line;
        }
        StringBuilder out = new StringBuilder();
        if (i > 0) {
            out.append(line.substring(0, i));
        }
        if ((j = (line = line.substring(i + 1)).indexOf(96)) < 0) {
            return line;
        }
        String pkg = line.substring(0, j);
        if (pkg.startsWith(PKG_CONFIG_PATTERN)) {
            PkgConfigManager.PackageConfiguration pc;
            pkg = pkg.substring(PKG_CONFIG_PATTERN.length());
            StringTokenizer st = new StringTokenizer(pkg);
            boolean readFlags = false;
            String findPkg = null;
            while (st.hasMoreTokens()) {
                String aPkg = st.nextToken();
                if (aPkg.equals("--cflags")) {
                    readFlags = true;
                    continue;
                }
                if (aPkg.startsWith("-")) {
                    readFlags = false;
                    continue;
                }
                findPkg = aPkg;
            }
            if (readFlags && pkgConfig != null && findPkg != null && (pc = pkgConfig.getPkgConfig(findPkg)) != null) {
                for (String p : pc.getIncludePaths()) {
                    out.append(" -I").append(p);
                }
                for (String p : pc.getMacros()) {
                    out.append(" -D").append(p);
                }
                out.append(" ");
            }
        } else if (pkg.startsWith(ECHO_PATTERN)) {
            if ((pkg = pkg.substring(ECHO_PATTERN.length())).startsWith("'") && pkg.endsWith("'")) {
                out.append(pkg.substring(1, pkg.length() - 1));
            } else {
                StringTokenizer st = new StringTokenizer(pkg);
                boolean first = true;
                if (st.hasMoreTokens()) {
                    if (!first) {
                        out.append(" ");
                    }
                    first = false;
                    out.append(st.nextToken());
                }
            }
        } else if (pkg.contains(ECHO_PATTERN)) {
            if ((pkg = pkg.substring(pkg.indexOf(ECHO_PATTERN) + ECHO_PATTERN.length())).startsWith("'") && pkg.endsWith("'")) {
                out.append(pkg.substring(1, pkg.length() - 1));
            } else {
                StringTokenizer st = new StringTokenizer(pkg);
                boolean first = true;
                if (st.hasMoreTokens()) {
                    if (!first) {
                        out.append(" ");
                    }
                    first = false;
                    out.append(st.nextToken());
                }
            }
        }
        out.append(line.substring(j + 1));
        return LogReader.trimBackApostropheCalls(out.toString(), pkgConfig);
    }

    private void gatherLine(LineInfo li, CompileLineStorage storage) {
        String line = li.compileLine;
        ArrayList<String> userIncludes = new ArrayList<String>();
        HashMap<String, String> userMacros = new HashMap<String, String>();
        ArrayList<String> languageArtifacts = new ArrayList<String>();
        List sourcesList = DiscoveryUtils.gatherCompilerLine((String)line, (boolean)true, userIncludes, userMacros, null, languageArtifacts);
        for (String what : sourcesList) {
            if (what == null || what.endsWith(".s") || what.endsWith(".S")) continue;
            String file = null;
            file = what.startsWith("/") ? what : this.workingDir + "/" + what;
            ArrayList<String> userIncludesCached = new ArrayList<String>(userIncludes.size());
            for (String s : userIncludes) {
                userIncludesCached.add(PathCache.getString(s));
            }
            HashMap<String, String> userMacrosCached = new HashMap<String, String>(userMacros.size());
            for (Map.Entry e : userMacros.entrySet()) {
                if (e.getValue() == null) {
                    userMacrosCached.put(PathCache.getString((String)e.getKey()), null);
                    continue;
                }
                userMacrosCached.put(PathCache.getString((String)e.getKey()), PathCache.getString((String)e.getValue()));
            }
            File f = new File(file);
            if (f.exists() && f.isFile()) {
                if (TRACE) {
                    System.err.println("**** Gotcha: " + file);
                }
                this.result.add(new CommandLineSource(li, languageArtifacts, this.workingDir, what, userIncludesCached, userMacrosCached, storage));
                continue;
            }
            if (this.guessWorkingDir != null && !what.startsWith("/") && (f = new File(this.guessWorkingDir + "/" + what)).exists() && f.isFile()) {
                if (TRACE) {
                    System.err.println("**** Gotcha guess: " + file);
                }
                this.result.add(new CommandLineSource(li, languageArtifacts, this.guessWorkingDir, what, userIncludesCached, userMacrosCached, storage));
                continue;
            }
            if (TRACE) {
                System.err.println("**** Not found " + file);
            }
            if (what.startsWith("/") || userIncludes.size() + userMacros.size() <= 0) continue;
            List<String> res = this.findFiles(what);
            if (res == null || res.isEmpty()) {
                if (TRACE) {
                    System.err.println("** And there is no such file under root");
                }
            } else {
                if (res.size() == 1) {
                    this.result.add(new CommandLineSource(li, languageArtifacts, res.get(0), what, userIncludes, userMacros, storage));
                    if (TRACE) {
                        System.err.println("** Gotcha: " + res.get(0) + File.separator + what);
                    }
                    this.setGuessWorkingDir(res.get(0));
                    continue;
                }
                if (TRACE) {
                    System.err.println("**There are several candidates and I'm not clever enough yet to find correct one.");
                }
            }
            if (!TRACE) continue;
            System.err.println("" + (line.length() > 120 ? line.substring(0, 117) + ">>>" : line) + " [" + what + "]");
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Not enough parameters. Format: bla-bla-bla filename root");
            return;
        }
        String objFileName = args[0];
        String root = args[1];
        TRACE = true;
        LogReader clrf = new LogReader(objFileName, root, null);
        List<SourceFileProperties> list = clrf.getResults(null, new AtomicBoolean(false), null);
        System.err.print("\n*** Results: ");
        for (SourceFileProperties sourceFileProperties : list) {
            String fileName = sourceFileProperties.getItemName();
            while (fileName.indexOf("../") == 0) {
                fileName = fileName.substring(3);
            }
            System.err.print(fileName + " ");
        }
        System.err.println();
    }

    private List<String> getFiles(String name) {
        this.getSubfolders();
        return this.findBase.get(name);
    }

    private List<String> findFiles(String relativePath) {
        List<String> files;
        int j;
        String name;
        relativePath = relativePath.replace('\\', '/');
        int i = relativePath.lastIndexOf(47);
        String relativeFolder = null;
        if (i > 0) {
            name = relativePath.substring(i + 1);
            relativeFolder = relativePath.substring(0, i);
        } else {
            name = relativePath;
        }
        String subFolder = null;
        if (relativeFolder != null && (j = relativeFolder.lastIndexOf("../")) >= 0) {
            subFolder = relativePath.substring(j + 2);
        }
        if ((files = this.getFiles(name)) != null) {
            ArrayList<String> res = new ArrayList<String>(files.size());
            for (String s : files) {
                if (relativeFolder == null) {
                    res.add(s);
                    if (res.size() <= 1) continue;
                    return res;
                }
                if (subFolder == null) {
                    String path = s;
                    if (!path.endsWith(relativeFolder)) continue;
                    path = path.substring(0, path.length() - relativeFolder.length() - 1);
                    res.add(path);
                    if (res.size() <= 1) continue;
                    return res;
                }
                for (String sub : this.getSubfolders()) {
                    String pathCandidate = this.normalizeFile(sub + "/" + relativePath);
                    int j2 = pathCandidate.lastIndexOf(47);
                    if (j2 <= 0 || !this.subFolders.contains(pathCandidate = pathCandidate.substring(0, j2))) continue;
                    res.add(sub);
                    if (res.size() <= 1) continue;
                    return res;
                }
            }
            return res;
        }
        return null;
    }

    private String normalizeFile(String path) {
        int i;
        path = path.replace("/./", "/");
        while ((i = path.indexOf("/../")) >= 0) {
            int prev = -1;
            for (int j = i - 1; j >= 0; --j) {
                if (path.charAt(j) != '/') continue;
                prev = j;
                break;
            }
            if (prev == -1) break;
            path = path.substring(0, prev) + path.substring(i + 3);
        }
        return path;
    }

    private Set<String> getSubfolders() {
        if (this.subFolders == null) {
            this.subFolders = new HashSet();
            File f = new File(this.root);
            this.gatherSubFolders(f, new HashSet<String>());
            this.findBase = new HashMap<String, List<String>>();
            this.initSearchMap();
        }
        return this.subFolders;
    }

    private void gatherSubFolders(File d, HashSet<String> antiLoop) {
        if (d.exists() && d.isDirectory() && d.canRead()) {
            String canPath;
            if (CndPathUtilitities.isIgnoredFolder((File)d)) {
                return;
            }
            try {
                canPath = d.getCanonicalPath();
            }
            catch (IOException ex) {
                return;
            }
            if (!antiLoop.contains(canPath)) {
                antiLoop.add(canPath);
                this.subFolders.add(d.getAbsolutePath().replace('\\', '/'));
                File[] ff = d.listFiles();
                if (ff != null) {
                    for (int i = 0; i < ff.length; ++i) {
                        if (!ff[i].isDirectory()) continue;
                        this.gatherSubFolders(ff[i], antiLoop);
                    }
                }
            }
        }
    }

    private void initSearchMap() {
        for (String it : this.subFolders) {
            File[] ff;
            File d = new File(it);
            if (!d.exists() || !d.isDirectory() || !d.canRead() || (ff = d.listFiles()) == null) continue;
            for (int i = 0; i < ff.length; ++i) {
                if (!ff[i].isFile()) continue;
                List<String> l = this.findBase.get(ff[i].getName());
                if (l == null) {
                    l = new ArrayList<String>();
                    this.findBase.put(ff[i].getName(), l);
                }
                l.add(d.getAbsolutePath().replace('\\', '/'));
            }
        }
    }

    static class CommandLineSource
    implements SourceFileProperties {
        private String compilePath;
        private String sourceName;
        private String fullName;
        private String compiler;
        private ItemProperties.LanguageKind language;
        private List<String> userIncludes;
        private List<String> systemIncludes = Collections.emptyList();
        private Map<String, String> userMacros;
        private Map<String, String> systemMacros = Collections.emptyMap();
        private Set<String> includedFiles = Collections.emptySet();
        private CompileLineStorage storage;
        private int handler = -1;

        CommandLineSource(LineInfo li, List<String> languageArtifacts, String compilePath, String sourcePath, List<String> userIncludes, Map<String, String> userMacros, CompileLineStorage storage) {
            this.language = li.getLanguage();
            if (languageArtifacts.contains("c")) {
                this.language = ItemProperties.LanguageKind.C;
            } else if (languageArtifacts.contains("c++")) {
                this.language = ItemProperties.LanguageKind.CPP;
            } else {
                String mime = MIMESupport.getKnownSourceFileMIMETypeByExtension((String)sourcePath);
                if ("text/x-c++".equals(mime)) {
                    if (li.getLanguage() != ItemProperties.LanguageKind.CPP) {
                        this.language = ItemProperties.LanguageKind.CPP;
                    }
                } else if ("text/x-c".equals(mime) && li.getLanguage() != ItemProperties.LanguageKind.C) {
                    this.language = ItemProperties.LanguageKind.C;
                }
            }
            this.compiler = li.compiler;
            this.compilePath = compilePath;
            this.sourceName = sourcePath;
            if (this.sourceName.startsWith("/")) {
                this.fullName = this.sourceName;
                this.sourceName = DiscoveryUtils.getRelativePath((String)compilePath, (String)this.sourceName);
            } else {
                this.fullName = compilePath + "/" + this.sourceName;
            }
            File file = new File(this.fullName);
            this.fullName = CndFileUtils.normalizeFile((File)file).getAbsolutePath();
            this.fullName = PathCache.getString(this.fullName);
            this.userIncludes = userIncludes;
            this.userMacros = userMacros;
            this.storage = storage;
            if (storage != null) {
                this.handler = storage.putCompileLine(li.compileLine);
            }
        }

        public String getCompilePath() {
            return this.compilePath;
        }

        public String getItemPath() {
            return this.fullName;
        }

        public String getCompileLine() {
            if (this.storage != null && this.handler != -1) {
                return this.storage.getCompileLine(this.handler);
            }
            return null;
        }

        public String getItemName() {
            return this.sourceName;
        }

        public List<String> getUserInludePaths() {
            return this.userIncludes;
        }

        public List<String> getSystemInludePaths() {
            return this.systemIncludes;
        }

        public Set<String> getIncludedFiles() {
            return this.includedFiles;
        }

        public Map<String, String> getUserMacros() {
            return this.userMacros;
        }

        public Map<String, String> getSystemMacros() {
            return this.systemMacros;
        }

        public ItemProperties.LanguageKind getLanguageKind() {
            return this.language;
        }

        public String getCompilerName() {
            return this.compiler;
        }

        public ItemProperties.LanguageStandard getLanguageStandard() {
            return ItemProperties.LanguageStandard.Unknown;
        }
    }

    static class LineInfo {
        public String compileLine;
        public String compiler;
        public CompilerType compilerType = CompilerType.UNKNOWN;

        LineInfo(String line) {
            this.compileLine = line;
        }

        ItemProperties.LanguageKind getLanguage() {
            switch (this.compilerType) {
                case C: {
                    return ItemProperties.LanguageKind.C;
                }
                case CPP: {
                    return ItemProperties.LanguageKind.CPP;
                }
                case FORTRAN: {
                    return ItemProperties.LanguageKind.Fortran;
                }
            }
            return ItemProperties.LanguageKind.Unknown;
        }
    }

    static enum CompilerType {
        CPP,
        C,
        FORTRAN,
        UNKNOWN;

    }
}

