/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.switcher;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class SwitchProjectAction
extends NodeAction {
    private JCheckBoxMenuItem presenter;
    private ModelImpl model;
    private final AtomicBoolean running = new AtomicBoolean(false);

    public SwitchProjectAction() {
        this.presenter = new JCheckBoxMenuItem(this.getName());
        this.presenter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwitchProjectAction.this.onActionPerformed();
            }
        });
        CsmModel aModel = CsmModelAccessor.getModel();
        if (aModel instanceof ModelImpl) {
            this.model = (ModelImpl)aModel;
        }
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_SwitchProjectAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public JMenuItem getMenuPresenter() {
        return this.getPresenter();
    }

    public JMenuItem getPopupPresenter() {
        return this.getPresenter();
    }

    private JMenuItem getPresenter() {
        Collection<NativeProject> projects = this.getNativeProjects(this.getActivatedNodes());
        if (projects == null) {
            this.presenter.setEnabled(!this.running.get());
            this.presenter.setSelected(false);
        } else {
            try {
                State state = this.getState(projects);
                if (state == State.Indeterminate) {
                    this.presenter.setEnabled(!this.running.get());
                    this.presenter.setSelected(false);
                } else {
                    this.presenter.setEnabled(!this.running.get());
                    this.presenter.setSelected(state == State.Enabled);
                }
            }
            catch (Throwable thr) {
                thr.printStackTrace(System.err);
                this.presenter.setEnabled(false);
                this.presenter.setSelected(true);
            }
        }
        return this.presenter;
    }

    private Collection<NativeProject> getNativeProjects(Node[] nodes) {
        ArrayList<NativeProject> projects = new ArrayList<NativeProject>();
        for (int i = 0; i < nodes.length; ++i) {
            Object o = nodes[i].getValue("Project");
            if (!(o instanceof Project)) {
                return null;
            }
            NativeProject nativeProject = (NativeProject)((Project)o).getLookup().lookup(NativeProject.class);
            if (nativeProject == null) {
                return null;
            }
            projects.add(nativeProject);
        }
        return projects;
    }

    private State getState(Collection<NativeProject> projects) {
        if (this.model == null) {
            return State.Indeterminate;
        }
        State state = State.Indeterminate;
        for (NativeProject p : projects) {
            State curr = this.getState(p);
            if (state == State.Indeterminate) {
                state = curr;
                continue;
            }
            if (state == curr) continue;
            return State.Indeterminate;
        }
        return state;
    }

    private State getState(NativeProject p) {
        return this.model.isProjectEnabled(p) ? State.Enabled : State.Disabled;
    }

    protected boolean enable(Node[] activatedNodes) {
        if (this.model == null) {
            return false;
        }
        if (this.running.get()) {
            return false;
        }
        Collection<NativeProject> projects = this.getNativeProjects(this.getActivatedNodes());
        if (projects == null) {
            return false;
        }
        return this.getState(projects) != State.Indeterminate;
    }

    private void onActionPerformed() {
        this.performAction(this.getActivatedNodes());
    }

    public void performAction(Node[] activatedNodes) {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        this.model.enqueue(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SwitchProjectAction.this.performAction(SwitchProjectAction.this.getNativeProjects(SwitchProjectAction.this.getActivatedNodes()));
                }
                finally {
                    SwitchProjectAction.this.running.set(false);
                }
            }
        }, (CharSequence)"Switching code model ON/OFF");
    }

    private void performAction(Collection<NativeProject> projects) {
        if (projects != null) {
            State state = this.getState(projects);
            switch (state) {
                case Enabled: {
                    for (NativeProject p : projects) {
                        this.model.disableProject(p);
                    }
                    break;
                }
                case Disabled: {
                    for (NativeProject p : projects) {
                        this.model.enableProject(p);
                    }
                    break;
                }
            }
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    private static enum State {
        Enabled,
        Disabled,
        Indeterminate;

    }
}

