/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api;

import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.netbeans.api.lexer.Token;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.Methods;
import org.netbeans.modules.groovy.editor.api.TypeVisitor;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;

public final class VariableScopeVisitor
extends TypeVisitor {
    private final Set<ASTNode> occurrences = new HashSet<ASTNode>();
    private final ASTNode leafParent;

    public VariableScopeVisitor(SourceUnit sourceUnit, AstPath path, BaseDocument doc, int cursorOffset) {
        super(sourceUnit, path, doc, cursorOffset, true);
        this.leafParent = path.leafParent();
    }

    public Set<ASTNode> getOccurrences() {
        return this.occurrences;
    }

    @Override
    protected void visitParameters(Parameter[] parameters, Variable variable) {
        for (Parameter parameter : parameters) {
            if (!parameter.getName().equals(variable.getName())) continue;
            this.occurrences.add(parameter);
            break;
        }
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression) {
        if (expression.isParameterSpecified() && this.leaf instanceof Variable) {
            this.visitParameters(expression.getParameters(), (Variable)((Object)this.leaf));
        }
        super.visitClosureExpression(expression);
    }

    @Override
    protected boolean isValidToken(Token<? extends GroovyTokenId> token) {
        return token.id() == GroovyTokenId.IDENTIFIER;
    }

    @Override
    public void visitVariableExpression(VariableExpression variableExpression) {
        if (this.leaf instanceof Variable && ((Variable)((Object)this.leaf)).getName().equals(variableExpression.getName())) {
            this.occurrences.add(variableExpression);
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof PropertyExpression) {
            PropertyExpression property = (PropertyExpression)this.leafParent;
            if (variableExpression.getName().equals(property.getPropertyAsString())) {
                this.occurrences.add(variableExpression);
                return;
            }
        }
        super.visitVariableExpression(variableExpression);
    }

    @Override
    public void visitDeclarationExpression(DeclarationExpression expression) {
        VariableExpression variable;
        MethodNode method;
        OffsetRange range;
        if (this.leaf instanceof DeclarationExpression) {
            String name;
            DeclarationExpression visitedDeclaration = expression;
            DeclarationExpression declaration = (DeclarationExpression)this.leaf;
            VariableExpression variable2 = declaration.getVariableExpression();
            VariableExpression visited = visitedDeclaration.getVariableExpression();
            if (!variable2.isDynamicTyped() && !visited.isDynamicTyped() && (name = variable2.getType().getNameWithoutPackage()).equals(visited.getType().getNameWithoutPackage())) {
                AstUtilities.FakeASTNode fakeNode = new AstUtilities.FakeASTNode(expression, name);
                this.occurrences.add(fakeNode);
            }
        } else if (this.leaf instanceof ClassExpression) {
            ClassExpression clazz = (ClassExpression)this.leaf;
            VariableExpression variable3 = expression.getVariableExpression();
            if (!variable3.isDynamicTyped() && clazz.getType().getName().equals(variable3.getType().getName())) {
                AstUtilities.FakeASTNode fakeNode = new AstUtilities.FakeASTNode(expression, clazz.getType().getNameWithoutPackage());
                this.occurrences.add(fakeNode);
            }
        } else if (this.leaf instanceof ClassNode) {
            ClassNode clazz = (ClassNode)this.leaf;
            VariableExpression variable4 = expression.getVariableExpression();
            if (!variable4.isDynamicTyped() && clazz.getName().equals(variable4.getType().getName())) {
                AstUtilities.FakeASTNode fakeNode = new AstUtilities.FakeASTNode(expression, clazz.getNameWithoutPackage());
                this.occurrences.add(fakeNode);
            }
        } else if (this.leaf instanceof MethodNode && (range = VariableScopeVisitor.getMethodReturnType(method = (MethodNode)this.leaf, this.doc, this.cursorOffset)) != OffsetRange.NONE && !(variable = expression.getVariableExpression()).isDynamicTyped() && !method.isDynamicReturnType() && variable.getType().getName().equals(method.getReturnType().getName())) {
            AstUtilities.FakeASTNode fakeNode = new AstUtilities.FakeASTNode(expression, method.getReturnType().getNameWithoutPackage());
            this.occurrences.add(fakeNode);
        }
        super.visitDeclarationExpression(expression);
    }

    @Override
    public void visitField(FieldNode fieldNode) {
        if (this.leaf instanceof Variable && ((Variable)((Object)this.leaf)).getName().equals(fieldNode.getName())) {
            this.occurrences.add(fieldNode);
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof PropertyExpression) {
            PropertyExpression property = (PropertyExpression)this.leafParent;
            if (fieldNode.getName().equals(property.getPropertyAsString())) {
                this.occurrences.add(fieldNode);
                return;
            }
        }
        super.visitField(fieldNode);
    }

    @Override
    public void visitMethod(MethodNode methodNode) {
        VariableScope variableScope = methodNode.getVariableScope();
        if (this.leaf instanceof Variable) {
            String name = ((Variable)((Object)this.leaf)).getName();
            if (variableScope != null && variableScope.getDeclaredVariable(name) != null) {
                return;
            }
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof PropertyExpression) {
            String name = ((ConstantExpression)this.leaf).getText();
            if (variableScope != null && variableScope.getDeclaredVariable(name) != null) {
                return;
            }
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof MethodCallExpression) {
            MethodCallExpression methodCallExpression = (MethodCallExpression)this.leafParent;
            if (Methods.isSameMethod(methodNode, methodCallExpression)) {
                this.occurrences.add(methodNode);
            }
        } else if (this.leaf instanceof MethodNode) {
            MethodNode method = (MethodNode)this.leaf;
            if (Methods.isSameMethod(methodNode, method)) {
                OffsetRange range = VariableScopeVisitor.getMethodReturnType(method, this.doc, this.cursorOffset);
                if (range != OffsetRange.NONE) {
                    AstUtilities.FakeASTNode fakeNode = new AstUtilities.FakeASTNode(methodNode, methodNode.getReturnType().getNameWithoutPackage());
                    this.occurrences.add(fakeNode);
                } else {
                    this.occurrences.add(methodNode);
                }
            }
        } else if (this.leaf instanceof ClassExpression) {
            ClassExpression clazz = (ClassExpression)this.leaf;
            if (methodNode.getReturnType().getName().equals(clazz.getType().getName())) {
                String simpleName = clazz.getType().getNameWithoutPackage();
                AstUtilities.FakeASTNode fakeNode = new AstUtilities.FakeASTNode(methodNode, simpleName);
                this.occurrences.add(fakeNode);
            }
        } else if (this.leaf instanceof DeclarationExpression) {
            String name;
            DeclarationExpression declaration = (DeclarationExpression)this.leaf;
            VariableExpression variable = declaration.getVariableExpression();
            if (!variable.isDynamicTyped() && !methodNode.isDynamicReturnType() && (name = variable.getType().getNameWithoutPackage()).equals(methodNode.getReturnType().getNameWithoutPackage())) {
                AstUtilities.FakeASTNode fakeNode = new AstUtilities.FakeASTNode(methodNode, name);
                this.occurrences.add(fakeNode);
            }
        } else if (this.leaf instanceof ClassNode) {
            ClassNode clazz = (ClassNode)this.leaf;
            if (!methodNode.isDynamicReturnType() && clazz.getName().equals(methodNode.getReturnType().getName())) {
                AstUtilities.FakeASTNode fakeNode = new AstUtilities.FakeASTNode(methodNode, clazz.getNameWithoutPackage());
                this.occurrences.add(fakeNode);
            }
        }
        super.visitMethod(methodNode);
    }

    @Override
    public void visitConstructor(ConstructorNode constructor) {
        VariableScope variableScope = constructor.getVariableScope();
        if (this.leaf instanceof Variable) {
            String name = ((Variable)((Object)this.leaf)).getName();
            if (variableScope != null && variableScope.getDeclaredVariable(name) != null) {
                return;
            }
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof PropertyExpression) {
            String name = ((ConstantExpression)this.leaf).getText();
            if (variableScope != null && variableScope.getDeclaredVariable(name) != null) {
                return;
            }
        } else if (this.leaf instanceof ConstructorCallExpression) {
            ConstructorCallExpression methodCallExpression = (ConstructorCallExpression)this.leaf;
            if (Methods.isSameConstructor(constructor, methodCallExpression)) {
                this.occurrences.add(constructor);
            }
        } else if (this.leaf instanceof ConstructorNode && Methods.isSameConstructor(constructor, (ConstructorNode)this.leaf)) {
            this.occurrences.add(constructor);
        }
        super.visitConstructor(constructor);
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression methodCall) {
        if (this.leaf instanceof MethodNode) {
            MethodNode method = (MethodNode)this.leaf;
            if (Methods.isSameMethod(method, methodCall) && VariableScopeVisitor.getMethodReturnType(method, this.doc, this.cursorOffset) == OffsetRange.NONE) {
                this.occurrences.add(methodCall);
            }
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof MethodCallExpression && Methods.isSameMethod(methodCall, (MethodCallExpression)this.leafParent)) {
            this.occurrences.add(methodCall);
        }
        super.visitMethodCallExpression(methodCall);
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        if (this.leaf instanceof ConstructorNode) {
            ConstructorNode constructor = (ConstructorNode)this.leaf;
            if (Methods.isSameConstructor(constructor, call)) {
                this.occurrences.add(call);
            }
        } else if (this.leaf instanceof ConstructorCallExpression && Methods.isSameConstuctor(call, (ConstructorCallExpression)this.leaf)) {
            this.occurrences.add(call);
        }
        super.visitConstructorCallExpression(call);
    }

    @Override
    public void visitClassExpression(ClassExpression clazz) {
        MethodNode method;
        OffsetRange range;
        if (this.leaf instanceof ClassNode) {
            ClassNode classNode = (ClassNode)this.leaf;
            if (clazz.getType().getName().equals(classNode.getName())) {
                this.occurrences.add(clazz);
            }
        } else if (this.leaf instanceof ClassExpression) {
            if (clazz.getType().getName().equals(((ClassExpression)this.leaf).getText())) {
                this.occurrences.add(clazz);
            }
        } else if (this.leaf instanceof DeclarationExpression) {
            DeclarationExpression declaration = (DeclarationExpression)this.leaf;
            VariableExpression variable = declaration.getVariableExpression();
            if (!variable.isDynamicTyped() && clazz.getType().getName().equals(variable.getType().getName())) {
                this.occurrences.add(clazz);
            }
        } else if (this.leaf instanceof MethodNode && (range = VariableScopeVisitor.getMethodReturnType(method = (MethodNode)this.leaf, this.doc, this.cursorOffset)) != OffsetRange.NONE) {
            this.occurrences.add(clazz);
        }
        super.visitClassExpression(clazz);
    }

    @Override
    public void visitClass(ClassNode classNode) {
        MethodNode method;
        OffsetRange range;
        if (this.leaf instanceof ClassExpression) {
            if (classNode.getName().equals(((ClassExpression)this.leaf).getText())) {
                this.occurrences.add(classNode);
            }
        } else if (this.leaf instanceof ClassNode) {
            if (classNode.getName().equals(((ClassNode)this.leaf).getName())) {
                this.occurrences.add(classNode);
            }
        } else if (this.leaf instanceof DeclarationExpression) {
            DeclarationExpression declaration = (DeclarationExpression)this.leaf;
            VariableExpression variable = declaration.getVariableExpression();
            if (!variable.isDynamicTyped() && classNode.getName().equals(variable.getType().getName())) {
                this.occurrences.add(classNode);
            }
        } else if (this.leaf instanceof MethodNode && (range = VariableScopeVisitor.getMethodReturnType(method = (MethodNode)this.leaf, this.doc, this.cursorOffset)) != OffsetRange.NONE && classNode.getName().equals(method.getReturnType().getName())) {
            this.occurrences.add(classNode);
        }
        super.visitClass(classNode);
    }

    @Override
    public void visitPropertyExpression(PropertyExpression node) {
        Expression property = node.getProperty();
        if (this.leaf instanceof Variable && ((Variable)((Object)this.leaf)).getName().equals(node.getPropertyAsString())) {
            this.occurrences.add(property);
        } else if (this.leaf instanceof ConstantExpression && this.leafParent instanceof PropertyExpression) {
            PropertyExpression propertyUnderCursor = (PropertyExpression)this.leafParent;
            String nodeAsString = node.getPropertyAsString();
            if (nodeAsString != null && nodeAsString.equals(propertyUnderCursor.getPropertyAsString())) {
                this.occurrences.add(property);
            }
        }
        super.visitPropertyExpression(node);
    }

    private static final OffsetRange getMethodReturnType(MethodNode method, BaseDocument doc, int cursorOffset) {
        OffsetRange range;
        int offset = AstUtilities.getOffset(doc, method.getLineNumber(), method.getColumnNumber());
        if (!method.isDynamicReturnType() && (range = AstUtilities.getNextIdentifierByName(doc, method.getReturnType().getNameWithoutPackage(), offset)).containsInclusive(cursorOffset)) {
            return range;
        }
        return OffsetRange.NONE;
    }
}

