/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.api.ui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.api.ui.FileObjectBasedFile;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

final class RemoteFileSystemView
extends FileSystemView {
    public static final String LOADING_STATUS = "ls";
    private final FileSystem fs;
    private final PropertyChangeSupport changeSupport;
    private final ExecutionEnvironment env;
    private static final String newFolderString = UIManager.getString("FileChooser.other.newFolder");
    private static final String newFolderNextString = UIManager.getString("FileChooser.other.newFolder.subsequent");

    public RemoteFileSystemView(String root, ExecutionEnvironment execEnv) {
        this.env = execEnv;
        this.fs = FileSystemProvider.getFileSystem(execEnv, root);
        assert (this.fs != null);
        this.changeSupport = new PropertyChangeSupport(this);
    }

    public FileObject getFSRoot() {
        return this.fs.getRoot();
    }

    @Override
    public File createFileObject(String path) {
        RemoteLogger.getInstance().log(Level.FINEST, "RFSV: creating file for {0}", path);
        FileObject fo = this.fs.findResource(path);
        if (fo == null || !fo.isValid()) {
            RemoteLogger.getInstance().log(Level.FINEST, "Null file object for {0}", path);
            return new FileObjectBasedFile(this.env, path);
        }
        return new FileObjectBasedFile(this.env, fo);
    }

    @Override
    public File createFileObject(File dir, String filename) {
        String parent;
        String string = parent = dir == null ? this.fs.getRoot().getPath() : dir.getPath();
        if (RemoteFileSystemView.isAbsolute(filename)) {
            return this.createFileObject(filename);
        }
        return this.createFileObject(parent + "/" + filename);
    }

    private static boolean isAbsolute(String fileName) {
        return fileName.length() > 0 && fileName.charAt(0) == '/';
    }

    @Override
    public File[] getRoots() {
        return new File[]{new FileObjectBasedFile(this.env, this.fs.getRoot())};
    }

    @Override
    public String getSystemDisplayName(File f) {
        return "".equals(f.getName()) ? "/" : f.getName();
    }

    @Override
    public File getDefaultDirectory() {
        return new FileObjectBasedFile(this.env, this.fs.getRoot());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getHomeDirectory() {
        try {
            this.changeSupport.firePropertyChange(LOADING_STATUS, null, "${HOME}");
            if (!HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)this.env) && !ConnectionManager.getInstance().isConnectedTo(this.env)) {
                File file = this.getDefaultDirectory();
                return file;
            }
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.env);
            FileObjectBasedFile fileObjectBasedFile = new FileObjectBasedFile(this.env, this.fs.findResource(hostInfo.getUserDir()));
            return fileObjectBasedFile;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ConnectionManager.CancellationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            this.changeSupport.firePropertyChange(LOADING_STATUS, "${HOME}", null);
        }
        return this.getDefaultDirectory();
    }

    @Override
    public boolean isFileSystem(File f) {
        return true;
    }

    @Override
    public File getParentDirectory(File dir) {
        if (dir == null) {
            return null;
        }
        File parentFile = dir.getParentFile();
        return parentFile == null ? null : this.createFileObject(parentFile.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File[] getFiles(File dir, boolean useFileHiding) {
        this.changeSupport.firePropertyChange(LOADING_STATUS, null, dir.getAbsolutePath());
        try {
            if (!(dir instanceof FileObjectBasedFile)) {
                dir = new FileObjectBasedFile(this.env, this.fs.findResource(dir.getAbsolutePath()));
            }
            FileObjectBasedFile rdir = (FileObjectBasedFile)dir;
            File[] result = null;
            if (dir.canRead()) {
                result = useFileHiding ? rdir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return !name.startsWith(".");
                    }
                }) : rdir.listFiles();
            }
            File[] fileArray = result == null ? new File[]{} : result;
            return fileArray;
        }
        finally {
            this.changeSupport.firePropertyChange(LOADING_STATUS, dir.getAbsolutePath(), null);
        }
    }

    @Override
    public File createNewFolder(File containingDir) throws IOException {
        if (containingDir == null) {
            throw new IOException("Containing directory is null:");
        }
        File newFolder = null;
        newFolder = this.createFileObject(containingDir, newFolderString);
        for (int i = 1; newFolder.exists() && i < 100; ++i) {
            newFolder = this.createFileObject(containingDir, MessageFormat.format(newFolderNextString, new Integer(i)));
        }
        if (newFolder.exists()) {
            throw new IOException("Directory already exists:" + newFolder.getAbsolutePath());
        }
        newFolder.mkdirs();
        return newFolder;
    }

    @Override
    protected File createFileSystemRoot(File f) {
        return new FileObjectBasedFile(this.env, this.fs.getRoot());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public Icon getSystemIcon(File f) {
        return UIManager.getIcon(f == null || f.isDirectory() ? "FileView.directoryIcon" : "FileView.fileIcon");
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.env;
    }
}

