/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.ChildNodeFactory;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.explorer.node.ProcedureNodeProvider;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Procedure;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ProcedureNode
extends BaseNode {
    private static final String ICON_VALID_P = "org/netbeans/modules/db/resources/procedure.png";
    private static final String ICON_VALID_F = "org/netbeans/modules/db/resources/function.png";
    private static final String ICON_VALID_T = "org/netbeans/modules/db/resources/trigger.png";
    private static final String ICON_INVALID_P = "org/netbeans/modules/db/resources/procedure-invalid.png";
    private static final String ICON_INVALID_F = "org/netbeans/modules/db/resources/function-invalid.png";
    private static final String ICON_INVALID_T = "org/netbeans/modules/db/resources/trigger-invalid.png";
    private static final String FOLDER = "Procedure";
    private static final String DELIMITER = "@@";
    private static final String SPACE = " ";
    private static final String NEW_LINE = "\n";
    private static String TRIGGER = "TRIGGER";
    private static String FUNCTION = "FUNCTION";
    private static String PROCEDURE = "PROCEDURE";
    private String name = "";
    private final MetadataElementHandle<Procedure> procedureHandle;
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private Type type;
    private String schemaName;
    private String catalogName;

    public static ProcedureNode create(NodeDataLookup dataLookup, ProcedureNodeProvider provider, String schema) {
        DatabaseConnection conn = (DatabaseConnection)dataLookup.lookup(DatabaseConnection.class);
        ProcedureNode node = conn != null && "MySQL".equalsIgnoreCase(conn.getDriverName()) ? new MySQL(dataLookup, provider, schema) : (conn != null && conn.getDriverName() != null && conn.getDriverName().startsWith("Oracle") ? new Oracle(dataLookup, provider, schema) : new ProcedureNode(dataLookup, provider));
        node.setup();
        return node;
    }

    private ProcedureNode(NodeDataLookup lookup, NodeProvider provider) {
        super(new ChildNodeFactory((Lookup)lookup), lookup, FOLDER, provider);
        this.procedureHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    }

    @Override
    protected void initialize() {
        boolean connected = !this.connection.getConnector().isDisconnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Procedure proc = (Procedure)ProcedureNode.this.procedureHandle.resolve(metaData);
                        ProcedureNode.this.name = proc.getName();
                        ProcedureNode.this.type = proc.getReturnValue() == null ? Type.Procedure : Type.Function;
                        ProcedureNode.this.updateProperties(proc);
                        ProcedureNode.this.schemaName = proc.getParent().getName();
                        ProcedureNode.this.catalogName = proc.getParent().getParent().getName();
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(((Object)((Object)this)).getClass(), this.connection, e, true);
            }
        }
    }

    private void updateProperties(Procedure proc) {
        PropertySupport.Name ps = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)ps);
        if (proc.getReturnValue() == null) {
            this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureNode.class, (String)"StoredProcedure"));
        } else {
            this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureNode.class, (String)"StoredFunction"));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.getName();
    }

    protected Type getType() {
        return this.type;
    }

    @Override
    public String getIconBase() {
        if (this.getType() == null) {
            return null;
        }
        switch (this.getType()) {
            case Function: {
                return ICON_VALID_F;
            }
            case Procedure: {
                return ICON_VALID_P;
            }
            case Trigger: {
                return ICON_VALID_T;
            }
        }
        return null;
    }

    public String getShortDescription() {
        switch (this.getType()) {
            case Function: {
                return NbBundle.getMessage(ProcedureNode.class, (String)"ND_Function");
            }
            case Procedure: {
                return NbBundle.getMessage(ProcedureNode.class, (String)"ND_Procedure");
            }
            case Trigger: {
                return NbBundle.getMessage(ProcedureNode.class, (String)"ND_Trigger");
            }
        }
        return null;
    }

    @Override
    public boolean canDestroy() {
        DatabaseConnector connector = this.connection.getConnector();
        return connector.supportsCommand("DropProcedureCommand");
    }

    @Override
    public void destroy() {
        DatabaseConnector connector = this.connection.getConnector();
        Specification spec = connector.getDatabaseSpecification();
        try {
            AbstractCommand command = null;
            switch (this.getType()) {
                case Function: {
                    command = spec.createCommandDropFunction(this.getName());
                    break;
                }
                case Procedure: {
                    command = spec.createCommandDropProcedure(this.getName());
                    break;
                }
                case Trigger: {
                    command = spec.createCommandDropTrigger(this.getName());
                    break;
                }
                default: {
                    assert (false) : "Unknown type " + (Object)((Object)this.getType());
                    break;
                }
            }
            if (command == null) {
                Logger.getLogger(ProcedureNode.class.getName()).log(Level.INFO, "No command found for droping " + this.getName());
                return;
            }
            if (this.getOwner() != null) {
                command.setObjectOwner(this.getOwner());
            }
            command.execute();
            this.remove();
        }
        catch (DDLException e) {
            Logger.getLogger(ProcedureNode.class.getName()).log(Level.INFO, e + " while deleting " + ProcedureNode.getTypeName(this.getType()) + SPACE + this.getName());
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)e.getMessage(), 0));
        }
        catch (Exception e) {
            Logger.getLogger(ProcedureNode.class.getName()).log(Level.INFO, e + " while deleting " + ProcedureNode.getTypeName(this.getType()) + SPACE + this.getName());
        }
    }

    private String getOwner() {
        String owner = null;
        owner = this.schemaName == null ? this.catalogName : this.schemaName;
        return owner;
    }

    public boolean isViewSourceSupported() {
        return false;
    }

    public boolean isEditSourceSupported() {
        return false;
    }

    public String getParams() {
        return "";
    }

    public String getBody() {
        return "";
    }

    public String getSource() {
        return "";
    }

    public String getDDL() {
        return "";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ProcedureNode.class);
    }

    private static String getTypeName(Type t) {
        String name = "";
        switch (t) {
            case Function: {
                name = FUNCTION;
                break;
            }
            case Procedure: {
                name = PROCEDURE;
                break;
            }
            case Trigger: {
                name = TRIGGER;
                break;
            }
            default: {
                assert (false) : "Unknown type " + (Object)((Object)t);
                break;
            }
        }
        return name;
    }

    public static class Oracle
    extends ProcedureNode {
        private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
        private final ProcedureNodeProvider provider;
        private final String schema;

        private Oracle(NodeDataLookup lookup, ProcedureNodeProvider provider, String schema) {
            super(lookup, provider);
            this.provider = provider;
            this.schema = schema;
        }

        @Override
        protected void initialize() {
            super.initialize();
            this.updateProcedureProperties();
        }

        private void updateProcedureProperties() {
            PropertySupport.Name ps = new PropertySupport.Name((Node)this);
            this.addProperty((Node.Property)ps);
            switch (this.provider.getType(this.getName())) {
                case Function: {
                    this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureNode.class, (String)"StoredFunction"));
                    break;
                }
                case Procedure: {
                    this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureNode.class, (String)"StoredProcedure"));
                    break;
                }
                case Trigger: {
                    this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureNode.class, (String)"StoredTrigger"));
                    break;
                }
                default: {
                    assert (false) : "Unknown type " + (Object)((Object)this.provider.getType(this.getName()));
                    break;
                }
            }
        }

        @Override
        public Type getType() {
            return this.provider.getType(this.getName());
        }

        @Override
        public String getShortDescription() {
            switch (this.provider.getType(this.getName())) {
                case Function: {
                    return this.provider.getStatus(this.getName()) ? NbBundle.getMessage(ProcedureNode.class, (String)"ND_Function") : NbBundle.getMessage(ProcedureNode.class, (String)"ND_Function_Invalid");
                }
                case Procedure: {
                    return this.provider.getStatus(this.getName()) ? NbBundle.getMessage(ProcedureNode.class, (String)"ND_Procedure") : NbBundle.getMessage(ProcedureNode.class, (String)"ND_Procedure_Invalid");
                }
                case Trigger: {
                    return this.provider.getStatus(this.getName()) ? NbBundle.getMessage(ProcedureNode.class, (String)"ND_Trigger") : NbBundle.getMessage(ProcedureNode.class, (String)"ND_Trigger_Invalid");
                }
            }
            return null;
        }

        @Override
        public String getIconBase() {
            Type type = this.getType();
            if (type == null) {
                return null;
            }
            switch (type) {
                case Function: {
                    return this.provider.getStatus(this.getName()) ? ProcedureNode.ICON_VALID_F : ProcedureNode.ICON_INVALID_F;
                }
                case Procedure: {
                    return this.provider.getStatus(this.getName()) ? ProcedureNode.ICON_VALID_P : ProcedureNode.ICON_INVALID_P;
                }
                case Trigger: {
                    return this.provider.getStatus(this.getName()) ? ProcedureNode.ICON_VALID_T : ProcedureNode.ICON_INVALID_T;
                }
            }
            return null;
        }

        @Override
        public boolean isViewSourceSupported() {
            return true;
        }

        @Override
        public String getBody() {
            String source = this.getSource();
            String body = "";
            int beginIdx = source.indexOf("BEGIN");
            if (beginIdx != -1) {
                body = source.substring(beginIdx);
            }
            return body;
        }

        @Override
        public String getParams() {
            String source = this.getSource();
            String params = "";
            int beginIdx = source.indexOf("BEGIN");
            int lIdx = source.indexOf(40);
            int rIdx = source.indexOf(41);
            if (lIdx != -1 && rIdx != -1 && lIdx < beginIdx) {
                params = source.substring(lIdx, rIdx + 1);
            }
            return params;
        }

        @Override
        public String getSource() {
            StringBuilder sb = new StringBuilder();
            String owner = "";
            try {
                Statement stat = this.connection.getConnection().createStatement();
                String q = "SELECT TEXT, OWNER FROM SYS.ALL_SOURCE WHERE NAME = '" + this.getName() + "' AND OWNER='" + this.schema.toUpperCase() + "'" + " ORDER BY LINE";
                ResultSet rs = stat.executeQuery(q);
                while (rs.next()) {
                    sb.append(rs.getString("text"));
                    owner = rs.getString("owner");
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(ProcedureNode.class.getName()).log(Level.INFO, ex + " while get source of " + ProcedureNode.getTypeName(this.getType()) + ProcedureNode.SPACE + this.getName());
            }
            return this.fqn(sb.toString(), owner);
        }

        @Override
        public boolean isEditSourceSupported() {
            return true;
        }

        @Override
        public String getDDL() {
            StringBuilder expression = new StringBuilder();
            expression.append("DELIMITER ").append(ProcedureNode.DELIMITER).append(ProcedureNode.NEW_LINE);
            expression.append("CREATE OR REPLACE ").append(this.getSource());
            expression.append(ProcedureNode.SPACE).append(ProcedureNode.DELIMITER).append(ProcedureNode.NEW_LINE);
            expression.append("DELIMITER ; ").append(ProcedureNode.NEW_LINE);
            return expression.toString();
        }

        private String fqn(String source, String owner) {
            String upperSource = source.toUpperCase();
            String toFind = ProcedureNode.getTypeName(this.getType()) + ProcedureNode.SPACE;
            String res = source;
            int nameIdx = upperSource.indexOf(toFind);
            if (nameIdx != -1) {
                if (upperSource.substring(nameIdx + toFind.length()).trim().startsWith(owner.toUpperCase() + '.')) {
                    return source;
                }
                res = source.substring(0, nameIdx + toFind.length()) + owner + '.' + source.substring(nameIdx + toFind.length()).trim();
            }
            return res;
        }
    }

    public static class MySQL
    extends ProcedureNode {
        private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
        private final ProcedureNodeProvider provider;

        private MySQL(NodeDataLookup lookup, ProcedureNodeProvider provider, String schema) {
            super(lookup, provider);
            this.provider = provider;
        }

        @Override
        protected void initialize() {
            super.initialize();
            this.updateProcedureProperties();
        }

        private void updateProcedureProperties() {
            PropertySupport.Name ps = new PropertySupport.Name((Node)this);
            this.addProperty((Node.Property)ps);
            switch (this.provider.getType(this.getName())) {
                case Function: {
                    this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureNode.class, (String)"StoredFunction"));
                    break;
                }
                case Procedure: {
                    this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureNode.class, (String)"StoredProcedure"));
                    break;
                }
                case Trigger: {
                    this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ProcedureNode.class, (String)"StoredTrigger"));
                    break;
                }
                default: {
                    assert (false) : "Unknown type " + (Object)((Object)this.provider.getType(this.getName()));
                    break;
                }
            }
        }

        @Override
        public Type getType() {
            return this.provider.getType(this.getName());
        }

        @Override
        public String getShortDescription() {
            switch (this.provider.getType(this.getName())) {
                case Function: {
                    return this.provider.getStatus(this.getName()) ? NbBundle.getMessage(ProcedureNode.class, (String)"ND_Function") : NbBundle.getMessage(ProcedureNode.class, (String)"ND_Function_Invalid");
                }
                case Procedure: {
                    return this.provider.getStatus(this.getName()) ? NbBundle.getMessage(ProcedureNode.class, (String)"ND_Procedure") : NbBundle.getMessage(ProcedureNode.class, (String)"ND_Procedure_Invalid");
                }
                case Trigger: {
                    return this.provider.getStatus(this.getName()) ? NbBundle.getMessage(ProcedureNode.class, (String)"ND_Trigger") : NbBundle.getMessage(ProcedureNode.class, (String)"ND_Trigger_Invalid");
                }
            }
            return null;
        }

        @Override
        public String getIconBase() {
            Type type = this.getType();
            if (type == null) {
                return null;
            }
            switch (type) {
                case Function: {
                    return this.provider.getStatus(this.getName()) ? ProcedureNode.ICON_VALID_F : ProcedureNode.ICON_INVALID_F;
                }
                case Procedure: {
                    return this.provider.getStatus(this.getName()) ? ProcedureNode.ICON_VALID_P : ProcedureNode.ICON_INVALID_P;
                }
                case Trigger: {
                    return this.provider.getStatus(this.getName()) ? ProcedureNode.ICON_VALID_T : ProcedureNode.ICON_INVALID_T;
                }
            }
            return null;
        }

        @Override
        public boolean isViewSourceSupported() {
            return true;
        }

        @Override
        public String getSource() {
            String source = "";
            try {
                switch (this.getType()) {
                    case Function: 
                    case Procedure: {
                        Statement stat = this.connection.getConnection().createStatement();
                        ResultSet rs = stat.executeQuery("SELECT param_list, body, db FROM mysql.proc WHERE name = '" + this.getName() + "';");
                        while (rs.next()) {
                            String parent = rs.getString("db");
                            parent = parent != null && parent.trim().length() > 0 ? parent + '.' : "";
                            String params = rs.getString("param_list");
                            String body = rs.getString("body");
                            source = ProcedureNode.getTypeName(this.getType()) + ProcedureNode.SPACE + parent + this.getName() + '\n' + '(' + params + ")" + '\n' + body;
                        }
                        break;
                    }
                    case Trigger: {
                        Statement stat2 = this.connection.getConnection().createStatement();
                        ResultSet rs2 = stat2.executeQuery("SELECT ACTION_STATEMENT, EVENT_OBJECT_SCHEMA, EVENT_OBJECT_TABLE, ACTION_TIMING, EVENT_MANIPULATION, TRIGGER_SCHEMA FROM information_schema.triggers WHERE TRIGGER_NAME = '" + this.getName() + "';");
                        while (rs2.next()) {
                            String parent = rs2.getString("TRIGGER_SCHEMA");
                            parent = parent != null && parent.trim().length() > 0 ? parent + '.' : "";
                            String trigger_body = rs2.getString("ACTION_STATEMENT");
                            String trigger_time = rs2.getString("ACTION_TIMING");
                            String trigger_event = rs2.getString("EVENT_MANIPULATION");
                            String tbl_schema = rs2.getString("EVENT_OBJECT_SCHEMA");
                            String tbl_table_name = rs2.getString("EVENT_OBJECT_TABLE");
                            String tbl_name = tbl_schema == null || tbl_schema.length() == 0 ? tbl_table_name : tbl_schema + '.' + tbl_table_name;
                            source = TRIGGER + ProcedureNode.SPACE + parent + this.getName() + '\n' + trigger_time + ' ' + trigger_event + " ON " + tbl_name + '\n' + "FOR EACH ROW" + '\n' + trigger_body;
                        }
                        break;
                    }
                    default: {
                        assert (false) : "Unknown type" + (Object)((Object)this.getType());
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(ProcedureNode.class.getName()).log(Level.INFO, ex + " while get source of " + ProcedureNode.getTypeName(this.getType()) + ProcedureNode.SPACE + this.getName());
            }
            return source;
        }

        @Override
        public String getParams() {
            String params = "";
            try {
                switch (this.getType()) {
                    case Function: 
                    case Procedure: {
                        Statement stat = this.connection.getConnection().createStatement();
                        ResultSet rs = stat.executeQuery("SELECT param_list FROM mysql.proc WHERE name = '" + this.getName() + "';");
                        while (rs.next()) {
                            params = rs.getString("param_list");
                        }
                        break;
                    }
                    case Trigger: {
                        Statement stat2 = this.connection.getConnection().createStatement();
                        ResultSet rs2 = stat2.executeQuery("SELECT ACTION_STATEMENT, EVENT_OBJECT_SCHEMA, EVENT_OBJECT_TABLE, ACTION_TIMING, EVENT_MANIPULATION FROM information_schema.triggers WHERE TRIGGER_NAME = '" + this.getName() + "';");
                        while (rs2.next()) {
                            String trigger_time = rs2.getString("ACTION_TIMING");
                            String trigger_event = rs2.getString("EVENT_MANIPULATION");
                            String tbl_schema = rs2.getString("EVENT_OBJECT_SCHEMA");
                            String tbl_table_name = rs2.getString("EVENT_OBJECT_TABLE");
                            String tbl_name = tbl_schema == null || tbl_schema.length() == 0 ? tbl_table_name : tbl_schema + '.' + tbl_table_name;
                            params = trigger_time + ' ' + trigger_event + " ON " + tbl_name + '\n' + "FOR EACH ROW" + '\n';
                        }
                        break;
                    }
                    default: {
                        assert (false) : "Unknown type " + (Object)((Object)this.getType());
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(ProcedureNode.class.getName()).log(Level.INFO, ex + " while get params of " + ProcedureNode.getTypeName(this.getType()) + ProcedureNode.SPACE + this.getName());
            }
            return params;
        }

        @Override
        public String getBody() {
            String body = "";
            try {
                switch (this.getType()) {
                    case Function: 
                    case Procedure: {
                        Statement stat = this.connection.getConnection().createStatement();
                        ResultSet rs = stat.executeQuery("SELECT body FROM mysql.proc WHERE name = '" + this.getName() + "';");
                        while (rs.next()) {
                            body = rs.getString("body");
                        }
                        break;
                    }
                    case Trigger: {
                        Statement stat2 = this.connection.getConnection().createStatement();
                        ResultSet rs2 = stat2.executeQuery("SELECT ACTION_STATEMENT FROM information_schema.triggers WHERE TRIGGER_NAME = '" + this.getName() + "';");
                        while (rs2.next()) {
                            body = rs2.getString("ACTION_STATEMENT");
                        }
                        break;
                    }
                    default: {
                        assert (false) : "Unknown type" + (Object)((Object)this.getType());
                    }
                }
            }
            catch (SQLException ex) {
                Logger.getLogger(ProcedureNode.class.getName()).log(Level.INFO, ex + " while get body of " + ProcedureNode.getTypeName(this.getType()) + ProcedureNode.SPACE + this.getName());
            }
            return body;
        }

        @Override
        public boolean isEditSourceSupported() {
            return true;
        }

        @Override
        public String getDDL() {
            StringBuilder expression = new StringBuilder();
            expression.append("DELIMITER ").append(ProcedureNode.DELIMITER).append(ProcedureNode.NEW_LINE);
            expression.append("DROP ").append(ProcedureNode.getTypeName(this.getType())).append(ProcedureNode.SPACE).append(this.getName()).append(ProcedureNode.SPACE).append(ProcedureNode.DELIMITER).append(ProcedureNode.NEW_LINE);
            expression.append("CREATE ").append(this.getSource());
            expression.append(ProcedureNode.SPACE).append(ProcedureNode.DELIMITER).append(ProcedureNode.SPACE).append(ProcedureNode.NEW_LINE);
            expression.append("DELIMITER ; ").append(ProcedureNode.NEW_LINE);
            return expression.toString();
        }
    }

    public static enum Type {
        Procedure,
        Function,
        Trigger;

    }
}

