/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.mobility.antext.preprocessor.CommentingPreProcessor;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ui.J2MECustomizerProvider;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public final class ProjectConfigurationsHelper
implements ProjectConfigurationProvider<ProjectConfiguration>,
AntProjectListener {
    public static final String PROJ_PROP_CONFIGURATION_ACTIVE = "config.active";
    public static final String DEFAULT_CONFIGURATION_NAME = "DefaultConfiguration";
    public static final String PROJECT_PROPERTIES = "ProjectProperties";
    protected final AntProjectHelper h;
    private TreeMap<String, ProjectConfiguration> configurations;
    private PropertyChangeSupport psp;
    private ProjectConfiguration activeConfiguration;
    private ProjectConfiguration defaultConfiguration;
    private J2MEProject p;
    private boolean preprocessorOn;
    private boolean invalid = true;

    public ProjectConfigurationsHelper(AntProjectHelper helper, J2MEProject p) {
        this.h = helper;
        this.p = p;
    }

    public boolean isPreprocessorOn() {
        if (this.invalid) {
            String prop = this.h.getStandardPropertyEvaluator().getProperty("use.preprocessor");
            this.preprocessorOn = prop == null || Boolean.parseBoolean(prop);
            this.invalid = false;
        }
        return this.preprocessorOn;
    }

    public ProjectConfiguration getDefaultConfiguration() {
        if (this.defaultConfiguration == null) {
            this.defaultConfiguration = this.createConfiguration(DEFAULT_CONFIGURATION_NAME);
        }
        return this.defaultConfiguration;
    }

    public final boolean addConfiguration(final String configName) {
        if (configName == null || configName.equals(this.getDefaultConfiguration().getDisplayName())) {
            return false;
        }
        boolean ret = (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                EditableProperties props = ProjectConfigurationsHelper.this.h.getProperties("nbproject/project.properties");
                String cfgs = props.getProperty("all.configurations");
                if (cfgs == null) {
                    cfgs = "";
                }
                boolean add = true;
                StringBuffer sb = new StringBuffer(" ");
                for (String s : cfgs.split(",")) {
                    if (s.trim().length() <= 0) continue;
                    int i = s.compareTo(configName);
                    if (i == 0) {
                        return Boolean.FALSE;
                    }
                    if (add && i > 0) {
                        add = false;
                        sb.append(',').append(configName);
                    }
                    sb.append(',').append(s);
                }
                if (add) {
                    sb.append(',').append(configName);
                }
                props.put("all.configurations", sb.toString());
                ProjectConfigurationsHelper.this.h.putProperties("nbproject/project.properties", props);
                return Boolean.TRUE;
            }
        });
        try {
            ProjectManager.getDefault().saveProject((Project)this.p);
            return ret;
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            return false;
        }
    }

    public Map<String, String> getAbilitiesFor(ProjectConfiguration cfg) {
        String abilities = J2MEProjectUtils.evaluateProperty(this.h, "abilities", cfg.getDisplayName());
        Map<String, String> m = abilities == null ? new HashMap() : CommentingPreProcessor.decodeAbilitiesMap((String)abilities);
        m.put("DebugLevel", J2MEProjectUtils.evaluateProperty(this.h, "debug.level", cfg.getDisplayName()));
        return m;
    }

    public Map<String, String> getActiveAbilities() {
        return this.getAbilitiesFor(this.getActiveConfiguration());
    }

    public Set<String> getAllIdentifiers(boolean includeConfigNames) {
        TreeSet<String> s = new TreeSet<String>();
        ProjectConfiguration[] devConfigs = this.getConfigurations().toArray(new ProjectConfiguration[0]);
        for (int i = 0; i < devConfigs.length; ++i) {
            if (includeConfigNames) {
                s.add(devConfigs[i].getDisplayName());
            }
            String propName = this.getDefaultConfiguration().equals(devConfigs[i]) ? "abilities" : "configs." + devConfigs[i].getDisplayName() + '.' + "abilities";
            String prop = this.h.getStandardPropertyEvaluator().getProperty(propName);
            if (prop == null) continue;
            s.addAll(CommentingPreProcessor.decodeAbilitiesMap((String)prop).keySet());
        }
        return s;
    }

    public final boolean removeConfiguration(final ProjectConfiguration config) {
        if (config == null || config.equals(this.getDefaultConfiguration())) {
            return false;
        }
        boolean ret = (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                EditableProperties props = ProjectConfigurationsHelper.this.h.getProperties("nbproject/project.properties");
                String cfgs = props.getProperty("all.configurations");
                if (cfgs == null) {
                    return Boolean.FALSE;
                }
                boolean succ = false;
                StringBuffer sb = new StringBuffer();
                for (String s : cfgs.split(",")) {
                    if (s.equals(config.getDisplayName())) {
                        succ = true;
                        continue;
                    }
                    if (sb.length() > 0) {
                        sb.append(',');
                    }
                    sb.append(s);
                }
                if (succ) {
                    String projProp = "configs." + config.getDisplayName();
                    for (String key : props.keySet().toArray(new String[0])) {
                        if (!key.startsWith(projProp)) continue;
                        props.remove((Object)key);
                    }
                    props.put("all.configurations", sb.toString());
                    ProjectConfigurationsHelper.this.h.putProperties("nbproject/project.properties", props);
                }
                return succ;
            }
        });
        try {
            ProjectManager.getDefault().saveProject((Project)this.p);
            return ret;
        }
        catch (IOException ioe) {
            ErrorManager.getDefault().notify((Throwable)ioe);
            return false;
        }
    }

    public final Collection<ProjectConfiguration> getConfigurations() {
        return this.getConfigurations(this.configurations);
    }

    private final Collection<ProjectConfiguration> getConfigurations(final TreeMap<String, ProjectConfiguration> oldConfig) {
        if (this.configurations == null) {
            this.configurations = (TreeMap)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<TreeMap<String, ProjectConfiguration>>(){

                public TreeMap<String, ProjectConfiguration> run() {
                    TreeMap<String, ProjectConfiguration> newByName = new TreeMap<String, ProjectConfiguration>(new Comparator<String>(){

                        @Override
                        public int compare(String o1, String o2) {
                            return ProjectConfigurationsHelper.DEFAULT_CONFIGURATION_NAME.equals(o1) ? (ProjectConfigurationsHelper.DEFAULT_CONFIGURATION_NAME.equals(o2) ? 0 : -1) : (ProjectConfigurationsHelper.DEFAULT_CONFIGURATION_NAME.equals(o2) ? 1 : o1.compareToIgnoreCase(o2));
                        }
                    });
                    newByName.put(ProjectConfigurationsHelper.this.getDefaultConfiguration().getDisplayName(), ProjectConfigurationsHelper.this.getDefaultConfiguration());
                    String cfgs = ProjectConfigurationsHelper.this.h.getProperties("nbproject/project.properties").getProperty("all.configurations");
                    if (cfgs != null) {
                        for (String configName : cfgs.split(",")) {
                            if (configName.length() <= 0 || configName.equals(" ")) continue;
                            ProjectConfiguration conf = oldConfig == null ? null : (ProjectConfiguration)oldConfig.get(configName);
                            newByName.put(configName, conf == null ? ProjectConfigurationsHelper.this.createConfiguration(configName) : conf);
                        }
                    }
                    return newByName;
                }
            });
        }
        return this.configurations == null ? null : Collections.unmodifiableCollection(this.configurations.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener lst) {
        ProjectConfigurationsHelper projectConfigurationsHelper = this;
        synchronized (projectConfigurationsHelper) {
            if (this.psp == null) {
                this.psp = new PropertyChangeSupport(this);
                this.getConfigurations();
                this.getActiveConfiguration();
                this.h.addAntProjectListener((AntProjectListener)this);
            }
        }
        this.psp.addPropertyChangeListener(lst);
    }

    public final ProjectConfiguration getActiveConfiguration() {
        if (this.activeConfiguration == null) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

                public Boolean run() {
                    ProjectConfigurationsHelper.this.activeConfiguration = ProjectConfigurationsHelper.this.getDefaultConfiguration();
                    String confName = ProjectConfigurationsHelper.this.h.getStandardPropertyEvaluator().getProperty(ProjectConfigurationsHelper.PROJ_PROP_CONFIGURATION_ACTIVE);
                    if (confName == null || confName.length() == 0) {
                        ProjectConfigurationsHelper.this.activeConfiguration = ProjectConfigurationsHelper.this.getDefaultConfiguration();
                        return null;
                    }
                    ProjectConfiguration[] confs = ProjectConfigurationsHelper.this.getConfigurations().toArray(new ProjectConfiguration[0]);
                    for (int i = 0; i < confs.length; ++i) {
                        if (!confName.equals(confs[i].getDisplayName())) continue;
                        ProjectConfigurationsHelper.this.activeConfiguration = confs[i];
                        return null;
                    }
                    return null;
                }
            });
        }
        return this.activeConfiguration;
    }

    public final ProjectConfiguration getConfigurationByName(String configName) {
        return this.configurations.get(configName);
    }

    public final void removePropertyChangeListener(PropertyChangeListener lst) {
        if (this.psp != null) {
            this.psp.removePropertyChangeListener(lst);
        }
    }

    protected ProjectConfiguration createConfiguration(String configName) {
        return new ConfigurationImpl(configName);
    }

    public final void setActiveConfiguration(final ProjectConfiguration configuration) throws IllegalArgumentException, IOException {
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ProjectConfigurationsHelper.class, (String)"TTL_CHANGE_CONFIG"));
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JComponent comp = ProgressHandleFactory.createProgressComponent((ProgressHandle)handle);
                JLabel lbl = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)handle);
                JPanel pnl = new JPanel(new BorderLayout());
                pnl.add((Component)lbl, "North");
                pnl.add((Component)comp, "South");
                String title = NbBundle.getMessage(ProjectConfigurationsHelper.class, (String)"MSG_CHANGE_CONFIG");
                JDialog dlg = new JDialog(WindowManager.getDefault().getMainWindow());
                dlg.setModal(true);
                dlg.setDefaultCloseOperation(0);
                dlg.setTitle(title);
                dlg.getContentPane().setLayout(new BorderLayout());
                dlg.getContentPane().add((Component)pnl, "Center");
                dlg.setLocationRelativeTo(dlg.getParent());
                RequestProcessor.Task task = ProjectConfigurationsHelper.this.p.getRequestProcessor().post((Runnable)new ConfigurationChanger(handle, configuration, dlg));
                try {
                    task.waitFinished(50L);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (!task.isFinished()) {
                    dlg.pack();
                    dlg.setVisible(true);
                }
            }
        });
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
    }

    public synchronized void propertiesChanged(AntProjectEvent ev) {
        if (this.psp == null) {
            return;
        }
        if ("nbproject/private/private.properties".equals(ev.getPath())) {
            ProjectConfiguration oldAC = this.activeConfiguration;
            this.activeConfiguration = null;
            ProjectConfiguration newAC = this.getActiveConfiguration();
            if (oldAC == null && newAC != null || oldAC != null && !oldAC.equals(newAC)) {
                this.psp.firePropertyChange("activeConfiguration", oldAC, newAC);
            }
        } else if ("nbproject/project.properties".equals(ev.getPath())) {
            this.invalid = true;
            TreeMap<String, ProjectConfiguration> old = this.configurations;
            Object[] oldCFs = old.values().toArray(new ProjectConfiguration[old.size()]);
            this.configurations = null;
            Object[] newCFs = this.getConfigurations(old).toArray(new ProjectConfiguration[0]);
            if (!Arrays.equals(oldCFs, newCFs)) {
                this.psp.firePropertyChange("configurations", oldCFs, newCFs);
            }
            this.psp.firePropertyChange(PROJECT_PROPERTIES, null, this.getActiveConfiguration());
        }
    }

    public boolean hasCustomizer() {
        return true;
    }

    public void customize() {
        final J2MECustomizerProvider cp = (J2MECustomizerProvider)this.p.getLookup().lookup(J2MECustomizerProvider.class);
        if (cp != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    cp.showCustomizer(true);
                }
            });
        }
    }

    public boolean configurationsAffectAction(String command) {
        return false;
    }

    private static final class ConfigurationImpl
    implements ProjectConfiguration {
        private final String name;

        public ConfigurationImpl(String name) {
            this.name = name;
        }

        public String getDisplayName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ConfigurationImpl)) {
                return false;
            }
            String name2 = ((ConfigurationImpl)o).getDisplayName();
            return this.name != null ? this.name.equals(name2) : name2 == null;
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }
    }

    private final class ConfigurationChanger
    extends WindowAdapter
    implements Runnable {
        private final ProgressHandle handle;
        private final ProjectConfiguration configuration;
        private final Dialog dlg;
        private volatile boolean done;

        ConfigurationChanger(ProgressHandle handle, ProjectConfiguration config, Dialog dlg) {
            this.configuration = config;
            this.handle = handle;
            this.dlg = dlg;
            handle.start();
            handle.switchToIndeterminate();
            dlg.addWindowListener(this);
        }

        @Override
        public void windowOpened(WindowEvent e) {
            if (this.done) {
                this.runOnEQ();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!EventQueue.isDispatchThread()) {
                try {
                    this.runOffEQ();
                }
                finally {
                    this.handle.finish();
                    EventQueue.invokeLater(this);
                }
                this.done = true;
            } else {
                this.runOnEQ();
            }
        }

        private void runOnEQ() {
            this.dlg.setVisible(false);
            this.dlg.dispose();
        }

        private void runOffEQ() {
            ProjectConfiguration oldAC = ProjectConfigurationsHelper.this.activeConfiguration;
            ProjectConfigurationsHelper.this.activeConfiguration = null;
            final EditableProperties ep = ProjectConfigurationsHelper.this.h.getProperties("nbproject/private/private.properties");
            ep.put(ProjectConfigurationsHelper.PROJ_PROP_CONFIGURATION_ACTIVE, this.configuration == null || this.configuration.equals(ProjectConfigurationsHelper.this.getDefaultConfiguration()) ? "" : this.configuration.getDisplayName());
            try {
                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Object>(){

                    public Object run() {
                        ProjectConfigurationsHelper.this.h.putProperties("nbproject/private/private.properties", ep);
                        return null;
                    }
                });
                ProjectManager.getDefault().saveProject((Project)ProjectConfigurationsHelper.this.p);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            catch (MutexException me) {
                Exceptions.printStackTrace((Throwable)me);
            }
            ProjectConfiguration newAC = ProjectConfigurationsHelper.this.getActiveConfiguration();
            if (oldAC != null ? !oldAC.equals(newAC) : newAC != null) {
                ProjectConfigurationsHelper.this.psp.firePropertyChange("activeConfiguration", oldAC, newAC);
            }
        }
    }
}

