/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.websvc.rest.codegen.ClientStubsGenerator;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.TokenReplacer;
import org.netbeans.modules.websvc.rest.codegen.model.Method;
import org.netbeans.modules.websvc.rest.codegen.model.Resource;
import org.netbeans.modules.websvc.rest.codegen.model.RestEntity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class ResourceJavaScript
extends TokenReplacer {
    private static final String ENTITY_NAME_VAR = "entity_name";
    final String RJSSUPPORT = "rjsSupport";
    private Resource resource;
    private FileObject jsFolder;
    private String pkg;
    private String object;
    private Map<String, String> entities;
    private Set<String> ignoredEntities;

    ResourceJavaScript(ClientStubsGenerator clientStubsGenerator, Resource resource, FileObject fileObject, Set<String> set) {
        super(clientStubsGenerator);
        this.ignoredEntities = set;
        this.resource = resource;
        this.jsFolder = fileObject;
        this.pkg = "";
        this.object = "";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.entities = new HashMap<String, String>();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        this.createRestMethods(this.resource, this.object, this.pkg, stringBuilder, stringBuilder2);
        hashMap.put("generic_name", this.resource.getName());
        hashMap.put("rest_methods", stringBuilder.toString());
        hashMap.put("stub_methods", stringBuilder2.toString());
        this.setTokens(hashMap);
    }

    public FileObject getFolder() {
        return this.jsFolder;
    }

    public FileObject generate() throws IOException {
        String string2;
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : this.entities.keySet()) {
            if (this.ignoredEntities.contains(string2)) continue;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(ENTITY_NAME_VAR, string2);
            FileObject fileObject = this.createResource("Templates/WebServices/JsEntity.js", string2, hashMap);
            hashSet.add(fileObject.getName());
        }
        Object object = this.resource.getName();
        while (hashSet.contains(object)) {
            object = (String)object + "REST";
        }
        this.resource.setEntities(hashSet);
        string2 = this.createResource("Templates/WebServices/JsStub.js", (String)object, null);
        return string2;
    }

    private FileObject createResource(String string, String string2, Map<String, String> map) throws IOException {
        String string3 = string2 + "." + "js";
        FileObject fileObject = this.jsFolder.getFileObject(string3);
        if (fileObject != null) {
            if (this.getGenerator().canOverwrite()) {
                fileObject.delete();
            } else {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, NbBundle.getMessage(ClientStubsGenerator.class, (String)"MSG_SkippingStubGeneration", (Object)(this.jsFolder.getPath() + File.separator + string3)));
            }
        }
        fileObject = map == null ? this.getGenerator().createDataObjectFromTemplate(string, this.jsFolder, string2, "js", this.getGenerator().canOverwrite(), this.getTokens()) : this.getGenerator().createDataObjectFromTemplate(string, this.jsFolder, string2, "js", this.getGenerator().canOverwrite(), map);
        return fileObject;
    }

    protected void createRestMethods(Resource resource, String string, String string2, StringBuilder stringBuilder, StringBuilder stringBuilder2) {
        String string3 = "rjsSupport.";
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        for (Method object : resource.getMethods()) {
            this.createStubMethod(object, string3, string2, hashSet, stringBuilder2);
            this.addMethodName(object.getName(), object, hashMap);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            String string4 = (String)entry.getKey();
            Method method = (Method)entry.getValue();
            this.createRestMethod(string4, method, stringBuilder);
        }
        if (stringBuilder2.length() > 3) {
            stringBuilder2.delete(stringBuilder2.length() - 3, stringBuilder2.length());
        }
    }

    private void addMethodName(String string, Method method, Map<String, Method> map) {
        Method method2 = map.get(string);
        if (method2 == null) {
            map.put(string, method);
        } else {
            String[] stringArray;
            int n;
            String string2 = method2.getPath();
            String string3 = method.getPath();
            String[] stringArray2 = this.split(string2);
            int n2 = stringArray2.length;
            if (n2 == (n = (stringArray = this.split(string3)).length)) {
                string = string + method.getType().toString();
                map.put(string, method);
            } else if (n2 > n) {
                map.put(string, method);
                string = string + this.getPostfix(stringArray2);
                this.addMethodName(string, method2, map);
            } else {
                string = string + this.getPostfix(stringArray);
                this.addMethodName(string, method, map);
            }
        }
    }

    private String[] split(String string) {
        String string2 = "/";
        String string3 = string;
        if (string3 == null) {
            return new String[0];
        }
        if (string3.startsWith(string2)) {
            string3 = string3.substring(1);
        }
        if (string3.endsWith(string2)) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        return string3.split(string2);
    }

    private String getPostfix(String[] stringArray) {
        for (int i = 1; i <= stringArray.length; ++i) {
            String string = stringArray[stringArray.length - i];
            String string2 = this.getPostfix(string);
            if (string2 == null) continue;
            return this.capitalize(string2);
        }
        return "1";
    }

    private String capitalize(String string) {
        if (string == null || string.length() == 0 || string.length() == 1) {
            return string;
        }
        char c = string.charAt(0);
        return Character.toUpperCase(c) + string.substring(1, string.length());
    }

    private String getPostfix(String string) {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return null;
        }
        int n = string2.indexOf(123);
        if (n == 0) {
            string2 = string2.substring(1);
        } else if (n > 0) {
            string2 = string2.substring(0, n);
        }
        n = string2.indexOf(58);
        if (n != -1) {
            string2 = string2.substring(0, n);
        } else {
            n = string2.indexOf(125);
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
        }
        if (string2.length() != 0 && Utilities.isJavaIdentifier((String)string2)) {
            return string2;
        }
        return null;
    }

    private void createRestMethod(String string, Method method, StringBuilder stringBuilder) {
        boolean bl;
        Constants.HttpMethodType httpMethodType = method.getType();
        String string2 = method.getPath();
        RestEntity restEntity = method.getReturnType();
        RestEntity restEntity2 = method.getParameterType();
        List<String> list = method.getRequestMimes();
        List<String> list2 = method.getResponseMimes();
        boolean bl2 = false;
        if (httpMethodType == Constants.HttpMethodType.GET && string2 == null && restEntity.getKind() != RestEntity.EntityKind.VOID) {
            bl2 = true;
            this.createEntitiesMethod(stringBuilder, string, restEntity, list2);
        }
        boolean bl3 = bl = list2 == null && list == null;
        if (!bl) {
            if (list2 != null && list2.contains(Constants.MimeType.JSON.value())) {
                bl = true;
            }
            if (!bl && list != null && list.contains(Constants.MimeType.JSON.value())) {
                bl = true;
            }
        }
        if (bl) {
            String string3 = this.addEntity(restEntity, bl2);
            String string4 = this.addEntity(restEntity2, false);
            this.addComment(method, stringBuilder, httpMethodType, string2, restEntity.getKind(), string3, restEntity2.getKind(), string4);
            stringBuilder.append("   ");
            stringBuilder.append(string);
            stringBuilder.append(" : function(uri_");
            if (restEntity2.getKind() != RestEntity.EntityKind.VOID) {
                stringBuilder.append(", param ");
            }
            stringBuilder.append(" ) {\n");
            stringBuilder.append("    var url = \"\";\n");
            stringBuilder.append("    if ( uri_ != null && uri_ !=undefined ){\n");
            stringBuilder.append("        url = uri_;\n");
            stringBuilder.append("    }\n");
            stringBuilder.append("    var  remote = new ");
            stringBuilder.append(this.resource.getName());
            stringBuilder.append("Remote(this.uri);\n");
            stringBuilder.append("    var  c= remote.");
            stringBuilder.append(method.getType().prefix());
            stringBuilder.append(Constants.MimeType.JSON.suffix());
            stringBuilder.append("_(url");
            if (restEntity2.getKind() == RestEntity.EntityKind.PRIMITIVE) {
                stringBuilder.append(", param ");
            } else if (restEntity2.getKind() == RestEntity.EntityKind.ENTITY || restEntity2.getKind() == RestEntity.EntityKind.COLLECTION) {
                stringBuilder.append(", this.asString(param)");
            }
            stringBuilder.append(");\n");
            stringBuilder.append("    if ( c== -1 ){\n");
            stringBuilder.append("        return -1;\n");
            stringBuilder.append("    }\n");
            if (restEntity.getKind() == RestEntity.EntityKind.VOID) {
                stringBuilder.append("   },\n\n");
                return;
            }
            if (restEntity.getKind() == RestEntity.EntityKind.PRIMITIVE) {
                if (bl2) {
                    stringBuilder.append("    return new ");
                    stringBuilder.append(string3);
                    stringBuilder.append("( c );\n");
                } else {
                    stringBuilder.append("    return c;\n");
                }
                stringBuilder.append("   },\n\n");
                return;
            }
            stringBuilder.append("    var  myObj = eval('('+c+')');\n");
            if (restEntity.getKind() == RestEntity.EntityKind.ENTITY) {
                stringBuilder.append("    if ( myObj['@uri'] != null && myObj['@uri']!= undefined ){\n");
                stringBuilder.append("       return new ");
                stringBuilder.append(string3);
                stringBuilder.append("( myObj, myObj['@uri']);\n");
                stringBuilder.append("     }\n");
                stringBuilder.append("     else {\n");
                stringBuilder.append("       return new ");
                stringBuilder.append(string3);
                stringBuilder.append("( myObj );\n");
                stringBuilder.append("     }\n");
            } else if (restEntity.getKind() == RestEntity.EntityKind.COLLECTION) {
                stringBuilder.append("    var result = new Array();\n");
                stringBuilder.append("    for ( var prop in myObj ){\n");
                stringBuilder.append("       var ref= myObj[prop];\n");
                stringBuilder.append("       var j=0;\n");
                stringBuilder.append("       for( j=0; j<ref.length; j++){\n");
                stringBuilder.append("           if ( ref[j]['@uri'] != null && ref[j]['@uri']!= undefined ){\n");
                stringBuilder.append("               result[j] = new ");
                stringBuilder.append(string3);
                stringBuilder.append("( ref[j], ref[j]['@uri']);\n");
                stringBuilder.append("           }\n");
                stringBuilder.append("           else {\n");
                stringBuilder.append("           result[j] = new ");
                stringBuilder.append(string3);
                stringBuilder.append("( ref[j] );\n");
                stringBuilder.append("           }\n");
                stringBuilder.append("       }\n");
                stringBuilder.append("    }\n");
                stringBuilder.append("    return result;\n");
            }
            stringBuilder.append("   },\n\n");
        }
    }

    private String addEntity(RestEntity restEntity, boolean bl) {
        int n;
        String string;
        String string2;
        RestEntity.EntityKind entityKind = restEntity.getKind();
        if (entityKind == RestEntity.EntityKind.VOID || !bl && entityKind == RestEntity.EntityKind.PRIMITIVE) {
            return null;
        }
        String string3 = restEntity.getFqn();
        if (entityKind == RestEntity.EntityKind.PRIMITIVE) {
            string3 = String.class.getName();
        }
        if ((string2 = this.entities.get(string = string3.substring((n = string3.lastIndexOf(46)) + 1))) != null && !string2.equals(string3)) {
            string = string3.replace('.', '_');
        }
        this.entities.put(string, string3);
        return string;
    }

    private void addComment(Method method, StringBuilder stringBuilder, Constants.HttpMethodType httpMethodType, String string, RestEntity.EntityKind entityKind, String string2, RestEntity.EntityKind entityKind2, String string3) {
        stringBuilder.append("   /* Method ");
        stringBuilder.append(method.getName());
        stringBuilder.append(" with HTTP request metod ");
        stringBuilder.append((Object)httpMethodType);
        if (string != null) {
            stringBuilder.append(" and path : ");
            stringBuilder.append(string);
        }
        if (string2 != null) {
            stringBuilder.append(", its return type is ");
            if (entityKind == RestEntity.EntityKind.COLLECTION) {
                stringBuilder.append("array of ");
            }
            stringBuilder.append(string2);
        }
        if (string3 != null) {
            stringBuilder.append(", its parameter type is ");
            if (entityKind2 == RestEntity.EntityKind.COLLECTION) {
                stringBuilder.append("array of ");
            }
            stringBuilder.append(string3);
        }
        stringBuilder.append("  */\n");
    }

    private void createEntitiesMethod(StringBuilder stringBuilder, String string, RestEntity restEntity, List<String> list) {
        RestEntity.EntityKind entityKind = restEntity.getKind();
        if (list != null && !list.contains(Constants.MimeType.JSON.value())) {
            return;
        }
        stringBuilder.append("   getEntities : function() {\n");
        if (entityKind == RestEntity.EntityKind.COLLECTION) {
            stringBuilder.append("     return this.");
            stringBuilder.append(string);
            stringBuilder.append("(null);\n");
        } else {
            stringBuilder.append("     var result = new Array();\n");
            stringBuilder.append("     result[0] = this.");
            stringBuilder.append(string);
            stringBuilder.append("(null);\n");
            stringBuilder.append("     return result;\n");
        }
        stringBuilder.append("   },\n\n");
        this.resource.setDefaultGet();
    }

    private void createStubMethod(Method method, String string, String string2, Set<String> set, StringBuilder stringBuilder) {
        Constants.HttpMethodType httpMethodType = method.getType();
        if (httpMethodType == Constants.HttpMethodType.GET) {
            List<String> list = method.getResponseMimes();
            if (list == null) {
                list = Collections.singletonList(Constants.MimeType.XML.value());
            }
            for (String string3 : list) {
                String string4 = this.createMethodName(method, string3 = string3.replace("\"", "").trim(), list.size());
                if (set.contains(string4)) continue;
                set.add(string4);
                stringBuilder.append("   ");
                stringBuilder.append(string4);
                stringBuilder.append(" : function(uri_) {\n");
                stringBuilder.append("   return ");
                stringBuilder.append(string);
                stringBuilder.append("get(this.uri+uri_, '");
                stringBuilder.append(string3);
                stringBuilder.append("');\n   },\n\n");
            }
        } else {
            String string5 = httpMethodType.prefix();
            List<String> list = method.getRequestMimes();
            if (list == null) {
                list = Collections.singletonList(Constants.MimeType.XML.value());
            }
            for (String string6 : list) {
                String string7 = this.createMethodName(method, string6 = string6.replace("\"", "").trim(), list.size());
                if (set.contains(string7)) continue;
                set.add(string7);
                stringBuilder.append("   ");
                stringBuilder.append(string7);
                stringBuilder.append(" : function(uri_, content) {\n");
                stringBuilder.append("   return ");
                stringBuilder.append(string);
                stringBuilder.append(string5);
                stringBuilder.append("(this.uri+uri_, '");
                stringBuilder.append(string6);
                stringBuilder.append("', content);\n   },\n\n");
            }
        }
    }

    private String createMethodName(Method method, String string, int n) {
        if (n > 1) {
            for (Constants.MimeType mimeType : Constants.MimeType.values()) {
                if (!mimeType.value().equals(string)) continue;
                return method.getType().prefix() + mimeType.suffix();
            }
        }
        return method.getType().prefix();
    }
}

