/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.websvc.rest.codegen.EntityResourcesGenerator;
import org.netbeans.modules.websvc.rest.codegen.RestFacadeMethod;
import org.netbeans.modules.websvc.rest.codegen.RestGenerationOptions;
import org.netbeans.modules.websvc.rest.codegen.RestMethod;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.netbeans.modules.websvc.rest.support.SpringHelper;
import org.openide.filesystems.FileObject;

public class SpringEntityResourcesGenerator
extends EntityResourcesGenerator {
    private boolean hasAopAlliance;

    SpringEntityResourcesGenerator(boolean bl) {
        this.hasAopAlliance = bl;
    }

    @Override
    protected void configurePersistence() {
        new SpringHelper(this.getProject(), this.getPersistenceUnit()).configure();
    }

    @Override
    protected void createFolders() {
        this.createFolders(false);
    }

    @Override
    protected boolean generateInfrastracture(Set<FileObject> set, String string, FileObject fileObject) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        Task<WorkingCopy> task = new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws Exception {
                Object[] objectArray;
                String[] stringArray;
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                if (SpringEntityResourcesGenerator.this.hasAopAlliance) {
                    stringArray = new String[]{"PersistenceContext"};
                    objectArray = new Object[]{JavaSourceHelper.createAssignmentTree(workingCopy, "unitName", SpringEntityResourcesGenerator.this.getPersistenceUnit().getName())};
                } else {
                    stringArray = new String[]{"PersistenceContext", "Error"};
                    objectArray = new Object[]{JavaSourceHelper.createAssignmentTree(workingCopy, "unitName", SpringEntityResourcesGenerator.this.getPersistenceUnit().getName()), "Please fix your project manually, for instructions see http://wiki.netbeans.org/SpringWithAopalliance"};
                }
                ClassTree classTree = (ClassTree)compilationUnitTree.getTypeDecls().get(0);
                ClassTree classTree2 = JavaSourceHelper.addField(workingCopy, classTree, new Modifier[]{Modifier.PROTECTED}, stringArray, objectArray, "entityManager", "javax.persistence.EntityManager");
                workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
            }
        };
        javaSource.runModificationTask((Task)task).commit();
        return true;
    }

    @Override
    protected List<RestGenerationOptions> getRestFacadeMethodOptions(String string, String string2) {
        List<RestGenerationOptions> list = super.getRestFacadeMethodOptions(string, string2);
        ArrayList<RestGenerationOptions> arrayList = new ArrayList<RestGenerationOptions>(list.size() + 1);
        arrayList.addAll(list);
        RestGenerationOptions restGenerationOptions = new RestGenerationOptions();
        FindMethod findMethod = new FindMethod();
        restGenerationOptions.setRestMethod(findMethod);
        restGenerationOptions.setParameterNames(new String[]{"all", "maxResults", "firstResult"});
        restGenerationOptions.setParameterTypes(new String[]{"boolean", "int", "int"});
        StringBuilder stringBuilder = new StringBuilder(List.class.getCanonicalName());
        stringBuilder.append('<');
        stringBuilder.append(JavaIdentifiers.unqualify((String)string));
        stringBuilder.append('>');
        restGenerationOptions.setReturnType(stringBuilder.toString());
        StringBuilder stringBuilder2 = new StringBuilder("try { ");
        stringBuilder2.append("Query query = entityManager.createQuery(");
        stringBuilder2.append('\"');
        stringBuilder2.append("SELECT object(o) FROM ");
        stringBuilder2.append(this.getModel().getEntityInfo(string).getName());
        stringBuilder2.append(" AS o\");");
        stringBuilder2.append("if (!all) {");
        stringBuilder2.append(" query.setMaxResults(maxResults);");
        stringBuilder2.append(" query.setFirstResult(firstResult);}");
        stringBuilder2.append(" return  query.getResultList();");
        stringBuilder2.append("} finally { entityManager.close();}");
        restGenerationOptions.setBody(stringBuilder2.toString());
        arrayList.add(restGenerationOptions);
        return arrayList;
    }

    @Override
    protected ModifiersTree addRestMethodAnnotations(GenerationUtils generationUtils, TreeMaker treeMaker, RestGenerationOptions restGenerationOptions, ModifiersTree modifiersTree) {
        ModifiersTree modifiersTree2 = super.addRestMethodAnnotations(generationUtils, treeMaker, restGenerationOptions, modifiersTree);
        if (restGenerationOptions.getRestMethod().getMethod() != null) {
            modifiersTree2 = treeMaker.addModifiersAnnotation(modifiersTree2, generationUtils.createAnnotation("org.springframework.transaction.annotation.Transactional"));
        }
        return modifiersTree2;
    }

    @Override
    protected List<String> getResourceImports(String string) {
        List<String> list = super.getResourceImports(string);
        ArrayList<String> arrayList = new ArrayList<String>(list.size() + 1);
        arrayList.addAll(list);
        arrayList.add("javax.persistence.Query");
        arrayList.add("javax.persistence.PersistenceContext");
        return arrayList;
    }

    @Override
    protected ModifiersTree addResourceAnnotation(String string, ClassTree classTree, GenerationUtils generationUtils, TreeMaker treeMaker) {
        ModifiersTree modifiersTree = super.addResourceAnnotation(string, classTree, generationUtils, treeMaker);
        modifiersTree = treeMaker.addModifiersAnnotation(modifiersTree, generationUtils.createAnnotation("com.sun.jersey.spi.resource.Singleton"));
        modifiersTree = treeMaker.addModifiersAnnotation(modifiersTree, generationUtils.createAnnotation("com.sun.jersey.api.spring.Autowire"));
        return modifiersTree;
    }

    @Override
    protected RestGenerationOptions getGenerationOptions(RestFacadeMethod restFacadeMethod, String string, String string2, String string3) {
        String string4 = JavaIdentifiers.unqualify((String)string);
        RestGenerationOptions restGenerationOptions = super.getGenerationOptions(restFacadeMethod, string, string2, string3);
        switch (restFacadeMethod) {
            case CREATE: {
                StringBuilder stringBuilder = new StringBuilder("entityManager.persist(entity);");
                stringBuilder.append("return Response.created(");
                stringBuilder.append("URI.create(");
                stringBuilder.append(this.getIdFieldToUriStmt(this.getModel().getEntityInfo(string).getIdFieldInfo()));
                stringBuilder.append(".toString())).build();");
                restGenerationOptions.setBody(stringBuilder.toString());
                return restGenerationOptions;
            }
            case EDIT: {
                restGenerationOptions.setReturnType("void");
                StringBuilder stringBuilder = new StringBuilder("entityManager.merge(entity);");
                restGenerationOptions.setBody(stringBuilder.toString());
                return restGenerationOptions;
            }
            case REMOVE: {
                restGenerationOptions.setReturnType("void");
                StringBuilder stringBuilder = new StringBuilder(string4);
                stringBuilder.append(" entity = entityManager.getReference(");
                stringBuilder.append(string4);
                stringBuilder.append(".class, ");
                stringBuilder.append(string2);
                stringBuilder.append(");");
                stringBuilder.append("entityManager.remove(entity);");
                restGenerationOptions.setBody(stringBuilder.toString());
                return restGenerationOptions;
            }
            case FIND: {
                StringBuilder stringBuilder = new StringBuilder("return entityManager.find(");
                stringBuilder.append(string4);
                stringBuilder.append(".class, ");
                stringBuilder.append(string2);
                stringBuilder.append(");");
                restGenerationOptions.setBody(stringBuilder.toString());
                return restGenerationOptions;
            }
            case FIND_ALL: {
                restGenerationOptions.setBody("return find(true , -1 , -1);");
                return restGenerationOptions;
            }
            case FIND_RANGE: {
                restGenerationOptions.setBody("return find( false , max, first)");
                return restGenerationOptions;
            }
            case COUNT: {
                StringBuilder stringBuilder = new StringBuilder("try {");
                stringBuilder.append("Query query = entityManager.createQuery(");
                stringBuilder.append('\"');
                stringBuilder.append("SELECT count(o) FROM ");
                stringBuilder.append(this.getModel().getEntityInfo(string).getName());
                stringBuilder.append(" AS o\");");
                stringBuilder.append("return query.getSingleResult().toString();");
                stringBuilder.append("} finally { entityManager.close(); }");
                restGenerationOptions.setBody(stringBuilder.toString());
                return restGenerationOptions;
            }
        }
        return null;
    }

    private final class FindMethod
    implements RestMethod {
        private FindMethod() {
        }

        @Override
        public boolean overrides() {
            return false;
        }

        @Override
        public String getUriPath() {
            return null;
        }

        @Override
        public String getMethodName() {
            return "find";
        }

        @Override
        public String getMethod() {
            return null;
        }
    }
}

