/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.model.GenericResourceBean;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.netbeans.modules.websvc.rest.wizard.AbstractPanel;
import org.netbeans.modules.websvc.rest.wizard.SourceGroupUISupport;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class SingletonSetupPanelVisual
extends JPanel
implements AbstractPanel.Settings {
    private Project project;
    private List<ChangeListener> listeners;
    private boolean resourceClassNameOveridden;
    private JLabel classLabel;
    private JTextField classTextField;
    private JLabel contentClassLabel;
    private JTextField contentClassTextField;
    private JSeparator jSeparator2;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JComboBox medaTypeComboBox;
    private JLabel mediaTypeLabel;
    private JComboBox packageComboBox;
    private JLabel packageLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JButton selectClassButton;
    private JLabel uriLabel;
    private JTextField uriTextField;
    public static final String DEFAULT_URI = "generic";

    public SingletonSetupPanelVisual(String string) {
        this.setName(string);
        this.listeners = new ArrayList<ChangeListener>();
        this.initComponents();
        this.packageComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                SingletonSetupPanelVisual.this.fireChange();
            }
        });
        this.medaTypeComboBox.setModel(new DefaultComboBoxModel<Constants.MimeType>(GenericResourceBean.getSupportedMimeTypes()));
    }

    private void initComponents() {
        this.classLabel = new JLabel();
        this.classTextField = new JTextField();
        this.uriLabel = new JLabel();
        this.uriTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.packageLabel = new JLabel();
        this.packageComboBox = new JComboBox();
        this.medaTypeComboBox = new JComboBox();
        this.mediaTypeLabel = new JLabel();
        this.contentClassLabel = new JLabel();
        this.selectClassButton = new JButton();
        this.contentClassTextField = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.setName("");
        this.classLabel.setLabelFor(this.classTextField);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/rest/wizard/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.classLabel, (String)resourceBundle.getString("MSG_ClassName"));
        this.classTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                SingletonSetupPanelVisual.this.classTextFieldKeyReleased(keyEvent);
            }
        });
        this.uriLabel.setLabelFor(this.uriTextField);
        Mnemonics.setLocalizedText((JLabel)this.uriLabel, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_UriTemplate"));
        this.uriTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                SingletonSetupPanelVisual.this.uriTextFieldKeyReleased(keyEvent);
            }
        });
        this.projectLabel.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_Project"));
        this.projectTextField.setEditable(false);
        this.locationLabel.setLabelFor(this.locationComboBox);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_SrcLocation"));
        this.locationComboBox.setMinimumSize(new Dimension(4, 20));
        this.locationComboBox.setPreferredSize(new Dimension(130, 23));
        this.locationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SingletonSetupPanelVisual.this.locationComboBoxActionPerformed(actionEvent);
            }
        });
        this.packageLabel.setLabelFor(this.packageComboBox);
        Mnemonics.setLocalizedText((JLabel)this.packageLabel, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_Package"));
        this.packageComboBox.setEditable(true);
        this.packageComboBox.setMinimumSize(new Dimension(4, 20));
        this.packageComboBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                SingletonSetupPanelVisual.this.packageComboBoxKeyReleased(keyEvent);
            }
        });
        this.medaTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.medaTypeComboBox.setMinimumSize(new Dimension(4, 20));
        this.mediaTypeLabel.setLabelFor(this.medaTypeComboBox);
        Mnemonics.setLocalizedText((JLabel)this.mediaTypeLabel, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_MimeType"));
        this.contentClassLabel.setLabelFor(this.contentClassTextField);
        Mnemonics.setLocalizedText((JLabel)this.contentClassLabel, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_RepresentationClass"));
        Mnemonics.setLocalizedText((AbstractButton)this.selectClassButton, (String)NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_Select"));
        this.selectClassButton.setHorizontalAlignment(10);
        this.selectClassButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SingletonSetupPanelVisual.this.selectClassButtonActionPerformed(actionEvent);
            }
        });
        this.selectClassButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SingletonSetupPanelVisual.this.mouseClickHandler(mouseEvent);
            }
        });
        this.contentClassTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                SingletonSetupPanelVisual.this.representationClassChanged(keyEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.locationLabel).addComponent(this.projectLabel).addComponent(this.contentClassLabel).addComponent(this.classLabel).addComponent(this.uriLabel).addComponent(this.mediaTypeLabel).addComponent(this.packageLabel)).addGap(7, 7, 7).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.classTextField, GroupLayout.Alignment.TRAILING, -1, 473, Short.MAX_VALUE).addComponent(this.medaTypeComboBox, GroupLayout.Alignment.TRAILING, 0, 473, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addComponent(this.contentClassTextField, -1, 394, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectClassButton)).addComponent(this.uriTextField, GroupLayout.Alignment.TRAILING, -1, 473, Short.MAX_VALUE).addComponent(this.locationComboBox, GroupLayout.Alignment.TRAILING, 0, 473, Short.MAX_VALUE).addComponent(this.packageComboBox, GroupLayout.Alignment.TRAILING, 0, 473, Short.MAX_VALUE).addComponent(this.projectTextField, -1, 473, Short.MAX_VALUE)).addContainerGap()).addComponent(this.jSeparator2, -1, 596, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLabel).addComponent(this.projectTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationLabel).addComponent(this.locationComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.packageComboBox, -2, -1, -2).addComponent(this.packageLabel)).addGap(9, 9, 9).addComponent(this.jSeparator2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.uriLabel).addComponent(this.uriTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.classLabel).addComponent(this.classTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mediaTypeLabel).addComponent(this.medaTypeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.contentClassLabel).addComponent(this.selectClassButton).addComponent(this.contentClassTextField, -2, 22, -2))));
        this.classLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"ClassName"));
        this.classLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_ClassName"));
        this.classTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"ClassName"));
        this.classTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_ClassName"));
        this.uriLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"UirTemplate"));
        this.uriLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_Uri"));
        this.uriTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"UriTemplate"));
        this.uriTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_Uri"));
        this.projectLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"Project"));
        this.projectLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_Project"));
        this.projectTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"Project"));
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_Project"));
        this.locationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"Location"));
        this.locationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_Location"));
        this.locationComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"Location"));
        this.locationComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_Location"));
        this.packageLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"ResourcePackage"));
        this.packageLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_ResourcePackage"));
        this.packageComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"ResourcePackage"));
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_ResourcePackage"));
        this.medaTypeComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"MimeType"));
        this.medaTypeComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_MimeType"));
        this.mediaTypeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"MimeType"));
        this.mediaTypeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_MimeType"));
        this.contentClassLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"RepresentationClass"));
        this.contentClassLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_RepresentationClass"));
        this.selectClassButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"SelectRepresentationClass"));
        this.selectClassButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_SelectRepresenationClass"));
        this.contentClassTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"RepresentationClass"));
        this.contentClassTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"DESC_RepresentationClass"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_Specify_Resource_Class"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SingletonSetupPanelVisual.class, (String)"LBL_Specify_Resource_Class"));
    }

    private void containerTextFieldActionPerformed(ActionEvent actionEvent) {
    }

    private void representationClassChanged(KeyEvent keyEvent) {
        this.fireChange();
    }

    private void selectClassButtonActionPerformed(ActionEvent actionEvent) {
        this.fireChange();
    }

    private void mouseClickHandler(MouseEvent mouseEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ElementHandle elementHandle = TypeElementFinder.find((ClasspathInfo)Util.getClasspathInfo(SingletonSetupPanelVisual.this.project), (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

                    public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String string, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> set) {
                        return classpathInfo.getClassIndex().getDeclaredTypes(string, nameKind, set);
                    }

                    public boolean accept(ElementHandle<TypeElement> elementHandle) {
                        return true;
                    }
                });
                if (elementHandle != null) {
                    SingletonSetupPanelVisual.this.contentClassTextField.setText(elementHandle.getQualifiedName());
                    SingletonSetupPanelVisual.this.fireChange();
                }
            }
        });
    }

    private void locationComboBoxActionPerformed(ActionEvent actionEvent) {
        this.locationChanged();
    }

    private void classTextFieldKeyReleased(KeyEvent keyEvent) {
        this.resourceClassNameOveridden = true;
        this.fireChange();
    }

    private void packageComboBoxKeyReleased(KeyEvent keyEvent) {
        this.fireChange();
    }

    private void uriTextFieldKeyReleased(KeyEvent keyEvent) {
        String string = this.uriTextField.getText();
        if (!this.resourceClassNameOveridden) {
            this.classTextField.setText(this.findFreeClassName(string));
        }
        this.fireChange();
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    @Override
    public boolean valid(WizardDescriptor wizardDescriptor) {
        AbstractPanel.clearErrorMessage(wizardDescriptor);
        String string = this.uriTextField.getText().trim();
        String string2 = this.getPackage();
        String string3 = this.classTextField.getText().trim();
        SourceGroup[] sourceGroupArray = SourceGroupSupport.getJavaSourceGroups(this.project);
        if (sourceGroupArray == null || sourceGroupArray.length < 1) {
            AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_NoJavaSourceRoots");
            return false;
        }
        if (string3.length() == 0 || !Utilities.isJavaIdentifier((String)string3)) {
            AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_InvalidResourceClassName");
            return false;
        }
        if (string.length() == 0) {
            AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_EmptyUriTemplate");
            return false;
        }
        if (!Util.isValidPackageName(string2)) {
            AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_InvalidPackageName");
            return false;
        }
        if (this.getResourceClassFile() != null) {
            AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_ExistingClass");
            return false;
        }
        if (!Util.isValidUri(string)) {
            AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_IncorrectUriTemplate");
            return false;
        }
        return true;
    }

    public SourceGroup getLocationValue() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    public String getPackage() {
        return ((JTextComponent)this.packageComboBox.getEditor().getEditorComponent()).getText();
    }

    private void locationChanged() {
        this.updateSourceGroupPackages();
        this.fireChange();
    }

    private String getResourceClassName() {
        return this.classTextField.getText();
    }

    private FileObject getResourceClassFile() {
        FileObject fileObject = null;
        try {
            fileObject = SourceGroupSupport.getFolderForPackage(this.getLocationValue(), this.getPackage());
            if (fileObject != null) {
                return fileObject.getFileObject(this.getResourceClassName(), "java");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void read(WizardDescriptor wizardDescriptor) {
        String[] stringArray;
        Object object;
        this.project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)wizardDescriptor);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        SourceGroup[] sourceGroupArray = SourceGroupSupport.getJavaSourceGroups(this.project);
        SourceGroupUISupport.connect(this.locationComboBox, sourceGroupArray);
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.updateSourceGroupPackages();
        if (fileObject != null) {
            object = SourceGroupSupport.findSourceGroupForFile(sourceGroupArray, fileObject);
            if (object != null) {
                this.locationComboBox.setSelectedItem(object);
                stringArray = SourceGroupSupport.getPackageForFolder((SourceGroup)object, fileObject);
                if (stringArray != null) {
                    ((JTextComponent)this.packageComboBox.getEditor().getEditorComponent()).setText((String)stringArray);
                }
            }
        } else {
            object = (String)wizardDescriptor.getProperty("targetPackage");
            if (object != null) {
                ((JTextComponent)this.packageComboBox.getEditor().getEditorComponent()).setText((String)object);
            }
        }
        object = (String)wizardDescriptor.getProperty("ResourceURI");
        if (object == null || ((String)object).trim().length() == 0) {
            this.uriTextField.setText(DEFAULT_URI);
            this.classTextField.setText(this.findFreeClassName(DEFAULT_URI));
            this.contentClassTextField.setText(GenericResourceBean.getDefaultRepresetationClass((Constants.MimeType)((Object)this.medaTypeComboBox.getSelectedItem())));
        } else {
            this.uriTextField.setText((String)object);
            this.classTextField.setText((String)wizardDescriptor.getProperty("ResourceClass"));
            this.medaTypeComboBox.setSelectedItem((Object)((Constants.MimeType[])wizardDescriptor.getProperty("MimeTypes"))[0]);
            stringArray = (String[])wizardDescriptor.getProperty("RepresentationTypes");
            if (stringArray != null && stringArray.length > 0) {
                this.contentClassTextField.setText(stringArray[0]);
            }
        }
    }

    @Override
    public void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("resourcePackage", (Object)this.getPackage());
        wizardDescriptor.putProperty("ResourceClass", (Object)this.classTextField.getText());
        wizardDescriptor.putProperty("ResourceURI", (Object)this.uriTextField.getText());
        wizardDescriptor.putProperty("MimeTypes", (Object)new Constants.MimeType[]{(Constants.MimeType)((Object)this.medaTypeComboBox.getSelectedItem())});
        wizardDescriptor.putProperty("RepresentationTypes", (Object)new String[]{this.contentClassTextField.getText()});
        wizardDescriptor.putProperty("sourceGroup", (Object)this.getLocationValue());
        try {
            FileObject fileObject = SourceGroupSupport.getFolderForPackage(this.getLocationValue(), this.getPackage(), false);
            if (fileObject != null) {
                Templates.setTargetFolder((WizardDescriptor)wizardDescriptor, (FileObject)fileObject);
            } else {
                Templates.setTargetFolder((WizardDescriptor)wizardDescriptor, null);
                wizardDescriptor.putProperty("targetPackage", (Object)this.getPackage());
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void updateSourceGroupPackages() {
        SourceGroup sourceGroup = (SourceGroup)this.locationComboBox.getSelectedItem();
        if (sourceGroup != null) {
            ComboBoxModel comboBoxModel = PackageView.createListView((SourceGroup)sourceGroup);
            if (comboBoxModel.getSelectedItem() != null && comboBoxModel.getSelectedItem().toString().startsWith("META-INF") && comboBoxModel.getSize() > 1) {
                comboBoxModel.setSelectedItem(comboBoxModel.getElementAt(1));
            }
            this.packageComboBox.setModel(comboBoxModel);
        }
    }

    private String findFreeClassName(String string) {
        try {
            FileObject fileObject = SourceGroupSupport.getFolderForPackage(this.getLocationValue(), this.getPackage());
            if (fileObject != null) {
                return FileUtil.findFreeFileName((FileObject)fileObject, (String)Util.deriveResourceClassName(string), (String)"java");
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }
}

