/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.spi.editor.highlighting.HighlightAttributeValue;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MethodChooser {
    private static AttributeSet defaultHyperlinkHighlight;
    private String url;
    private Segment[] segments;
    private int selectedIndex = -1;
    private String hintText;
    private KeyStroke[] stopEvents;
    private KeyStroke[] confirmEvents;
    private AttributeSet attribsLeft = null;
    private AttributeSet attribsRight = null;
    private AttributeSet attribsMiddle = null;
    private AttributeSet attribsAll = null;
    private AttributeSet attribsLeftUnc = null;
    private AttributeSet attribsRightUnc = null;
    private AttributeSet attribsMiddleUnc = null;
    private AttributeSet attribsAllUnc = null;
    private AttributeSet attribsArea = null;
    private AttributeSet attribsMethod = null;
    private AttributeSet attribsMethodUnc = null;
    private AttributeSet attribsHyperlink = null;
    private Cursor handCursor;
    private Cursor arrowCursor;
    private Cursor originalCursor;
    private CentralListener mainListener;
    private Document doc;
    private JEditorPane editorPane;
    private List<ReleaseListener> releaseListeners = new ArrayList<ReleaseListener>();
    private int startLine;
    private int endLine;
    private int mousedIndex = -1;
    private boolean isInSelectMode = false;

    public MethodChooser(String url, Segment[] segments, int initialIndex) {
        this(url, segments, initialIndex, null, new KeyStroke[0], new KeyStroke[0]);
    }

    public MethodChooser(String url, Segment[] segments, int initialIndex, String hintText, KeyStroke[] stopEvents, KeyStroke[] confirmEvents) {
        this.url = url;
        this.segments = segments;
        this.selectedIndex = initialIndex;
        this.hintText = hintText;
        if (stopEvents == null) {
            stopEvents = new KeyStroke[]{};
        }
        if (confirmEvents == null) {
            confirmEvents = new KeyStroke[]{};
        }
        this.stopEvents = stopEvents;
        this.confirmEvents = confirmEvents;
    }

    public boolean showUI() {
        this.findEditorPane();
        if (this.editorPane == null) {
            return false;
        }
        this.doc = this.editorPane.getDocument();
        int minOffs = Integer.MAX_VALUE;
        int maxOffs = 0;
        for (int x = 0; x < this.segments.length; ++x) {
            minOffs = Math.min(this.segments[x].getStartOffset(), minOffs);
            maxOffs = Math.max(this.segments[x].getEndOffset(), maxOffs);
        }
        try {
            this.startLine = Utilities.getLineOffset((BaseDocument)((BaseDocument)this.doc), (int)minOffs) + 1;
            this.endLine = Utilities.getLineOffset((BaseDocument)((BaseDocument)this.doc), (int)maxOffs) + 1;
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        this.mainListener = new CentralListener();
        this.editorPane.putClientProperty(MethodChooser.class, this);
        this.editorPane.addKeyListener(this.mainListener);
        this.editorPane.addMouseListener(this.mainListener);
        this.editorPane.addMouseMotionListener(this.mainListener);
        this.editorPane.addFocusListener(this.mainListener);
        this.originalCursor = this.editorPane.getCursor();
        this.handCursor = Cursor.getPredefinedCursor(12);
        this.arrowCursor = Cursor.getPredefinedCursor(0);
        this.editorPane.setCursor(this.arrowCursor);
        Caret caret = this.editorPane.getCaret();
        if (caret instanceof BaseCaret) {
            ((BaseCaret)caret).setVisible(false);
        }
        this.requestRepaint();
        if (this.hintText != null && this.hintText.trim().length() > 0) {
            Utilities.setStatusText((JTextComponent)this.editorPane, (String)(" " + this.hintText));
        }
        this.isInSelectMode = true;
        return true;
    }

    public synchronized void releaseUI(boolean performAction) {
        if (!this.isInSelectMode) {
            return;
        }
        MethodChooser.getHighlightsBag(this.doc).clear();
        this.editorPane.removeKeyListener(this.mainListener);
        this.editorPane.removeMouseListener(this.mainListener);
        this.editorPane.removeMouseMotionListener(this.mainListener);
        this.editorPane.removeFocusListener(this.mainListener);
        this.editorPane.putClientProperty(MethodChooser.class, null);
        this.editorPane.setCursor(this.originalCursor);
        Caret caret = this.editorPane.getCaret();
        if (caret instanceof BaseCaret) {
            ((BaseCaret)caret).setVisible(true);
        }
        if (this.hintText != null && this.hintText.trim().length() > 0) {
            Utilities.clearStatusText((JTextComponent)this.editorPane);
        }
        this.isInSelectMode = false;
        for (ReleaseListener listener : this.releaseListeners) {
            listener.released(performAction);
        }
    }

    public boolean isUIActive() {
        return this.isInSelectMode;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized void addReleaseListener(ReleaseListener listener) {
        this.releaseListeners.add(listener);
    }

    public synchronized void removeReleaseListener(ReleaseListener listener) {
        this.releaseListeners.remove(listener);
    }

    public static HighlightsLayerFactory createHighlihgtsLayerFactory() {
        return new MethodChooserHighlightsLayerFactory();
    }

    static OffsetsBag getHighlightsBag(Document doc) {
        OffsetsBag bag = (OffsetsBag)doc.getProperty(MethodChooser.class);
        if (bag == null) {
            bag = new OffsetsBag(doc, true);
            doc.putProperty(MethodChooser.class, bag);
        }
        return bag;
    }

    private void findEditorPane() {
        FileObject file;
        this.editorPane = null;
        try {
            file = URLMapper.findFileObject((URL)new URL(this.url));
        }
        catch (MalformedURLException e) {
            return;
        }
        if (file == null) {
            return;
        }
        DataObject dobj = null;
        try {
            dobj = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            // empty catch block
        }
        if (dobj == null) {
            return;
        }
        final EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
        if (SwingUtilities.isEventDispatchThread()) {
            JEditorPane[] openedPanes = ec.getOpenedPanes();
            if (openedPanes != null) {
                this.editorPane = openedPanes[0];
            }
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JEditorPane[] openedPanes = ec.getOpenedPanes();
                        if (openedPanes != null) {
                            MethodChooser.this.editorPane = openedPanes[0];
                        }
                    }
                });
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void requestRepaint() {
        if (this.attribsLeft == null) {
            Color foreground = this.editorPane.getForeground();
            Color foreground2 = Color.GRAY;
            this.attribsLeft = this.createAttribs(EditorStyleConstants.LeftBorderLineColor, foreground, EditorStyleConstants.TopBorderLineColor, foreground, EditorStyleConstants.BottomBorderLineColor, foreground);
            this.attribsRight = this.createAttribs(EditorStyleConstants.RightBorderLineColor, foreground, EditorStyleConstants.TopBorderLineColor, foreground, EditorStyleConstants.BottomBorderLineColor, foreground);
            this.attribsMiddle = this.createAttribs(EditorStyleConstants.TopBorderLineColor, foreground, EditorStyleConstants.BottomBorderLineColor, foreground);
            this.attribsAll = this.createAttribs(EditorStyleConstants.LeftBorderLineColor, foreground, EditorStyleConstants.RightBorderLineColor, foreground, EditorStyleConstants.TopBorderLineColor, foreground, EditorStyleConstants.BottomBorderLineColor, foreground);
            this.attribsLeftUnc = this.createAttribs(EditorStyleConstants.LeftBorderLineColor, foreground2, EditorStyleConstants.TopBorderLineColor, foreground2, EditorStyleConstants.BottomBorderLineColor, foreground2);
            this.attribsRightUnc = this.createAttribs(EditorStyleConstants.RightBorderLineColor, foreground2, EditorStyleConstants.TopBorderLineColor, foreground2, EditorStyleConstants.BottomBorderLineColor, foreground2);
            this.attribsMiddleUnc = this.createAttribs(EditorStyleConstants.TopBorderLineColor, foreground2, EditorStyleConstants.BottomBorderLineColor, foreground2);
            this.attribsAllUnc = this.createAttribs(EditorStyleConstants.LeftBorderLineColor, foreground2, EditorStyleConstants.RightBorderLineColor, foreground2, EditorStyleConstants.TopBorderLineColor, foreground2, EditorStyleConstants.BottomBorderLineColor, foreground2);
            this.attribsHyperlink = this.getHyperlinkHighlight();
            this.attribsMethod = this.createAttribs(StyleConstants.Foreground, foreground, StyleConstants.Bold, Boolean.TRUE);
            this.attribsMethodUnc = this.createAttribs(StyleConstants.Foreground, foreground2, StyleConstants.Bold, Boolean.TRUE);
            this.attribsArea = this.createAttribs(StyleConstants.Foreground, foreground, StyleConstants.Italic, Boolean.FALSE, StyleConstants.Bold, Boolean.FALSE);
        }
        OffsetsBag newBag = new OffsetsBag(this.doc, true);
        int start = this.segments[0].getStartOffset();
        int end = this.segments[this.segments.length - 1].getEndOffset();
        newBag.addHighlight(start, end, this.attribsArea);
        for (int i = 0; i < this.segments.length; ++i) {
            int startOffset = this.segments[i].getStartOffset();
            int endOffset = this.segments[i].getEndOffset();
            boolean isCertain = !this.segments[i].getClass().getSimpleName().toLowerCase().contains("uncertain");
            newBag.addHighlight(startOffset, endOffset, isCertain ? this.attribsMethod : this.attribsMethodUnc);
            if (this.selectedIndex == i) {
                int size = endOffset - startOffset;
                if (size == 1) {
                    newBag.addHighlight(startOffset, endOffset, isCertain ? this.attribsAll : this.attribsAllUnc);
                } else if (size > 1) {
                    newBag.addHighlight(startOffset, startOffset + 1, isCertain ? this.attribsLeft : this.attribsLeftUnc);
                    newBag.addHighlight(endOffset - 1, endOffset, isCertain ? this.attribsRight : this.attribsRightUnc);
                    if (size > 2) {
                        newBag.addHighlight(startOffset + 1, endOffset - 1, isCertain ? this.attribsMiddle : this.attribsMiddleUnc);
                    }
                }
            }
            if (this.mousedIndex != i) continue;
            AttributeSet attr = AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{this.attribsHyperlink, AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.Tooltip, new TooltipResolver()})});
            newBag.addHighlight(startOffset, endOffset, attr);
        }
        OffsetsBag bag = MethodChooser.getHighlightsBag(this.doc);
        bag.setHighlights(newBag);
    }

    private AttributeSet createAttribs(Object ... keyValuePairs) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = keyValuePairs.length / 2 - 1; i >= 0; --i) {
            Object attrKey = keyValuePairs[2 * i];
            Object attrValue = keyValuePairs[2 * i + 1];
            if (attrKey == null || attrValue == null) continue;
            list.add(attrKey);
            list.add(attrValue);
        }
        return AttributesUtilities.createImmutable((Object[])list.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributeSet getHyperlinkHighlight() {
        MethodChooser methodChooser = this;
        synchronized (methodChooser) {
            if (defaultHyperlinkHighlight == null) {
                defaultHyperlinkHighlight = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Foreground, Color.BLUE, StyleConstants.Underline, Color.BLUE});
            }
        }
        return defaultHyperlinkHighlight;
    }

    private static final class TooltipResolver
    implements HighlightAttributeValue<String> {
        public String getValue(JTextComponent component, Document document, Object attributeKey, int startOffset, int endOffset) {
            return NbBundle.getMessage(MethodChooser.class, (String)"MSG_Step_Into_Method");
        }
    }

    static class MethodChooserHighlightsLayerFactory
    implements HighlightsLayerFactory {
        MethodChooserHighlightsLayerFactory() {
        }

        public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
            return new HighlightsLayer[]{HighlightsLayer.create((String)MethodChooser.class.getName(), (ZOrder)ZOrder.SYNTAX_RACK.forPosition(10000), (boolean)false, (HighlightsContainer)MethodChooser.getHighlightsBag(context.getDocument()))};
        }
    }

    private class CentralListener
    implements KeyListener,
    MouseListener,
    MouseMotionListener,
    FocusListener {
        private CentralListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            e.consume();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int code = e.getKeyCode();
            boolean consumeEvent = true;
            block0 : switch (code) {
                case 10: 
                case 32: {
                    MethodChooser.this.releaseUI(true);
                    break;
                }
                case 27: {
                    MethodChooser.this.releaseUI(false);
                    break;
                }
                case 9: 
                case 39: 
                case 40: {
                    MethodChooser.this.selectedIndex++;
                    if (MethodChooser.this.selectedIndex == MethodChooser.this.segments.length) {
                        MethodChooser.this.selectedIndex = 0;
                    }
                    MethodChooser.this.requestRepaint();
                    break;
                }
                case 37: 
                case 38: {
                    MethodChooser.this.selectedIndex--;
                    if (MethodChooser.this.selectedIndex < 0) {
                        MethodChooser.this.selectedIndex = MethodChooser.this.segments.length - 1;
                    }
                    MethodChooser.this.requestRepaint();
                    break;
                }
                case 36: {
                    MethodChooser.this.selectedIndex = 0;
                    MethodChooser.this.requestRepaint();
                    break;
                }
                case 35: {
                    MethodChooser.this.selectedIndex = MethodChooser.this.segments.length - 1;
                    MethodChooser.this.requestRepaint();
                    break;
                }
                default: {
                    int x;
                    int mods = e.getModifiersEx();
                    for (x = 0; x < MethodChooser.this.stopEvents.length; ++x) {
                        if (MethodChooser.this.stopEvents[x].getKeyCode() != code || (MethodChooser.this.stopEvents[x].getModifiers() & mods) != MethodChooser.this.stopEvents[x].getModifiers()) continue;
                        MethodChooser.this.releaseUI(false);
                        consumeEvent = false;
                        break;
                    }
                    for (x = 0; x < MethodChooser.this.confirmEvents.length; ++x) {
                        if (MethodChooser.this.confirmEvents[x].getKeyCode() != code || (MethodChooser.this.confirmEvents[x].getModifiers() & mods) != MethodChooser.this.confirmEvents[x].getModifiers()) continue;
                        MethodChooser.this.releaseUI(true);
                        break block0;
                    }
                }
            }
            if (consumeEvent) {
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            e.consume();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                return;
            }
            e.consume();
            int position = MethodChooser.this.editorPane.viewToModel(e.getPoint());
            if (e.getClickCount() == 1 && e.getButton() == 1) {
                if (position < 0) {
                    return;
                }
                if (MethodChooser.this.mousedIndex != -1) {
                    MethodChooser.this.selectedIndex = MethodChooser.this.mousedIndex;
                    MethodChooser.this.releaseUI(true);
                    return;
                }
            }
            try {
                int line = Utilities.getLineOffset((BaseDocument)((BaseDocument)MethodChooser.this.doc), (int)position) + 1;
                if (line < MethodChooser.this.startLine || line > MethodChooser.this.endLine) {
                    MethodChooser.this.releaseUI(false);
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            e.consume();
            int position = MethodChooser.this.editorPane.viewToModel(e.getPoint());
            int newIndex = -1;
            if (position >= 0) {
                for (int x = 0; x < MethodChooser.this.segments.length; ++x) {
                    int start = MethodChooser.this.segments[x].getStartOffset();
                    int end = MethodChooser.this.segments[x].getEndOffset();
                    if (position < start || position > end) continue;
                    newIndex = x;
                    break;
                }
            }
            if (newIndex != MethodChooser.this.mousedIndex) {
                if (newIndex == -1) {
                    MethodChooser.this.editorPane.setCursor(MethodChooser.this.arrowCursor);
                } else {
                    MethodChooser.this.editorPane.setCursor(MethodChooser.this.handCursor);
                }
                MethodChooser.this.mousedIndex = newIndex;
                MethodChooser.this.requestRepaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            e.consume();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            e.consume();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            e.consume();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            e.consume();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            e.consume();
        }

        @Override
        public void focusGained(FocusEvent e) {
            MethodChooser.this.editorPane.getCaret().setVisible(false);
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    public static interface ReleaseListener {
        public void released(boolean var1);
    }

    public static class Segment {
        int startOffset;
        int endOffset;

        public Segment(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }
}

