/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.util.Collection;

class AttachmentHyperlinkSupport {
    private static final String PREFIX = "Created an attachment (id=";
    private static final int EQUAL_SIGN_POSITION = "Created an attachment (id=".lastIndexOf(61);
    private static final int ATTACHMENT_HYPERLINK_START_FALLBACK = "Created an attachment (id=".indexOf("attachment");
    private static final char CR = '\r';
    private static final char LF = '\n';

    AttachmentHyperlinkSupport() {
    }

    static int[] findBoundaries(String text, Collection<String> knownIds) {
        int idStartIndex;
        if (knownIds != null && knownIds.isEmpty()) {
            return null;
        }
        int length = text.length();
        if (length >= EQUAL_SIGN_POSITION + 3 && text.charAt(EQUAL_SIGN_POSITION) == '=' && text.startsWith(PREFIX) && AttachmentHyperlinkSupport.isValidIdChar(text.charAt(idStartIndex = EQUAL_SIGN_POSITION + 1))) {
            int idEndIndex;
            int index;
            for (index = idStartIndex + 1; index < length && AttachmentHyperlinkSupport.isValidIdChar(text.charAt(index)); ++index) {
            }
            if (index < length && text.charAt(index) == ')' && AttachmentHyperlinkSupport.isKnownId(text.substring(idStartIndex, idEndIndex = index), knownIds)) {
                while (++index < length && AttachmentHyperlinkSupport.isNotNewline(text.charAt(index))) {
                }
                if (index < length) {
                    if (text.charAt(index) == '\r') {
                        ++index;
                    }
                    if (index < length && text.charAt(index) == '\n') {
                        ++index;
                    }
                    while (index < length && AttachmentHyperlinkSupport.isSpace(text.charAt(index))) {
                        ++index;
                    }
                    if (index < length && AttachmentHyperlinkSupport.isNotNewline(text.charAt(index))) {
                        int descriptionStart = index;
                        while (++index < length && AttachmentHyperlinkSupport.isNotNewline(text.charAt(index))) {
                        }
                        return new int[]{descriptionStart, index};
                    }
                }
                return new int[]{ATTACHMENT_HYPERLINK_START_FALLBACK, idEndIndex + 1};
            }
        }
        return null;
    }

    static String getAttachmentId(String commentText) {
        int closingBracketPos = commentText.indexOf(41, PREFIX.length() + 1);
        assert (closingBracketPos != -1);
        return new String(commentText.substring(PREFIX.length(), closingBracketPos));
    }

    private static boolean isKnownId(String id, Collection<String> knownIds) {
        if (knownIds == null) {
            return true;
        }
        for (String validId : knownIds) {
            if (!id.equals(validId)) continue;
            return true;
        }
        return false;
    }

    private static boolean isValidIdChar(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isNotNewline(char c) {
        return c != '\r' && c != '\n';
    }

    private static boolean isSpace(char c) {
        return c == ' ' || c == '\t';
    }
}

