/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.eclipse.persistence.jpa.jpql.JPQLQueryHelper;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.modules.j2ee.persistence.spi.jpql.ManagedTypeProvider;
import org.netbeans.modules.j2ee.persistence.spi.jpql.Query;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;

public class JPQLValidation
extends JPAClassRule {
    public JPQLValidation() {
        this.setClassContraints(Arrays.asList(JPAClassRule.ClassConstraints.ENTITY, JPAClassRule.ClassConstraints.EMBEDDABLE, JPAClassRule.ClassConstraints.MAPPED_SUPERCLASS));
    }

    @Override
    public ErrorDescription[] apply(TypeElement subject, ProblemContext ctx) {
        List<AnnotationMirror> first = Utilities.findAnnotations(subject, "javax.persistence.NamedQuery");
        ArrayList<String> values = new ArrayList<String>();
        if (first == null || first.size() == 0) {
            AnnotationMirror qs = Utilities.findAnnotation(subject, "javax.persistence.NamedQueries");
            if (qs != null) {
                Map<? extends ExecutableElement, ? extends AnnotationValue> maps = qs.getElementValues();
                for (AnnotationValue annotationValue : maps.values()) {
                    List lst = (List)annotationValue.getValue();
                    for (Object val : lst) {
                        AnnotationMirror am;
                        if (!(val instanceof AnnotationMirror) || !"javax.persistence.NamedQuery".equals((am = (AnnotationMirror)val).getAnnotationType().toString())) continue;
                        values.add(((Object)Utilities.getAnnotationAttrValue(am, "query")).toString());
                    }
                }
            }
        } else {
            for (AnnotationMirror mr : first) {
                values.add(((Object)Utilities.getAnnotationAttrValue(mr, "query")).toString());
            }
        }
        JPQLQueryHelper helper = new JPQLQueryHelper();
        Project project = FileOwnerQuery.getOwner((FileObject)ctx.getFileObject());
        ArrayList problems = new ArrayList();
        for (String value : values) {
            helper.setQuery((IQuery)new Query(value, (IManagedTypeProvider)new ManagedTypeProvider(project)));
            List tmp = helper.validateGrammar();
            if (tmp == null || tmp.size() <= 0) continue;
            problems.addAll(tmp);
        }
        if (problems != null && problems.size() > 0) {
            return new ErrorDescription[]{JPQLValidation.createProblem((Element)subject, ctx, "JPQL :" + problems, Severity.WARNING)};
        }
        return null;
    }

    @Override
    protected boolean isApplicable(TypeElement subject, ProblemContext ctx) {
        JPAProblemContext jpaCtx = (JPAProblemContext)ctx;
        return jpaCtx.isEntity() || jpaCtx.isMappedSuperClass();
    }

    private AnnotationMirror getFirstAnnotationFromGivenSet(TypeElement subject, Collection<String> annotationClasses) {
        for (String annClass : annotationClasses) {
            AnnotationMirror foundAnn = Utilities.findAnnotation(subject, annClass);
            if (foundAnn == null) continue;
            return foundAnn;
        }
        return null;
    }
}

