/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.session;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.session.TimerOptions;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class SessionEJBWizardPanel
extends JPanel {
    private final ChangeListener listener;
    private final Project project;
    private ComboBoxModel projectsList;
    private final TimerOptions timerOptions;
    private JComboBox inProjectCombo;
    private JLabel interfaceLabel;
    private JInternalFrame jInternalFrame1;
    private JCheckBox localCheckBox;
    private JCheckBox remoteCheckBox;
    private JLabel scheduleLabel;
    private JPanel schedulePanel;
    private JScrollPane scheduleScrollPane;
    private JTextArea scheduleTextArea;
    private ButtonGroup sessionStateButtons;
    private JLabel sessionTypeLabel;
    private JRadioButton singletonButton;
    private JRadioButton statefulButton;
    private JRadioButton statelessButton;

    public SessionEJBWizardPanel(Project project, ChangeListener changeListener, TimerOptions timerOptions) {
        this.listener = changeListener;
        this.project = project;
        this.timerOptions = timerOptions;
        this.initComponents();
        J2eeProjectCapabilities projectCap = J2eeProjectCapabilities.forProject((Project)project);
        if (projectCap.isEjb31LiteSupported()) {
            boolean serverSupportsEJB31 = Util.getSupportedProfiles((Project)project).contains(Profile.JAVA_EE_6_FULL);
            if (!projectCap.isEjb31Supported() && !serverSupportsEJB31) {
                this.remoteCheckBox.setVisible(false);
                this.remoteCheckBox.setEnabled(false);
            }
            if (this.timerOptions == null) {
                this.schedulePanel.setVisible(false);
                this.schedulePanel.setEnabled(false);
            } else {
                this.statefulButton.setEnabled(false);
                this.statefulButton.setVisible(false);
            }
        } else {
            this.schedulePanel.setVisible(false);
            this.schedulePanel.setEnabled(false);
            this.singletonButton.setVisible(false);
            this.singletonButton.setEnabled(false);
            this.localCheckBox.setSelected(true);
        }
        this.localCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SessionEJBWizardPanel.this.listener.stateChanged(null);
            }
        });
        this.inProjectCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SessionEJBWizardPanel.this.listener.stateChanged(null);
            }
        });
        this.remoteCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SessionEJBWizardPanel.this.listener.stateChanged(null);
                SessionEJBWizardPanel.this.updateInProjectCombo(SessionEJBWizardPanel.this.remoteCheckBox.isSelected());
            }
        });
        this.scheduleTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SessionEJBWizardPanel.this.listener.stateChanged(null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SessionEJBWizardPanel.this.listener.stateChanged(null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SessionEJBWizardPanel.this.listener.stateChanged(null);
            }
        });
        this.updateInProjectCombo(false);
    }

    public static boolean isMaven(Project project) {
        return project.getLookup().lookup(AntArtifactProvider.class) == null;
    }

    private void updateInProjectCombo(boolean show) {
        if (show) {
            this.remoteCheckBox.setText(NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_In_Project"));
        } else {
            this.remoteCheckBox.setText(NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_Remote"));
        }
        this.inProjectCombo.setVisible(show);
        if (show && this.projectsList == null) {
            List<Project> projects = SessionEJBWizardPanel.getProjectsList(this.project);
            this.projectsList = new DefaultComboBoxModel<Project>(projects.toArray(new Project[projects.size()]));
            final ListCellRenderer defaultRenderer = this.inProjectCombo.getRenderer();
            if (!projects.isEmpty()) {
                this.inProjectCombo.setRenderer(new ListCellRenderer(){

                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        String name = ProjectUtils.getInformation((Project)((Project)value)).getDisplayName();
                        return defaultRenderer.getListCellRendererComponent(list, name, index, isSelected, cellHasFocus);
                    }
                });
                this.inProjectCombo.setModel(this.projectsList);
                this.inProjectCombo.setSelectedIndex(0);
            }
            this.listener.stateChanged(null);
        }
    }

    public static List<Project> getProjectsList(Project project) {
        ArrayList<Project> names = new ArrayList<Project>();
        boolean maven = SessionEJBWizardPanel.isMaven(project);
        HashSet<Project> allProjects = new HashSet<Project>();
        allProjects.addAll(Arrays.asList(OpenProjects.getDefault().getOpenProjects()));
        allProjects.addAll(SessionEJBWizardPanel.getProjectsFromClasspath(project));
        for (Project p : allProjects) {
            if (p.equals(project) || (!maven ? p.getLookup().lookup(AntArtifactProvider.class) == null || AntArtifactQuery.findArtifactsByType((Project)p, (String)"jar").length == 0 : p.getLookup().lookup(AntArtifactProvider.class) != null)) continue;
            if (ProjectUtils.getSources((Project)p).getSourceGroups("java").length == 0 || p.getLookup().lookup(J2eeModuleProvider.class) != null) continue;
            names.add(p);
        }
        return names;
    }

    public static List<Project> getProjectsFromClasspath(Project project) {
        SourceGroup[] groups;
        ArrayList<Project> projects = new ArrayList<Project>();
        for (SourceGroup group : groups = ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            ClassPath cp = ClassPath.getClassPath((FileObject)group.getRootFolder(), (String)"classpath/compile");
            if (cp == null) continue;
            block1: for (ClassPath.Entry entry : cp.entries()) {
                FileObject[] fos;
                for (FileObject fo : fos = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL()).getRoots()) {
                    Project p = FileOwnerQuery.getOwner((FileObject)fo);
                    if (p == null) continue;
                    projects.add(p);
                    continue block1;
                }
            }
        }
        return projects;
    }

    private void initComponents() {
        this.sessionStateButtons = new ButtonGroup();
        this.jInternalFrame1 = new JInternalFrame();
        this.sessionTypeLabel = new JLabel();
        this.statelessButton = new JRadioButton();
        this.statefulButton = new JRadioButton();
        this.interfaceLabel = new JLabel();
        this.remoteCheckBox = new JCheckBox();
        this.localCheckBox = new JCheckBox();
        this.singletonButton = new JRadioButton();
        this.inProjectCombo = new JComboBox();
        this.schedulePanel = new JPanel();
        this.scheduleLabel = new JLabel();
        this.scheduleScrollPane = new JScrollPane();
        this.scheduleTextArea = new JTextArea();
        this.jInternalFrame1.setVisible(true);
        GroupLayout jInternalFrame1Layout = new GroupLayout(this.jInternalFrame1.getContentPane());
        this.jInternalFrame1.getContentPane().setLayout(jInternalFrame1Layout);
        jInternalFrame1Layout.setHorizontalGroup(jInternalFrame1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jInternalFrame1Layout.setVerticalGroup(jInternalFrame1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((JLabel)this.sessionTypeLabel, (String)NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_SessionType"));
        this.sessionStateButtons.add(this.statelessButton);
        this.statelessButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/session/Bundle").getString("MN_Stateless").charAt(0));
        this.statelessButton.setSelected(true);
        this.statelessButton.setText(NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_Stateless"));
        this.sessionStateButtons.add(this.statefulButton);
        this.statefulButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/session/Bundle").getString("MN_Stateful").charAt(0));
        this.statefulButton.setText(NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_Stateful"));
        Mnemonics.setLocalizedText((JLabel)this.interfaceLabel, (String)NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_Interface"));
        this.remoteCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/session/Bundle").getString("MN_Remote").charAt(0));
        this.remoteCheckBox.setText(NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_Remote"));
        this.localCheckBox.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/session/Bundle").getString("MN_Local").charAt(0));
        this.localCheckBox.setText(NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_Local"));
        this.sessionStateButtons.add(this.singletonButton);
        this.singletonButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/session/Bundle").getString("MN_Singleton").charAt(0));
        this.singletonButton.setText(NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_Singleton"));
        this.scheduleLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/session/Bundle").getString("MN_Schedule").charAt(0));
        this.scheduleLabel.setLabelFor(this.scheduleTextArea);
        this.scheduleLabel.setText(NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_Schedule"));
        this.scheduleLabel.setCursor(new Cursor(0));
        this.scheduleTextArea.setColumns(20);
        this.scheduleTextArea.setLineWrap(true);
        this.scheduleTextArea.setRows(4);
        this.scheduleTextArea.setText("minute=\"*\", second=\"0\", dayOfMonth=\"*\", month=\"*\", year=\"*\", hour=\"9-17\", dayOfWeek=\"Mon-Fri\"");
        this.scheduleTextArea.setWrapStyleWord(true);
        this.scheduleTextArea.setCursor(new Cursor(2));
        this.scheduleScrollPane.setViewportView(this.scheduleTextArea);
        this.scheduleTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_Schedule"));
        GroupLayout schedulePanelLayout = new GroupLayout(this.schedulePanel);
        this.schedulePanel.setLayout(schedulePanelLayout);
        schedulePanelLayout.setHorizontalGroup(schedulePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(schedulePanelLayout.createSequentialGroup().addContainerGap().addGroup(schedulePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scheduleScrollPane, -1, 334, Short.MAX_VALUE).addGroup(schedulePanelLayout.createSequentialGroup().addComponent(this.scheduleLabel).addContainerGap(206, Short.MAX_VALUE)))));
        schedulePanelLayout.setVerticalGroup(schedulePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(schedulePanelLayout.createSequentialGroup().addComponent(this.scheduleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scheduleScrollPane, -2, -1, -2).addContainerGap()));
        this.scheduleLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SessionEJBWizardPanel.class, (String)"LBL_Schedule"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sessionTypeLabel).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.statelessButton)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.statefulButton)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.singletonButton)).addComponent(this.interfaceLabel).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.remoteCheckBox).addComponent(this.localCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inProjectCombo, 0, 244, Short.MAX_VALUE).addContainerGap()).addComponent(this.schedulePanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sessionTypeLabel).addGap(0, 0, 0).addComponent(this.statelessButton).addGap(0, 0, 0).addComponent(this.statefulButton).addGap(0, 0, 0).addComponent(this.singletonButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.interfaceLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.localCheckBox).addGap(2, 2, 2).addComponent(this.remoteCheckBox)).addComponent(this.inProjectCombo, -2, 28, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.schedulePanel, -2, -1, -2)));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/ejbcore/ejb/wizard/session/Bundle");
        this.statelessButton.getAccessibleContext().setAccessibleName(bundle.getString("LBL_Stateless"));
        this.statelessButton.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_Stateless"));
        this.statefulButton.getAccessibleContext().setAccessibleName(bundle.getString("LBL_Stateful"));
        this.statefulButton.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_Stateful"));
        this.remoteCheckBox.getAccessibleContext().setAccessibleName(bundle.getString("LBL_Remote"));
        this.remoteCheckBox.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_Remote"));
        this.localCheckBox.getAccessibleContext().setAccessibleName(bundle.getString("LBL_Local"));
        this.localCheckBox.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_Local"));
    }

    public String getSessionType() {
        if (this.statelessButton.isSelected()) {
            return "Stateless";
        }
        if (this.statefulButton.isSelected()) {
            return "Stateful";
        }
        if (this.singletonButton.isSelected()) {
            return "Singleton";
        }
        return "";
    }

    public boolean isRemote() {
        return this.remoteCheckBox.isSelected();
    }

    public boolean isLocal() {
        return this.localCheckBox.isSelected();
    }

    public TimerOptions getTimerOptions() {
        if (this.timerOptions == null) {
            return null;
        }
        this.timerOptions.setTimerOptions(this.scheduleTextArea.getText());
        return this.timerOptions;
    }

    public String getTimerOptionsError() {
        return TimerOptions.validate(this.scheduleTextArea.getText());
    }

    public Project getRemoteInterfaceProject() {
        if (this.projectsList == null) {
            return null;
        }
        return (Project)this.projectsList.getSelectedItem();
    }
}

