/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.spi;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.apisupport.project.api.ManifestManager;
import org.netbeans.modules.apisupport.project.layers.LayerFileSystem;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.XMLFileSystem;

public class LayerUtil {
    @NonNull
    public static FileSystem mergeFilesystems(FileSystem writableLayer, Collection<FileSystem> readOnlyLayers) {
        if (writableLayer == null) {
            writableLayer = new XMLFileSystem();
        }
        FileSystem[] layers = new FileSystem[readOnlyLayers.size() + 1];
        layers[0] = writableLayer;
        Iterator<FileSystem> it = readOnlyLayers.iterator();
        int i = 1;
        while (it.hasNext()) {
            layers[i] = it.next();
            ++i;
        }
        return new LayerFileSystem(layers);
    }

    public static List<URL> layersOf(File jar) throws IOException {
        ManifestManager mm = ManifestManager.getInstanceFromJAR(jar, true);
        for (String tok : mm.getRequiredTokens()) {
            if (!tok.startsWith("org.openide.modules.os.")) continue;
            return Collections.emptyList();
        }
        String layer = mm.getLayer();
        String generatedLayer = mm.getGeneratedLayer();
        ArrayList<URL> urls = new ArrayList<URL>(2);
        URI juri = jar.toURI();
        for (String path : new String[]{layer, generatedLayer}) {
            if (path == null) continue;
            urls.add(new URL("jar:" + juri + "!/" + path));
        }
        if (layer != null) {
            urls.add(new URL("jar:" + juri + "!/" + layer));
        }
        if (generatedLayer != null) {
            urls.add(new URL("jar:" + juri + "!/" + generatedLayer));
        }
        return urls;
    }

    private LayerUtil() {
    }
}

