/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.options;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.options.OptionsPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.options.OptionsPanel0;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class NewOptionsIterator
extends BasicWizardIterator {
    private DataModel data;

    private NewOptionsIterator() {
    }

    public Set instantiate() throws IOException {
        CreatedModifiedFiles cmf = this.data.getCreatedModifiedFiles();
        cmf.run();
        return NewOptionsIterator.getCreatedFiles(cmf, this.data.getProject());
    }

    @Override
    protected BasicWizardIterator.Panel[] createPanels(WizardDescriptor wiz) {
        this.data = new DataModel(wiz);
        return new BasicWizardIterator.Panel[]{new OptionsPanel0(wiz, this.data), new OptionsPanel(wiz, this.data)};
    }

    @Override
    public void uninitialize(WizardDescriptor wiz) {
        super.uninitialize(wiz);
        this.data = null;
    }

    static final class DataModel
    extends BasicWizardIterator.BasicDataModel {
        private static final int SUCCESS = 0;
        private static final int ERR_INVALID_CLASSNAME_PREFIX = 1;
        private static final int MSG_BLANK_SECONDARY_PANEL_TITLE = 1024;
        private static final int MSG_BLANK_PRIMARY_PANEL = 1026;
        private static final int MSG_BLANK_CATEGORY_NAME = 1028;
        private static final int MSG_BLANK_ICONPATH = 1029;
        private static final int MSG_BLANK_PACKAGE_NAME = 1030;
        private static final int MSG_BLANK_CLASSNAME_PREFIX = 1031;
        private static final int MSG_BLANK_KEYWORDS = 1032;
        private static final int WARNING_INCORRECT_ICON_SIZE = -1;
        private static final String[] CATEGORY_BUNDLE_KEYS = new String[]{"OptionsCategory_Name", "OptionsCategory_Keywords"};
        private static final String[] ADVANCED_BUNDLE_KEYS = new String[]{"AdvancedOption_DisplayName", "AdvancedOption_Keywords"};
        private static final String[] TOKENS = new String[]{"PACKAGE_NAME", "AdvancedOption_CLASS_NAME", "OptionsCategory_CLASS_NAME", "Panel_CLASS_NAME", "OptionsPanelController_CLASS_NAME", "OptionsPanelController_ANNOTATION", ADVANCED_BUNDLE_KEYS[0], ADVANCED_BUNDLE_KEYS[1], CATEGORY_BUNDLE_KEYS[0], CATEGORY_BUNDLE_KEYS[1]};
        private static final String ADVANCED_OPTION = "AdvancedOption";
        private static final String OPTIONS_CATEGORY = "OptionsCategory";
        private static final String PANEL = "Panel";
        private static final String OPTIONS_PANEL_CONTROLLER = "OptionsPanelController";
        private static final String JAVA_TEMPLATE_PREFIX = "template_myplugin";
        private static final String FORM_TEMPLATE_PREFIX = "template_myplugin_form";
        private CreatedModifiedFiles files;
        private String codeNameBase;
        private boolean advanced;
        private String primaryPanel;
        private String secondaryPanelTitle;
        private String primaryKeywords;
        private String categoryName;
        private File icon;
        private String secondaryKeywords;
        private boolean allowAdvanced;
        private String classNamePrefix;

        DataModel(WizardDescriptor wiz) {
            super(wiz);
        }

        int setDataForSecondaryPanel(String primaryPanel, String secondaryPanelTitle, String secondaryKeywords) {
            this.advanced = true;
            this.primaryPanel = primaryPanel;
            this.secondaryPanelTitle = secondaryPanelTitle;
            this.secondaryKeywords = secondaryKeywords;
            return this.checkFirstPanel();
        }

        int setDataForPrimaryPanel(String categoryName, File icon, boolean allowAdvanced, String primaryKeywords) {
            this.advanced = false;
            this.categoryName = categoryName;
            this.icon = icon;
            this.allowAdvanced = allowAdvanced;
            this.primaryKeywords = primaryKeywords;
            return this.checkFirstPanel();
        }

        @Override
        public String getPackageName() {
            String retValue = super.getPackageName();
            if (retValue == null) {
                retValue = this.getCodeNameBase();
                super.setPackageName(retValue);
            }
            return retValue;
        }

        public int setPackageAndPrefix(String packageName, String classNamePrefix) {
            this.setPackageName(packageName);
            this.classNamePrefix = classNamePrefix;
            int errCode = this.checkFinalPanel();
            if (DataModel.isSuccessCode(errCode)) {
                this.generateCreatedModifiedFiles();
            }
            return errCode;
        }

        private Map<String, String> getTokenMap(boolean useAnnotations) {
            HashMap<String, String> retval = new HashMap<String, String>();
            for (int i = 0; i < TOKENS.length; ++i) {
                retval.put(TOKENS[i], this.getReplacement(TOKENS[i], useAnnotations));
            }
            return retval;
        }

        private String getReplacement(String key, boolean useAnnotations) {
            if ("PACKAGE_NAME".equals(key)) {
                return this.getPackageName();
            }
            if ("AdvancedOption_CLASS_NAME".equals(key)) {
                return this.getAdvancedOptionClassName();
            }
            if ("OptionsCategory_CLASS_NAME".equals(key)) {
                return this.getOptionsCategoryClassName();
            }
            if ("Panel_CLASS_NAME".equals(key)) {
                return this.getPanelClassName();
            }
            if ("OptionsPanelController_CLASS_NAME".equals(key)) {
                return this.getOptionsPanelControllerClassName();
            }
            if ("OptionsPanelController_ANNOTATION".equals(key)) {
                if (!useAnnotations) {
                    return "";
                }
                if (this.isAdvanced()) {
                    return "@OptionsPanelController.SubRegistration(\n    location=\"" + this.getPrimaryPanel() + "\",\n" + "    displayName=\"#AdvancedOption_DisplayName_" + this.getClassNamePrefix() + "\",\n" + "    keywords=\"#AdvancedOption_Keywords_" + this.getClassNamePrefix() + "\",\n" + "    keywordsCategory=\"" + this.getPrimaryPanel() + "/" + this.getClassNamePrefix() + "\"\n" + ")\n" + "@org.openide.util.NbBundle.Messages({\"AdvancedOption_DisplayName_" + this.getClassNamePrefix() + "=" + this.getSecondaryPanelTitle() + "\", " + "\"AdvancedOption_Keywords_" + this.getClassNamePrefix() + "=" + this.getSecondaryKeywords() + "\"})\n";
                }
                if (this.isAdvancedCategory()) {
                    return "<should never be used>";
                }
                return "@OptionsPanelController.TopLevelRegistration(\n    categoryName=\"#OptionsCategory_Name_" + this.getClassNamePrefix() + "\",\n" + "    iconBase=\"" + this.getIconPath() + "\",\n" + "    keywords=\"#OptionsCategory_Keywords_" + this.getClassNamePrefix() + "\",\n" + "    keywordsCategory=\"" + this.getClassNamePrefix() + "\"\n" + ")\n" + "@org.openide.util.NbBundle.Messages({\"OptionsCategory_Name_" + this.getClassNamePrefix() + "=" + this.getCategoryName() + "\", " + "\"OptionsCategory_Keywords_" + this.getClassNamePrefix() + "=" + this.getPrimaryKeywords() + "\"})";
            }
            return key + "_" + this.getClassNamePrefix();
        }

        private String getBundleValue(String key) {
            if (key.startsWith("OptionsCategory_Name")) {
                return this.getCategoryName();
            }
            if (key.startsWith("AdvancedOption_DisplayName")) {
                return this.getSecondaryPanelTitle();
            }
            if (key.startsWith("OptionsCategory_Keywords")) {
                return this.getPrimaryKeywords();
            }
            if (key.startsWith("AdvancedOption_Keywords")) {
                return this.getSecondaryKeywords();
            }
            throw new AssertionError((Object)key);
        }

        String getMessage(int code) {
            String field = null;
            switch (code) {
                case 0: {
                    return "";
                }
                case 1024: {
                    field = "FIELD_SecondaryPanelTitle";
                    break;
                }
                case 1026: {
                    field = "FIELD_PrimaryPanel";
                    break;
                }
                case 1032: {
                    field = "FIELD_Keywords";
                    break;
                }
                case 1028: {
                    field = "FIELD_CategoryName";
                    break;
                }
                case 1029: {
                    field = "FIELD_IconPath";
                    break;
                }
                case 1030: {
                    field = "FIELD_PackageName";
                    break;
                }
                case 1031: {
                    field = "FIELD_ClassNamePrefix";
                    break;
                }
                case 1: {
                    field = "FIELD_ClassNamePrefix";
                    break;
                }
                case -1: {
                    assert (this.icon.exists());
                    return UIUtil.getIconDimensionWarning(this.icon, 32, 32);
                }
                default: {
                    assert (false) : "Unknown code: " + code;
                    break;
                }
            }
            field = NbBundle.getMessage(NewOptionsIterator.class, (String)field);
            if (DataModel.isErrorCode(code)) {
                return NbBundle.getMessage(NewOptionsIterator.class, (String)"ERR_FieldInvalid", (Object)field);
            }
            if (DataModel.isInfoCode(code)) {
                return NbBundle.getMessage(NewOptionsIterator.class, (String)"MSG_FieldEmpty", (Object)field);
            }
            return "";
        }

        static boolean isSuccessCode(int code) {
            return code == 0;
        }

        static boolean isErrorCode(int code) {
            return 0 < code && code < 1024;
        }

        static boolean isWarningCode(int code) {
            return code < 0;
        }

        static boolean isInfoCode(int code) {
            return code >= 1024;
        }

        private int checkFirstPanel() {
            if (this.advanced) {
                if (this.getPrimaryPanel().length() == 0) {
                    return 1026;
                }
                if (this.getSecondaryPanelTitle().length() == 0) {
                    return 1024;
                }
                if (this.getSecondaryKeywords().length() == 0) {
                    return 1032;
                }
            } else {
                if (this.getCategoryName().length() == 0) {
                    return 1028;
                }
                if (this.getIconPath().length() == 0) {
                    return 1029;
                }
                if (this.getPrimaryKeywords().length() == 0) {
                    return 1032;
                }
                if (!this.icon.exists()) {
                    return 1029;
                }
                assert (this.icon.exists());
                if (!UIUtil.isValidIcon(this.icon, 32, 32)) {
                    return -1;
                }
            }
            return 0;
        }

        private int checkFinalPanel() {
            if (this.getPackageName().length() == 0) {
                return 1030;
            }
            if (this.getClassNamePrefix().length() == 0) {
                return 1031;
            }
            if (!Utilities.isJavaIdentifier((String)this.getClassNamePrefix())) {
                return 1;
            }
            return 0;
        }

        public CreatedModifiedFiles getCreatedModifiedFiles() {
            if (this.files == null) {
                this.files = this.generateCreatedModifiedFiles();
            }
            return this.files;
        }

        private CreatedModifiedFiles generateCreatedModifiedFiles() {
            assert (DataModel.isSuccessCode(this.checkFirstPanel()) || DataModel.isWarningCode(this.checkFirstPanel()));
            assert (DataModel.isSuccessCode(this.checkFinalPanel()));
            this.files = new CreatedModifiedFiles(this.getProject());
            boolean useAnnotations = true;
            try {
                SpecificationVersion apiVersion = this.getModuleInfo().getDependencyVersion("org.netbeans.modules.options.api");
                useAnnotations = apiVersion == null || apiVersion.compareTo((Object)new SpecificationVersion("1.14")) >= 0;
            }
            catch (IOException x) {
                Logger.getLogger(NewOptionsIterator.class.getName()).log(Level.INFO, null, x);
            }
            this.generateDependencies();
            if (useAnnotations && this.isAdvancedCategory()) {
                this.generatePackageInfo();
            } else {
                this.generateFiles(useAnnotations);
            }
            if (!useAnnotations) {
                this.generateBundleKeys();
                this.generateLayerEntry();
            }
            if (!this.isAdvanced()) {
                this.addCreateIconOperation(this.files, this.icon.getAbsolutePath());
            }
            return this.files;
        }

        private void generateFiles(boolean useAnnotations) {
            if (this.isAdvanced()) {
                this.files.add(this.createJavaFileCopyOperation(OPTIONS_PANEL_CONTROLLER, useAnnotations));
                this.files.add(this.createJavaFileCopyOperation(PANEL, useAnnotations));
                this.files.add(this.createFormFileCopyOperation(PANEL));
            } else if (!this.isAdvancedCategory()) {
                this.files.add(this.createJavaFileCopyOperation(OPTIONS_PANEL_CONTROLLER, useAnnotations));
                this.files.add(this.createJavaFileCopyOperation(PANEL, useAnnotations));
                this.files.add(this.createFormFileCopyOperation(PANEL));
            }
        }

        private void generateBundleKeys() {
            String[] bundleKeys = this.isAdvanced() ? ADVANCED_BUNDLE_KEYS : CATEGORY_BUNDLE_KEYS;
            for (int i = 0; i < bundleKeys.length; ++i) {
                String key = this.getReplacement(bundleKeys[i], false);
                String value = this.getBundleValue(key);
                this.files.add(this.files.bundleKey(this.getDefaultPackagePath("Bundle.properties", true), key, value));
            }
        }

        private void generateDependencies() {
            this.files.add(this.files.addModuleDependency("org.openide.util"));
            this.files.add(this.files.addModuleDependency("org.openide.util.lookup"));
            this.files.add(this.files.addModuleDependency("org.netbeans.modules.options.api", "1", null, true));
            this.files.add(this.files.addModuleDependency("org.openide.awt"));
        }

        private void generateLayerEntry() {
            if (this.isAdvanced()) {
                String resourcePathPrefix = "OptionsDialog/" + this.getPrimaryPanel() + "/";
                String instanceName = this.getAdvancedOptionClassName();
                String instanceFullPath = resourcePathPrefix + this.getPackageName().replace('.', '-') + "-" + instanceName + ".instance";
                this.files.add(this.files.createLayerEntry(instanceFullPath, null, null, null, null));
                this.files.add(this.files.createLayerAttribute(instanceFullPath, "instanceCreate", "methodvalue:org.netbeans.spi.options.AdvancedOption.createSubCategory"));
                this.files.add(this.files.createLayerAttribute(instanceFullPath, "controller", "newvalue:" + this.getPackageName() + "." + this.getOptionsPanelControllerClassName()));
                this.files.add(this.files.createLayerAttribute(instanceFullPath, "displayName", "bundlevalue:" + this.getPackageName() + ".Bundle#AdvancedOption_DisplayName_" + this.getClassNamePrefix()));
                this.files.add(this.files.createLayerAttribute(instanceFullPath, "keywords", "bundlevalue:" + this.getPackageName() + ".Bundle#AdvancedOption_Keywords_" + this.getClassNamePrefix()));
                this.files.add(this.files.createLayerAttribute(instanceFullPath, "keywordsCategory", this.getPrimaryPanel() + "/" + this.getClassNamePrefix()));
            } else {
                String resourcePathPrefix = "OptionsDialog/";
                String instanceName = this.isAdvancedCategory() ? this.getClassNamePrefix() : this.getOptionsCategoryClassName();
                String instanceFullPath = resourcePathPrefix + instanceName + ".instance";
                HashMap<String, String> attrsMap = new HashMap<String, String>(7);
                attrsMap.put("iconBase", this.getIconPath());
                attrsMap.put("keywordsCategory", this.getClassNamePrefix());
                this.files.add(this.files.createLayerEntry(instanceFullPath, null, null, null, attrsMap));
                this.files.add(this.files.createLayerAttribute(instanceFullPath, "instanceCreate", "methodvalue:org.netbeans.spi.options.OptionsCategory.createCategory"));
                this.files.add(this.files.createLayerAttribute(instanceFullPath, "categoryName", "bundlevalue:" + this.getPackageName() + ".Bundle#OptionsCategory_Name_" + this.getClassNamePrefix()));
                if (this.isAdvancedCategory()) {
                    this.files.add(this.files.createLayerAttribute(instanceFullPath, "advancedOptionsFolder", resourcePathPrefix + instanceName));
                } else {
                    this.files.add(this.files.createLayerAttribute(instanceFullPath, "controller", "newvalue:" + this.getPackageName() + "." + this.getOptionsPanelControllerClassName()));
                }
                this.files.add(this.files.createLayerAttribute(instanceFullPath, "keywords", "bundlevalue:" + this.getPackageName() + ".Bundle#OptionsCategory_Keywords_" + this.getClassNamePrefix()));
            }
        }

        private void generatePackageInfo() {
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
            attrs.put("id", this.getClassNamePrefix());
            attrs.put("categoryName", "#OptionsCategory_Name_" + this.getClassNamePrefix());
            attrs.put("iconBase", this.getIconPath());
            attrs.put("keywords", "#OptionsCategory_Keywords_" + this.getClassNamePrefix());
            attrs.put("keywordsCategory", this.getClassNamePrefix());
            LinkedHashMap<String, Map<String, Object>> annotations = new LinkedHashMap<String, Map<String, Object>>();
            annotations.put("org.netbeans.spi.options.OptionsPanelController.ContainerRegistration", attrs);
            annotations.put("org.openide.util.NbBundle.Messages", Collections.singletonMap("value", new String[]{"OptionsCategory_Name_" + this.getClassNamePrefix() + "=" + this.getCategoryName(), "OptionsCategory_Keywords_" + this.getClassNamePrefix() + "=" + this.getPrimaryKeywords()}));
            this.files.add(this.files.packageInfo(this.getPackageName(), annotations));
        }

        private CreatedModifiedFiles.Operation createJavaFileCopyOperation(String templateSuffix, boolean useAnnotations) {
            FileObject template = CreatedModifiedFiles.getTemplate(JAVA_TEMPLATE_PREFIX + templateSuffix + ".java");
            assert (template != null) : "template_myplugin" + templateSuffix;
            return this.files.createFileWithSubstitutions(this.getFilePath(templateSuffix), template, this.getTokenMap(useAnnotations));
        }

        private String getFilePath(String templateSuffix) {
            String fileName = this.getClassNamePrefix() + templateSuffix + ".java";
            return this.getDefaultPackagePath(fileName, false);
        }

        private CreatedModifiedFiles.Operation createFormFileCopyOperation(String templateSuffix) {
            FileObject template = CreatedModifiedFiles.getTemplate(FORM_TEMPLATE_PREFIX + templateSuffix + ".form");
            assert (template != null) : "template_myplugin" + templateSuffix;
            String fileName = this.getClassNamePrefix() + templateSuffix + ".form";
            String filePath = this.getDefaultPackagePath(fileName, false);
            return this.files.createFile(filePath, template);
        }

        private String getCodeNameBase() {
            if (this.codeNameBase == null) {
                NbModuleProvider mod = (NbModuleProvider)this.getProject().getLookup().lookup(NbModuleProvider.class);
                this.codeNameBase = mod.getCodeNameBase();
            }
            return this.codeNameBase;
        }

        private String getPrimaryPanel() {
            return this.primaryPanel;
        }

        private String getSecondaryPanelTitle() {
            assert (!this.isAdvanced() || this.secondaryPanelTitle != null);
            return this.secondaryPanelTitle;
        }

        private String getPrimaryKeywords() {
            assert (this.isAdvanced() || this.primaryKeywords != null);
            return this.primaryKeywords;
        }

        private String getSecondaryKeywords() {
            assert (!this.isAdvanced() || this.secondaryKeywords != null);
            return this.secondaryKeywords;
        }

        private String getCategoryName() {
            assert (this.isAdvanced() || this.categoryName != null);
            return this.categoryName;
        }

        private String getIconPath() {
            String iconRel;
            assert (this.isAdvanced() || this.icon != null);
            FileObject iconFO = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.icon));
            if (iconFO != null && (iconRel = FileUtil.getRelativePath((FileObject)Util.getResourceDirectory(this.getProject()), (FileObject)iconFO)) != null) {
                return iconRel;
            }
            return this.getPackageName().replace('.', '/') + '/' + this.icon.getName();
        }

        String getClassNamePrefix() {
            if (this.classNamePrefix == null) {
                this.classNamePrefix = this.isAdvanced() ? this.getSecondaryPanelTitle() : this.getCategoryName();
                this.classNamePrefix = this.classNamePrefix.trim().replaceAll(" ", "");
                if (!Utilities.isJavaIdentifier((String)this.classNamePrefix)) {
                    this.classNamePrefix = "";
                }
            }
            return this.classNamePrefix;
        }

        private boolean isAdvanced() {
            return this.advanced;
        }

        private boolean isAdvancedCategory() {
            return this.allowAdvanced;
        }

        private String getAdvancedOptionClassName() {
            return this.getClassName(ADVANCED_OPTION);
        }

        private String getOptionsCategoryClassName() {
            return this.getClassName(OPTIONS_CATEGORY);
        }

        private String getPanelClassName() {
            return this.getClassName(PANEL);
        }

        private String getOptionsPanelControllerClassName() {
            return this.getClassName(OPTIONS_PANEL_CONTROLLER);
        }

        private String getClassName(String suffix) {
            return this.getClassNamePrefix() + suffix;
        }
    }
}

