/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.winsys;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.common.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.BasicSettingsPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.NameAndLocationPanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.windows.WindowManager;

public final class NewTCIterator
extends BasicWizardIterator {
    private DataModel data;

    public Set instantiate() throws IOException {
        CreatedModifiedFiles cmf = this.data.getCreatedModifiedFiles();
        cmf.run();
        return NewTCIterator.getCreatedFiles(cmf, this.data.getProject());
    }

    @Override
    protected BasicWizardIterator.Panel[] createPanels(WizardDescriptor wiz) {
        this.data = new DataModel(wiz);
        return new BasicWizardIterator.Panel[]{new BasicSettingsPanel(wiz, this.data), new NameAndLocationPanel(wiz, this.data)};
    }

    @Override
    public void uninitialize(WizardDescriptor wiz) {
        super.uninitialize(wiz);
        this.data = null;
    }

    static void generateFileChanges(DataModel model) {
        Map<String, String> newModes;
        boolean propertiesPersistence;
        boolean xmlLessTC;
        boolean actionLessTC;
        CreatedModifiedFiles fileChanges = new CreatedModifiedFiles(model.getProject());
        Project project = model.getProject();
        NbModuleProvider moduleInfo = model.getModuleInfo();
        String name = model.getName();
        String packageName = model.getPackageName();
        String mode = model.getMode();
        try {
            SpecificationVersion current = model.getModuleInfo().getDependencyVersion("org.openide.windows");
            actionLessTC = current == null || current.compareTo((Object)new SpecificationVersion("6.24")) >= 0;
            xmlLessTC = current == null || current.compareTo((Object)new SpecificationVersion("6.37")) >= 0;
        }
        catch (IOException ex) {
            Logger.getLogger(NewTCIterator.class.getName()).log(Level.INFO, null, ex);
            actionLessTC = false;
            xmlLessTC = false;
        }
        try {
            SpecificationVersion current = model.getModuleInfo().getDependencyVersion("org.netbeans.modules.settings");
            propertiesPersistence = current == null || current.compareTo((Object)new SpecificationVersion("1.18")) >= 0;
        }
        catch (IOException ex) {
            Logger.getLogger(NewTCIterator.class.getName()).log(Level.INFO, null, ex);
            propertiesPersistence = false;
        }
        if (name != null) {
            HashMap<String, String> replaceTokens = new HashMap<String, String>();
            replaceTokens.put("TEMPLATENAME", name);
            replaceTokens.put("PACKAGENAME", packageName);
            replaceTokens.put("MODE", mode);
            replaceTokens.put("OPENED", model.isOpened() ? "true" : "false");
            replaceTokens.put("WINSYSBEHAVIOR", NewTCIterator.defineWinSysBehavior(model));
            String icon = model.getIcon();
            File fil = null;
            if (icon != null && !(fil = new File(icon)).exists()) {
                fil = null;
            }
            String relativeIconPath = null;
            if (fil != null) {
                FileObject fo = FileUtil.toFileObject((File)fil);
                if (!FileUtil.isParentOf((FileObject)Util.getResourceDirectory(project), (FileObject)fo)) {
                    String iconPath = NewTCIterator.getRelativePath(moduleInfo.getResourceDirectoryPath(false), packageName, "", fo.getNameExt());
                    fileChanges.add(fileChanges.createFile(iconPath, fo));
                    relativeIconPath = packageName.replace('.', '/') + "/" + fo.getNameExt();
                } else {
                    relativeIconPath = FileUtil.getRelativePath((FileObject)Util.getResourceDirectory(project), (FileObject)fo);
                }
                replaceTokens.put("ICONPATH", relativeIconPath);
                replaceTokens.put("COMMENTICON", "");
            } else {
                replaceTokens.put("ICONPATH", "SET/PATH/TO/ICON/HERE");
                replaceTokens.put("COMMENTICON", "//");
            }
            replaceTokens.put("MODULENAME", moduleInfo.getCodeNameBase());
            String specVersion = moduleInfo.getSpecVersion();
            replaceTokens.put("SPECVERSION", specVersion != null ? specVersion : "0");
            fileChanges.add(fileChanges.addModuleDependency("org.openide.windows"));
            fileChanges.add(fileChanges.addManifestToken("OpenIDE-Module-Requires", WindowManager.class.getName()));
            fileChanges.add(fileChanges.addModuleDependency("org.openide.util"));
            fileChanges.add(fileChanges.addModuleDependency("org.openide.util.lookup"));
            fileChanges.add(fileChanges.addModuleDependency("org.openide.awt"));
            if (propertiesPersistence) {
                fileChanges.add(fileChanges.addModuleDependency("org.netbeans.modules.settings"));
            }
            String tcName = NewTCIterator.getRelativePath(moduleInfo.getSourceDirectoryPath(), packageName, name, "TopComponent.java");
            FileObject template = CreatedModifiedFiles.getTemplate(xmlLessTC ? "templateTopComponent637.java" : (propertiesPersistence ? "templateTopComponentAnno.java" : "templateTopComponent.java"));
            fileChanges.add(fileChanges.createFileWithSubstitutions(tcName, template, replaceTokens));
            String tcFormName = NewTCIterator.getRelativePath(moduleInfo.getSourceDirectoryPath(), packageName, name, "TopComponent.form");
            template = CreatedModifiedFiles.getTemplate("templateTopComponent.form");
            fileChanges.add(fileChanges.createFileWithSubstitutions(tcFormName, template, replaceTokens));
            if (!actionLessTC) {
                String actionName = NewTCIterator.getRelativePath(moduleInfo.getSourceDirectoryPath(), packageName, name, "Action.java");
                template = CreatedModifiedFiles.getTemplate("templateAction.java");
                fileChanges.add(fileChanges.createFileWithSubstitutions(actionName, template, replaceTokens));
            }
            if (!xmlLessTC) {
                String settingsName = name + "TopComponent.settings";
                template = CreatedModifiedFiles.getTemplate("templateSettings.xml");
                fileChanges.add(fileChanges.createLayerEntry("Windows2/Components/" + settingsName, template, replaceTokens, null, null));
            }
            if (!xmlLessTC) {
                String wstcrefName = name + "TopComponent.wstcref";
                template = CreatedModifiedFiles.getTemplate("templateWstcref.xml");
                fileChanges.add(fileChanges.createLayerEntry("Windows2/Modes/" + mode + "/" + wstcrefName, template, replaceTokens, null, null));
            }
            String bundlePath = NewTCIterator.getRelativePath(moduleInfo.getResourceDirectoryPath(false), packageName, "", "Bundle.properties");
            if (!xmlLessTC) {
                if (actionLessTC) {
                    String path = "Actions/Window/" + packageName.replace('.', '-') + "-" + name + "Action.instance";
                    HashMap<String, String> attrs = new HashMap<String, String>();
                    attrs.put("instanceCreate", "methodvalue:org.openide.windows.TopComponent.openAction");
                    attrs.put("component", "methodvalue:" + packageName + '.' + name + "TopComponent.findInstance");
                    if (relativeIconPath != null) {
                        attrs.put("iconBase", relativeIconPath);
                    }
                    attrs.put("displayName", "bundlevalue:" + packageName + ".Bundle#CTL_" + name + "Action");
                    fileChanges.add(fileChanges.createLayerEntry(path, null, null, null, attrs));
                    fileChanges.add(fileChanges.createLayerEntry("Menu/Window/" + name + "Action.shadow", null, null, null, Collections.singletonMap("originalFile", path)));
                } else {
                    fileChanges.add(fileChanges.layerModifications(new CreateActionEntryOperation(name + "Action", packageName), Collections.<String>emptySet()));
                }
            }
            if (!xmlLessTC) {
                fileChanges.add(fileChanges.bundleKey(bundlePath, "CTL_" + name + "Action", name));
                fileChanges.add(fileChanges.bundleKey(bundlePath, "CTL_" + name + "TopComponent", name + " Window"));
                fileChanges.add(fileChanges.bundleKey(bundlePath, "HINT_" + name + "TopComponent", "This is a " + name + " window"));
            }
        }
        if ((newModes = model.getNewModes()) != null) {
            HashSet<String> files = new HashSet<String>();
            FileObject parent = model.sfs.findResource("Windows2/Modes");
            for (String wsmode : newModes.keySet()) {
                files.add(LayerUtils.findGeneratedName(parent, wsmode + ".wsmode"));
            }
            fileChanges.add(fileChanges.layerModifications(new CreatedModifiedFiles.LayerOperation(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run(FileSystem layer) throws IOException {
                    FileObject fo = FileUtil.createFolder((FileObject)layer.getRoot(), (String)"Windows2/Modes");
                    for (Map.Entry entry : newModes.entrySet()) {
                        FileObject wsmode = fo.createData((String)entry.getKey() + ".wsmode");
                        OutputStream os = wsmode.getOutputStream();
                        try {
                            os.write(((String)entry.getValue()).getBytes("UTF-8"));
                        }
                        finally {
                            os.close();
                        }
                    }
                }
            }, files));
        }
        model.setCreatedModifiedFiles(fileChanges);
    }

    private static String defineWinSysBehavior(DataModel model) {
        StringBuffer res = new StringBuffer();
        if (model.isClosingNotAllowed()) {
            res.append("\tputClientProperty(TopComponent.PROP_CLOSING_DISABLED, Boolean.TRUE);\n");
        }
        if (model.isDraggingNotAllowed()) {
            res.append("\tputClientProperty(TopComponent.PROP_DRAGGING_DISABLED, Boolean.TRUE);\n");
        }
        if (model.isMaximizationNotAllowed()) {
            res.append("\tputClientProperty(TopComponent.PROP_MAXIMIZATION_DISABLED, Boolean.TRUE);\n");
        }
        if (model.isSlidingNotAllowed()) {
            res.append("\tputClientProperty(TopComponent.PROP_SLIDING_DISABLED, Boolean.TRUE);\n");
        }
        if (model.isUndockingNotAllowed()) {
            res.append("\tputClientProperty(TopComponent.PROP_UNDOCKING_DISABLED, Boolean.TRUE);\n");
        }
        if (model.isKeepPrefSize()) {
            res.append("\tputClientProperty(TopComponent.PROP_KEEP_PREFERRED_SIZE_WHEN_SLIDED_IN, Boolean.TRUE);\n");
        }
        return res.toString();
    }

    private static String getRelativePath(String rootpath, String fullyQualifiedPackageName, String prefix, String postfix) {
        StringBuffer sb = new StringBuffer();
        sb.append(rootpath).append('/').append(fullyQualifiedPackageName.replace('.', '/')).append('/').append(prefix).append(postfix);
        return sb.toString();
    }

    static class CreateActionEntryOperation
    implements CreatedModifiedFiles.LayerOperation {
        private String name;
        private String packageName;

        public CreateActionEntryOperation(String actionname, String packageName) {
            this.packageName = packageName;
            this.name = actionname;
        }

        @Override
        public void run(FileSystem layer) throws IOException {
            FileObject folder = layer.getRoot().getFileObject("Actions/Window");
            if (folder == null) {
                folder = FileUtil.createFolder((FileObject)layer.getRoot(), (String)"Actions/Window");
            }
            String instance = this.packageName.replace('.', '-') + "-" + this.name;
            FileObject file = folder.createData(instance, "instance");
            folder = layer.getRoot().getFileObject("Menu/Window");
            if (folder == null) {
                folder = FileUtil.createFolder((FileObject)layer.getRoot(), (String)"Menu/Window");
            }
            file = folder.createData(this.name, "shadow");
            file.setAttribute("originalFile", (Object)("Actions/Window/" + instance + ".instance"));
        }
    }

    static final class DataModel
    extends BasicWizardIterator.BasicDataModel {
        private String name;
        private String icon;
        private String mode;
        private boolean opened = false;
        private boolean keepPrefSize = false;
        private boolean slidingNotAllowed = false;
        private boolean closingNotAllowed = false;
        private boolean draggingNotAllowed = false;
        private boolean undockingNotAllowed = false;
        private boolean maximizationNotAllowed = false;
        private Map<String, String> newModes;
        private Set<String> existingModes;
        private boolean ignorePreviousRun = true;
        private CreatedModifiedFiles files;
        FileSystem sfs;

        DataModel(WizardDescriptor wiz) {
            super(wiz);
        }

        public CreatedModifiedFiles getCreatedModifiedFiles() {
            return this.getFiles();
        }

        public void setCreatedModifiedFiles(CreatedModifiedFiles files) {
            this.setFiles(files);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public CreatedModifiedFiles getFiles() {
            return this.files;
        }

        public void setFiles(CreatedModifiedFiles files) {
            this.files = files;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public String getMode() {
            return this.mode;
        }

        public void defineMode(String name, String definition) {
            if (this.newModes == null) {
                this.newModes = new TreeMap<String, String>();
            }
            this.newModes.put(name, definition);
        }

        void existingMode(String name) {
            if (this.existingModes == null) {
                this.existingModes = new TreeSet<String>();
            }
            this.existingModes.add(name);
        }

        boolean isExistingMode(String name) {
            return this.existingModes != null && this.existingModes.contains(name);
        }

        Map<String, String> getNewModes() {
            if (this.newModes == null) {
                return null;
            }
            TreeMap<String, String> copy = new TreeMap<String, String>(this.newModes);
            if (this.existingModes != null) {
                copy.keySet().removeAll(this.existingModes);
            }
            return copy.isEmpty() ? null : copy;
        }

        public boolean isIgnorePreviousRun() {
            return this.ignorePreviousRun;
        }

        public void setIgnorePreviousRun(boolean ignorePreviousRun) {
            this.ignorePreviousRun = ignorePreviousRun;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public boolean isOpened() {
            return this.opened;
        }

        public void setOpened(boolean opened) {
            this.opened = opened;
        }

        public boolean isKeepPrefSize() {
            return this.keepPrefSize;
        }

        public void setKeepPrefSize(boolean keepPrefSize) {
            this.keepPrefSize = keepPrefSize;
        }

        public boolean isClosingNotAllowed() {
            return this.closingNotAllowed;
        }

        public void setClosingNotAllowed(boolean closingNotAllowed) {
            this.closingNotAllowed = closingNotAllowed;
        }

        public boolean isDraggingNotAllowed() {
            return this.draggingNotAllowed;
        }

        public void setDraggingNotAllowed(boolean draggingNotAllowed) {
            this.draggingNotAllowed = draggingNotAllowed;
        }

        public boolean isMaximizationNotAllowed() {
            return this.maximizationNotAllowed;
        }

        public void setMaximizationNotAllowed(boolean maximizationNotAllowed) {
            this.maximizationNotAllowed = maximizationNotAllowed;
        }

        public boolean isSlidingNotAllowed() {
            return this.slidingNotAllowed;
        }

        public void setSlidingNotAllowed(boolean slidingNotAllowed) {
            this.slidingNotAllowed = slidingNotAllowed;
        }

        public boolean isUndockingNotAllowed() {
            return this.undockingNotAllowed;
        }

        public void setUndockingNotAllowed(boolean undockingNotAllowed) {
            this.undockingNotAllowed = undockingNotAllowed;
        }

        void setSFS(FileSystem sfs) {
            this.sfs = sfs;
        }
    }
}

