/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.method.impl;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.modules.j2ee.common.method.impl.ParametersPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class ExceptionsPanel
extends JPanel {
    private final ExceptionsTableModel tableModel;
    private final ClasspathInfo cpInfo;
    private JButton addButton;
    private JButton downButton;
    private JButton editButton;
    private JScrollPane jScrollPane1;
    private JButton removeButton;
    private JTable table;
    private JButton upButton;

    public ExceptionsPanel(List<String> parameters, ClasspathInfo cpInfo) {
        this.initComponents();
        this.tableModel = new ExceptionsTableModel(parameters);
        this.cpInfo = cpInfo;
        this.table.setModel(this.tableModel);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ExceptionsPanel.this.updateButtons();
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ExceptionsPanel.this.updateButtons();
            }
        });
        this.updateButtons();
    }

    public List<String> getExceptions() {
        return this.tableModel.getExceptions();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.editButton = new JButton();
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.table);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ExceptionsPanel.class, (String)"ACSN_ExceptionsTab"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExceptionsPanel.class, (String)"ACSD_ExceptionsTab"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(ExceptionsPanel.class, (String)"ParametersPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExceptionsPanel.this.addButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ExceptionsPanel.class, (String)"ParametersPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExceptionsPanel.this.removeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(ExceptionsPanel.class, (String)"ParametersPanel.upButton.text"));
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExceptionsPanel.this.upButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(ExceptionsPanel.class, (String)"ParametersPanel.downButton.text"));
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExceptionsPanel.this.downButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)NbBundle.getMessage(ExceptionsPanel.class, (String)"ExceptionsPanel.editButton.text_1"));
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExceptionsPanel.this.editButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 241, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addButton).addComponent(this.removeButton).addComponent(this.editButton).addComponent(this.upButton).addComponent(this.downButton)).addContainerGap()));
        layout.linkSize(0, this.addButton, this.downButton, this.editButton, this.removeButton, this.upButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editButton).addGap(18, 18, 18).addComponent(this.upButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downButton)).addComponent(this.jScrollPane1, -1, 276, Short.MAX_VALUE)).addContainerGap()));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExceptionsPanel.class, (String)"ACSD_AddExceptionIntoTab"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExceptionsPanel.class, (String)"ACSD_RemoveExceptionFromTab"));
        this.upButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExceptionsPanel.class, (String)"ACSD_MoveUpInExcepTab"));
        this.downButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExceptionsPanel.class, (String)"ACSD_MoveDownInExceptionTab"));
        this.editButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ExceptionsPanel.class, (String)"ACSD_editExceptionButton"));
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        int selIndex = this.table.getSelectedRow();
        int newIndex = selIndex + 1;
        if (newIndex < this.tableModel.getExceptions().size()) {
            this.tableModel.set(newIndex, this.tableModel.set(selIndex, this.tableModel.getException(newIndex)));
            this.table.setRowSelectionInterval(newIndex, newIndex);
            this.updateButtons();
        }
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        int selIndex = this.table.getSelectedRow();
        int newIndex = selIndex - 1;
        if (newIndex >= 0) {
            this.tableModel.set(newIndex, this.tableModel.set(selIndex, this.tableModel.getException(newIndex)));
            this.table.setRowSelectionInterval(newIndex, newIndex);
            this.updateButtons();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow > -1) {
            this.tableModel.removeException(selectedRow);
        }
        if (selectedRow == this.table.getRowCount()) {
            --selectedRow;
        }
        this.table.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        this.updateButtons();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        ElementHandle<TypeElement> handle = this.browseExceptions();
        if (handle != null) {
            int index = this.tableModel.addException(handle.getQualifiedName());
            this.table.getSelectionModel().setSelectionInterval(index, index);
            this.table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
            this.updateButtons();
        }
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        ElementHandle<TypeElement> handle = this.browseExceptions();
        if (handle != null) {
            int index = this.table.getSelectedRow();
            this.table.getSelectionModel().setSelectionInterval(index, index);
            this.table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
            this.tableModel.setValueAt(handle.getQualifiedName(), index, 0);
        }
    }

    private ElementHandle<TypeElement> browseExceptions() {
        return TypeElementFinder.find((ClasspathInfo)this.cpInfo, (TypeElementFinder.Customizer)new TypeElementFinder.Customizer(){

            public Set<ElementHandle<TypeElement>> query(ClasspathInfo classpathInfo, String textForQuery, ClassIndex.NameKind nameKind, Set<ClassIndex.SearchScope> searchScopes) {
                return classpathInfo.getClassIndex().getDeclaredTypes(textForQuery, nameKind, searchScopes);
            }

            public boolean accept(ElementHandle<TypeElement> typeHandle) {
                return true;
            }
        });
    }

    private void updateButtons() {
        int selIndex = this.table.getSelectedRow();
        boolean oneSelected = this.table.getSelectedRowCount() == 1;
        this.removeButton.setEnabled(oneSelected);
        this.editButton.setEnabled(oneSelected);
        this.upButton.setEnabled(oneSelected && selIndex > 0);
        this.downButton.setEnabled(oneSelected && selIndex < this.tableModel.getRowCount() - 1);
    }

    private class ListSelectionListenerImpl
    implements ListSelectionListener {
        private ListSelectionListenerImpl() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ExceptionsPanel.this.table.editCellAt(ExceptionsPanel.this.table.getSelectedRow(), ExceptionsPanel.this.table.getSelectedColumn());
            Component editor = ExceptionsPanel.this.table.getEditorComponent();
            if (editor != null) {
                editor.requestFocus();
            }
            if (editor instanceof JTextComponent) {
                JTextComponent textComp = (JTextComponent)editor;
                textComp.selectAll();
            }
        }
    }

    static class ExceptionsTableModel
    extends AbstractTableModel {
        private final List<String> exceptions;

        public ExceptionsTableModel(List<String> parameters) {
            this.exceptions = new ArrayList<String>(parameters);
        }

        public List<String> getExceptions() {
            return this.exceptions;
        }

        public int addException(String exceptionName) {
            int index = this.exceptions.size();
            this.exceptions.add(exceptionName);
            this.fireTableRowsInserted(index, index);
            return index;
        }

        public void removeException(int index) {
            this.exceptions.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        public String getException(int index) {
            return this.exceptions.get(index);
        }

        public String set(int index, String exception) {
            return this.exceptions.set(index, exception);
        }

        @Override
        public int getRowCount() {
            return this.exceptions.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int row, int column) {
            String result = null;
            if (row >= 0) {
                result = this.exceptions.get(row);
            }
            return result;
        }

        @Override
        public String getColumnName(int column) {
            return NbBundle.getMessage(ParametersPanel.class, (String)"ExceptionsPanel.LBL_Exception");
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            this.exceptions.set(row, (String)aValue);
            this.fireTableCellUpdated(row, column);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

