/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.profiler.snaptracer.impl.IdeSnapshot;
import org.netbeans.modules.profiler.snaptracer.impl.TracerController;
import org.netbeans.modules.profiler.snaptracer.impl.TracerModel;
import org.netbeans.modules.profiler.snaptracer.impl.TracerSupportImpl;
import org.netbeans.modules.profiler.snaptracer.impl.TracerView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class IdeSnapshotAction
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        TracerSupportImpl.getInstance().perform(new Runnable(){

            @Override
            public void run() {
                IdeSnapshot snapshot = IdeSnapshotAction.this.snapshot();
                if (snapshot == null) {
                    return;
                }
                IdeSnapshotAction.openSnapshot(snapshot);
            }
        });
    }

    static void openSnapshot(final IdeSnapshot snapshot) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TracerModel model = new TracerModel(snapshot);
                TracerController controller = new TracerController(model);
                TopComponent ui = IdeSnapshotAction.ui(model, controller, snapshot.getNpssFileName());
                ui.open();
                ui.requestActive();
            }
        });
    }

    private static TopComponent ui(TracerModel model, TracerController controller, String npssFileName) {
        IdeSnapshotComponent tc = new IdeSnapshotComponent(npssFileName);
        TracerView tracer = new TracerView(model, controller);
        tc.add(tracer.createComponent(), "Center");
        return tc;
    }

    private IdeSnapshot snapshot() {
        File file = this.snapshotFile();
        if (file == null) {
            return null;
        }
        try {
            FileObject primary = FileUtil.toFileObject((File)file);
            FileObject uigestureFO = primary.getParent().getFileObject(primary.getName(), "log");
            return new IdeSnapshot(primary, uigestureFO);
        }
        catch (Throwable t) {
            Exceptions.printStackTrace((Throwable)t);
            return null;
        }
    }

    private File snapshotFile() {
        JFileChooser chooser = IdeSnapshotAction.createFileChooser();
        final Frame[] window = new Frame[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    window[0] = WindowManager.getDefault().getMainWindow();
                }
            });
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (chooser.showOpenDialog(window[0]) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    private static JFileChooser createFileChooser() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(IdeSnapshotAction.class, (String)"ACTION_IdeSnapshot_dialog"));
        chooser.setDialogType(0);
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(Filter.create(NbBundle.getMessage(IdeSnapshotAction.class, (String)"ACTION_IdeSnapshot_filter"), ".npss"));
        return chooser;
    }

    private static abstract class Filter
    extends FileFilter {
        abstract String getExt();

        static Filter create(final String descr, final String ext) {
            return new Filter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || Filter.getFileExt(f.getName()).equals(ext);
                }

                @Override
                public String getExt() {
                    return ext;
                }

                @Override
                public String getDescription() {
                    return descr + " (*" + ext + ")";
                }
            };
        }

        private static String getFileExt(String fileName) {
            int extIndex = fileName.lastIndexOf(".");
            if (extIndex == -1) {
                return "";
            }
            return fileName.substring(extIndex);
        }

        private Filter() {
        }
    }

    private static class IdeSnapshotComponent
    extends TopComponent {
        IdeSnapshotComponent(String npssFileName) {
            this.setDisplayName(npssFileName);
            this.setLayout(new BorderLayout());
        }

        public int getPersistenceType() {
            return 2;
        }
    }
}

