/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.profiler.snaptracer.Positionable;
import org.netbeans.modules.profiler.snaptracer.TracerPackage;
import org.netbeans.modules.profiler.snaptracer.TracerProbeDescriptor;
import org.netbeans.modules.profiler.snaptracer.impl.TracerController;
import org.netbeans.modules.profiler.snaptracer.impl.TracerModel;
import org.netbeans.modules.profiler.snaptracer.impl.TracerSupportImpl;
import org.netbeans.modules.profiler.snaptracer.impl.options.TracerOptions;
import org.netbeans.modules.profiler.snaptracer.impl.probes.ProbeDescriptorComponent;
import org.netbeans.modules.profiler.snaptracer.impl.swing.CategoryList;

final class PackagesView {
    private final TracerModel model;
    private final TracerController controller;

    PackagesView(TracerModel model, TracerController controller) {
        this.model = model;
        this.controller = controller;
    }

    private void loadPackages(final JComponent view) {
        TracerSupportImpl.getInstance().perform(new Runnable(){

            @Override
            public void run() {
                final List<TracerPackage> packages = PackagesView.this.model.getPackages();
                if (packages != null) {
                    final ArrayList<List<TracerProbeDescriptor>> descriptors = new ArrayList<List<TracerProbeDescriptor>>();
                    for (TracerPackage p : packages) {
                        TracerProbeDescriptor[] da = p.getProbeDescriptors();
                        Arrays.sort(da, Positionable.COMPARATOR);
                        List<TracerProbeDescriptor> dl = Arrays.asList(da);
                        descriptors.add(dl);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PackagesView.this.displayPackages(packages, descriptors, view);
                        }
                    });
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PackagesView.this.displayError(view);
                        }
                    });
                }
            }
        });
    }

    JComponent getView() {
        JComponent view = this.createComponents();
        this.initListeners(view);
        this.refreshState(view);
        return view;
    }

    private void refreshState(JComponent view) {
        switch (this.controller.getState()) {
            case 0: {
                view.setEnabled(true);
                break;
            }
            case -2147483648: 
            case -1: 
            case 1: 
            case 0x7FFFFFFF: {
                view.setEnabled(false);
            }
        }
    }

    private void initListeners(final JComponent view) {
        view.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && view.isShowing()) {
                    view.removeHierarchyListener(this);
                    PackagesView.this.loadPackages(view);
                }
            }
        });
        this.controller.addListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PackagesView.this.refreshState(view);
            }
        });
    }

    private void displayPackages(List<TracerPackage> packages, List<List<TracerProbeDescriptor>> descriptors, JComponent view) {
        int packagesCount = descriptors.size();
        String[] categories = new String[packagesCount];
        String[] tooltips = new String[packagesCount];
        boolean[] initialStates = new boolean[packagesCount];
        Component[][] items = new Component[packagesCount][];
        ProbeDescriptorComponent.SelectionHandler selectionHandler = new ProbeDescriptorComponent.SelectionHandler(){

            @Override
            public void descriptorSelected(TracerPackage p, TracerProbeDescriptor d) {
                PackagesView.this.model.addDescriptor(p, d);
            }

            @Override
            public void descriptorUnselected(TracerPackage p, TracerProbeDescriptor d) {
                PackagesView.this.model.removeDescriptor(p, d);
            }
        };
        int probesApp = TracerOptions.getInstance().getProbesApp();
        Boolean expanded = null;
        if (probesApp == 1) {
            expanded = true;
        } else if (probesApp == 2) {
            expanded = false;
        }
        for (int i = 0; i < packagesCount; ++i) {
            TracerPackage p = packages.get(i);
            categories[i] = new String(p.getName());
            tooltips[i] = new String(p.getDescription());
            boolean bl = initialStates[i] = expanded == null || expanded != false;
            if (expanded == null) {
                expanded = false;
            }
            List<TracerProbeDescriptor> d = descriptors.get(i);
            int descriptorsCount = d.size();
            items[i] = new Component[descriptorsCount];
            for (int j = 0; j < descriptorsCount; ++j) {
                items[i][j] = new ProbeDescriptorComponent(d.get(j), p, selectionHandler);
            }
        }
        view.removeAll();
        view.add(new CategoryList(categories, tooltips, initialStates, items));
        view.revalidate();
        view.repaint();
    }

    private void displayError(JComponent view) {
        view.removeAll();
        view.add((Component)new JLabel("Failed to load probes, check the logfile", 0), "Center");
        view.revalidate();
        view.repaint();
    }

    private JComponent createComponents() {
        JPanel panel = new JPanel(new BorderLayout()){

            @Override
            public void setEnabled(boolean enabled) {
                Component[] components;
                for (Component c : components = this.getComponents()) {
                    c.setEnabled(enabled);
                }
            }
        };
        panel.setOpaque(false);
        JLabel waitLabel = new JLabel("Loading probes...", 0);
        waitLabel.setEnabled(false);
        panel.add((Component)waitLabel, "Center");
        return panel;
    }
}

