/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarFactory;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarImplementation2;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarProvider;
import org.netbeans.modules.j2ee.spi.ejbjar.EjbJarsInProject;
import org.netbeans.modules.j2ee.spi.ejbjar.support.EjbJarSupport;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.j2ee.ContainerCPModifierImpl;
import org.netbeans.modules.maven.j2ee.CopyOnSave;
import org.netbeans.modules.maven.j2ee.EMGSResolverImpl;
import org.netbeans.modules.maven.j2ee.ExecutionChecker;
import org.netbeans.modules.maven.j2ee.J2EEPrerequisitesChecker;
import org.netbeans.modules.maven.j2ee.J2eeMavenSourcesImpl;
import org.netbeans.modules.maven.j2ee.J2eeRecoPrivTemplates;
import org.netbeans.modules.maven.j2ee.JPAStuffImpl;
import org.netbeans.modules.maven.j2ee.MavenPersistenceProviderSupplier;
import org.netbeans.modules.maven.j2ee.POHImpl;
import org.netbeans.modules.maven.j2ee.SessionContent;
import org.netbeans.modules.maven.j2ee.appclient.AppClientModuleProviderImpl;
import org.netbeans.modules.maven.j2ee.ear.EarModuleProviderImpl;
import org.netbeans.modules.maven.j2ee.ejb.EjbEntRefContainerImpl;
import org.netbeans.modules.maven.j2ee.ejb.EjbModuleProviderImpl;
import org.netbeans.modules.maven.j2ee.web.EntRefContainerImpl;
import org.netbeans.modules.maven.j2ee.web.MavenWebProjectWebRootProvider;
import org.netbeans.modules.maven.j2ee.web.WebEjbJarImpl;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.maven.j2ee.web.WebReplaceTokenProvider;
import org.netbeans.modules.web.jsfapi.spi.JsfSupportHandle;
import org.netbeans.spi.project.LookupProvider;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class J2eeLookupProvider
implements LookupProvider {
    public Lookup createAdditionalLookup(Lookup baseLookup) {
        Project project = (Project)baseLookup.lookup(Project.class);
        assert (project != null);
        InstanceContent ic = new InstanceContent();
        ic.add((Object)new J2EEPrerequisitesChecker());
        ic.add((Object)new J2eeRecoPrivTemplates(project));
        ic.add((Object)new J2eeMavenSourcesImpl(project));
        ic.add((Object)new ExecutionChecker(project));
        ic.add((Object)new SessionContent());
        Provider prov = new Provider(project, ic);
        POHImpl p = new POHImpl(project, prov);
        ic.add((Object)p);
        ic.add((Object)new POHImpl.Hook(p));
        ic.add((Object)new ContainerCPModifierImpl(project));
        return prov;
    }

    public static class Provider
    extends AbstractLookup
    implements PropertyChangeListener {
        private final Project project;
        private final InstanceContent content;
        private String lastType = "jar";
        private Object lastInstance = null;
        private CopyOnSave copyOnSave;
        private final WebReplaceTokenProvider replacer;
        private final EntRefContainerImpl webEnt;
        private final EjbEntRefContainerImpl ejbEnt;
        private final JPAStuffImpl jpa;
        private final EMGSResolverImpl resolver;
        private final MavenPersistenceProviderSupplier supplier;
        private EjbJarProvider webEjbJarProvider;
        private EjbJarsInProject ejbJarsInProject;
        private MavenWebProjectWebRootProvider webRootProvider;
        private JsfSupportHandle jsfSupportHandle;

        public Provider(Project proj, InstanceContent cont) {
            super((AbstractLookup.Content)cont);
            this.project = proj;
            this.content = cont;
            this.replacer = new WebReplaceTokenProvider(proj);
            this.webEnt = new EntRefContainerImpl(proj);
            this.ejbEnt = new EjbEntRefContainerImpl(proj);
            this.jpa = new JPAStuffImpl(proj);
            this.resolver = new EMGSResolverImpl();
            this.supplier = new MavenPersistenceProviderSupplier(proj);
            this.webRootProvider = new MavenWebProjectWebRootProvider(this.project);
            this.jsfSupportHandle = new JsfSupportHandle();
            this.checkJ2ee();
            NbMavenProject.addPropertyChangeListener((Project)this.project, (PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                this.checkJ2ee();
            }
        }

        private void checkJ2ee() {
            NbMavenProject watcher = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            String packaging = watcher.getPackagingType();
            this.doCheckJ2ee(packaging);
        }

        public void hackModuleServerChange() {
            this.doCheckJ2ee(null);
            this.checkJ2ee();
        }

        private boolean isWebSupported(String packaging) {
            NbMavenProject proj;
            if ("war".equals(packaging)) {
                return true;
            }
            return "bundle".equals(packaging) && new File((proj = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getWebAppDirectory()).exists();
        }

        private void doCheckJ2ee(String packaging) {
            if (packaging == null) {
                packaging = "jar";
            }
            if (this.copyOnSave != null && !this.isWebSupported(packaging)) {
                try {
                    this.copyOnSave.cleanup();
                }
                catch (FileStateInvalidException ex) {
                    ex.printStackTrace();
                }
                this.content.remove((Object)this.copyOnSave);
                this.copyOnSave = null;
            }
            if (this.isWebSupported(packaging) && !this.lastType.equals(packaging)) {
                this.removeInstances();
                WebModuleProviderImpl prov = new WebModuleProviderImpl(this.project);
                this.lastInstance = prov;
                this.content.add(this.lastInstance);
                this.content.add((Object)this.replacer);
                this.content.add((Object)this.webEnt);
                this.content.add((Object)this.jpa);
                this.content.add((Object)this.resolver);
                this.content.add((Object)this.supplier);
                this.content.add((Object)this.webRootProvider);
                this.content.add((Object)this.jsfSupportHandle);
                Profile prf = prov.getWebModuleImplementation().getJ2eeProfile();
                if (Profile.JAVA_EE_6_WEB.equals(prf) || Profile.JAVA_EE_6_FULL.equals(prf)) {
                    WebEjbJarImpl webEjbJarImpl = new WebEjbJarImpl(prov.getWebModuleImplementation(), this.project);
                    EjbJar apiEjbJar = EjbJarFactory.createEjbJar((EjbJarImplementation2)webEjbJarImpl);
                    this.webEjbJarProvider = EjbJarSupport.createEjbJarProvider((Project)this.project, (EjbJar)apiEjbJar);
                    this.ejbJarsInProject = EjbJarSupport.createEjbJarsInProject((EjbJar)apiEjbJar);
                    this.content.add((Object)this.webEjbJarProvider);
                    this.content.add((Object)this.ejbJarsInProject);
                }
                this.copyOnSave = prov.getCopyOnSaveSupport();
                try {
                    this.copyOnSave.initialize();
                }
                catch (FileStateInvalidException ex) {
                    ex.printStackTrace();
                }
                this.content.add((Object)this.copyOnSave);
            } else if ("ear".equals(packaging) && !this.lastType.equals(packaging)) {
                this.removeInstances();
                this.lastInstance = new EarModuleProviderImpl(this.project);
                this.content.add(this.lastInstance);
                this.content.add((Object)((EarModuleProviderImpl)((Object)this.lastInstance)).getEarImplementation());
            } else if ("ejb".equals(packaging) && !this.lastType.equals(packaging)) {
                this.removeInstances();
                EjbModuleProviderImpl prov = new EjbModuleProviderImpl(this.project);
                this.lastInstance = prov;
                this.content.add(this.lastInstance);
                this.content.add((Object)this.jpa);
                this.content.add((Object)this.ejbEnt);
                this.content.add((Object)this.resolver);
                this.content.add((Object)this.supplier);
                this.copyOnSave = prov.getCopyOnSaveSupport();
                try {
                    this.copyOnSave.initialize();
                }
                catch (FileStateInvalidException ex) {
                    ex.printStackTrace();
                }
                this.content.add((Object)this.copyOnSave);
            } else if ("app-client".equals(packaging) && !this.lastType.equals(packaging)) {
                this.removeInstances();
                AppClientModuleProviderImpl prov = new AppClientModuleProviderImpl(this.project);
                this.lastInstance = prov;
                this.content.add(this.lastInstance);
                this.content.add((Object)this.jpa);
                this.content.add((Object)this.supplier);
                this.copyOnSave = prov.getCopyOnSaveSupport();
                try {
                    this.copyOnSave.initialize();
                }
                catch (FileStateInvalidException ex) {
                    ex.printStackTrace();
                }
                this.content.add((Object)this.copyOnSave);
            } else if (!(this.lastInstance == null || this.isWebSupported(packaging) || "ejb".equals(packaging) || "app-client".equals(packaging) || "ear".equals(packaging))) {
                this.removeInstances();
                this.lastInstance = null;
            }
            this.lastType = packaging;
        }

        private void removeInstances() {
            if (this.lastInstance != null) {
                if (this.lastInstance instanceof EarModuleProviderImpl) {
                    this.content.remove((Object)((EarModuleProviderImpl)((Object)this.lastInstance)).getEarImplementation());
                }
                this.content.remove(this.lastInstance);
            }
            this.content.remove((Object)this.replacer);
            this.content.remove((Object)this.webEnt);
            this.content.remove((Object)this.ejbEnt);
            this.content.remove((Object)this.jpa);
            this.content.remove((Object)this.resolver);
            this.content.remove((Object)this.supplier);
            this.content.remove((Object)this.webRootProvider);
            this.content.remove((Object)this.jsfSupportHandle);
            if (this.webEjbJarProvider != null) {
                this.content.remove((Object)this.webEjbJarProvider);
                this.webEjbJarProvider = null;
            }
            if (this.ejbJarsInProject != null) {
                this.content.remove((Object)this.ejbJarsInProject);
                this.ejbJarsInProject = null;
            }
        }
    }
}

