/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2ee.api.ejbjar.Ear;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.ui.BrokenServerLibrarySupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerManager;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.api.problem.ProblemReporter;
import org.netbeans.modules.maven.j2ee.CopyOnSave;
import org.netbeans.modules.maven.j2ee.ExecutionChecker;
import org.netbeans.modules.maven.j2ee.J2eeLookupProvider;
import org.netbeans.modules.maven.j2ee.SessionContent;
import org.netbeans.modules.maven.j2ee.Wrapper;
import org.netbeans.modules.maven.j2ee.ear.EarModuleProviderImpl;
import org.netbeans.modules.maven.j2ee.ejb.EjbModuleProviderImpl;
import org.netbeans.modules.maven.j2ee.utils.LoggingUtils;
import org.netbeans.modules.maven.j2ee.utils.MavenProjectSupport;
import org.netbeans.modules.maven.j2ee.web.WebModuleImpl;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Properties;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class POHImpl {
    private final Project project;
    private J2eeLookupProvider.Provider provider;
    private PropertyChangeListener refreshListener;
    private J2eeModuleProvider lastJ2eeProvider;
    private static boolean newlyCreated;

    public POHImpl(Project prj, J2eeLookupProvider.Provider prov) {
        this.project = prj;
        this.provider = prov;
        newlyCreated = false;
    }

    public static void setNewlyCreated(boolean newValue) {
        newlyCreated = newValue;
    }

    public void hackModuleServerChange(boolean useMutex) {
        if (!useMutex) {
            this.refreshAppServerAssignment();
        } else {
            ProjectManager.mutex().postReadRequest(new Runnable(){

                @Override
                public void run() {
                    POHImpl.this.refreshAppServerAssignment();
                }
            });
        }
    }

    private void projectOpened() {
        String serverName;
        this.refreshAppServerAssignment();
        if (this.refreshListener == null) {
            NbMavenProject watcher = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            this.refreshListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("MavenProject".equals(evt.getPropertyName())) {
                        POHImpl.this.hackModuleServerChange(true);
                    }
                }
            };
            watcher.addPropertyChangeListener(this.refreshListener);
        }
        if ((serverName = POHImpl.obtainServerName(this.project)) == null) {
            serverName = NbBundle.getMessage(POHImpl.class, (String)"MSG_No_Server");
        }
        String eeVersion = null;
        NbMavenProject mavProj = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        if (mavProj != null) {
            EjbJar ejbProj;
            String pkgType = mavProj.getPackagingType();
            if ("ear".equals(pkgType)) {
                Ear earProj = Ear.getEar((FileObject)this.project.getProjectDirectory());
                if (earProj != null) {
                    eeVersion = earProj.getJ2eePlatformVersion();
                }
            } else if ("war".equals(pkgType)) {
                WebModule webM = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
                if (webM != null) {
                    eeVersion = webM.getJ2eePlatformVersion();
                }
            } else if ("ejb".equals(pkgType) && (ejbProj = EjbJar.getEjbJar((FileObject)this.project.getProjectDirectory())) != null) {
                eeVersion = ejbProj.getJ2eePlatformVersion();
            }
        }
        if (eeVersion == null) {
            eeVersion = NbBundle.getMessage(POHImpl.class, (String)"TXT_UnknownEEVersion");
        }
        LoggingUtils.logUsage(ExecutionChecker.class, "USG_PROJECT_OPEN_MAVEN_EE", new Object[]{serverName, eeVersion}, "maven");
    }

    private synchronized void refreshAppServerAssignment() {
        J2eeModuleProvider prv;
        this.provider.hackModuleServerChange();
        String[] ids = POHImpl.obtainServerIds(this.project);
        String instanceFound = ids[0];
        String server = ids[1];
        ProblemReporter report = (ProblemReporter)this.project.getLookup().lookup(ProblemReporter.class);
        if (instanceFound != null) {
            EarModuleProviderImpl ear;
            EjbModuleProviderImpl ejb;
            WebModuleProviderImpl impl = (WebModuleProviderImpl)((Object)this.project.getLookup().lookup(WebModuleProviderImpl.class));
            if (impl != null) {
                impl.setServerInstanceID(instanceFound);
                impl.getConfigSupport().ensureConfigurationReady();
                MavenProjectSupport.createDDIfRequired(this.project, instanceFound);
            }
            if ((ejb = (EjbModuleProviderImpl)((Object)this.project.getLookup().lookup(EjbModuleProviderImpl.class))) != null) {
                ejb.setServerInstanceID(instanceFound);
                ejb.getConfigSupport().ensureConfigurationReady();
            }
            if ((ear = (EarModuleProviderImpl)((Object)this.project.getLookup().lookup(EarModuleProviderImpl.class))) != null) {
                ear.setServerInstanceID(instanceFound);
                ear.getConfigSupport().ensureConfigurationReady();
            }
        } else if (server != null) {
            String tit = Deployment.getDefault().getServerDisplayName(server);
            if (tit == null) {
                tit = server;
            }
            ProblemReport rep = new ProblemReport(0, NbBundle.getMessage(POHImpl.class, (String)"MSG_AppServer", (Object)tit), NbBundle.getMessage(POHImpl.class, (String)"HINT_AppServer"), (Action)new AddServerAction(this.project));
            report.addReport(rep);
        }
        if (this.lastJ2eeProvider != null) {
            Deployment.getDefault().disableCompileOnSaveSupport(this.lastJ2eeProvider);
            this.lastJ2eeProvider = null;
        }
        if ((prv = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class)) != null) {
            if (!BrokenServerLibrarySupport.getMissingServerLibraries((Project)this.project).isEmpty()) {
                ProblemReport libProblem = new ProblemReport(0, NbBundle.getMessage(POHImpl.class, (String)"MSG_LibProblem"), NbBundle.getMessage(POHImpl.class, (String)"MSG_LibProblem_Description"), (Action)new ServerLibraryAction(this.project));
                report.addReport(libProblem);
                BrokenServerLibrarySupport.fixOrShowAlert((Project)this.project, null);
            }
            if (RunUtils.hasApplicationCompileOnSaveEnabled((Project)this.project)) {
                Deployment.getDefault().enableCompileOnSaveSupport(prv);
                this.lastJ2eeProvider = prv;
            }
        }
    }

    private void projectClosed() {
        CopyOnSave copyOnSave;
        if (this.refreshListener != null) {
            NbMavenProject watcher = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            watcher.removePropertyChangeListener(this.refreshListener);
            this.refreshListener = null;
        }
        if (this.lastJ2eeProvider != null) {
            Deployment.getDefault().disableCompileOnSaveSupport(this.lastJ2eeProvider);
            this.lastJ2eeProvider = null;
        }
        if ((copyOnSave = (CopyOnSave)this.project.getLookup().lookup(CopyOnSave.class)) != null) {
            try {
                copyOnSave.cleanup();
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void projectCreated() {
        NbMavenProject mavenProject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        WebModuleProviderImpl webModuleProvider = (WebModuleProviderImpl)((Object)this.project.getLookup().lookup(WebModuleProviderImpl.class));
        if (!"war".equals(mavenProject.getPackagingType()) || webModuleProvider == null) {
            return;
        }
        WebModuleImpl webModuleImpl = webModuleProvider.getWebModuleImplementation();
        String contextPath = webModuleImpl.getContextPath();
        if (contextPath == null || "".equals(contextPath)) {
            webModuleImpl.setContextPath("/" + mavenProject.getMavenProject().getArtifactId());
        }
    }

    private static String[] obtainServerIds(Project project) {
        SessionContent sc = (SessionContent)project.getLookup().lookup(SessionContent.class);
        if (sc.getServerInstanceId() != null) {
            return new String[]{sc.getServerInstanceId(), null};
        }
        AuxiliaryProperties props = (AuxiliaryProperties)project.getLookup().lookup(AuxiliaryProperties.class);
        String val = props.get("netbeans.deployment.server.id", false);
        if (val != null) {
            return new String[]{val, null};
        }
        String server = props.get("netbeans.hint.deploy.server", true);
        if (server == null) {
            server = props.get("netbeans.deployment.server.type", true);
        }
        return new String[]{null, server};
    }

    public static String obtainServerName(Project project) {
        ServerInstance si;
        String id = POHImpl.obtainServerIds(project)[0];
        if (id != null && (si = Deployment.getDefault().getServerInstance(id)) != null) {
            try {
                return si.getDisplayName();
            }
            catch (InstanceRemovedException ex) {
                Logger.getLogger(Wrapper.class.getName()).log(Level.FINE, "", ex);
            }
        }
        return null;
    }

    public static String privateGetServerId(String serverInstanceID) {
        ServerInstance si = Deployment.getDefault().getServerInstance(serverInstanceID);
        try {
            return si.getServerID();
        }
        catch (InstanceRemovedException ex) {
            return null;
        }
    }

    public static class Hook
    extends ProjectOpenedHook {
        private POHImpl poh;

        public Hook(POHImpl poh) {
            this.poh = poh;
        }

        protected void projectOpened() {
            this.poh.projectOpened();
            if (newlyCreated) {
                this.poh.projectCreated();
                newlyCreated = false;
            }
        }

        protected void projectClosed() {
            this.poh.projectClosed();
        }
    }

    private class ServerLibraryAction
    extends AbstractAction {
        private Project project;

        public ServerLibraryAction(Project project) {
            this.putValue("Name", NbBundle.getMessage(POHImpl.class, (String)"LBL_LibProblem_ActionName"));
            this.project = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BrokenServerLibrarySupport.fixServerLibraries((Project)this.project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    NbMavenProject.fireMavenProjectReload((Project)ServerLibraryAction.this.project);
                }
            });
        }
    }

    private static class AddServerAction
    extends AbstractAction {
        private Project prj;

        private AddServerAction(Project project) {
            this.prj = project;
            this.putValue("Name", NbBundle.getMessage(POHImpl.class, (String)"TXT_Add_Server"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final String newOne = ServerManager.showAddServerInstanceWizard();
            final String serverType = newOne != null ? POHImpl.privateGetServerId(newOne) : null;
            Utilities.performPOMModelOperations((FileObject)this.prj.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(new ModelOperation<POMModel>(){

                public void performOperation(POMModel model) {
                    if (newOne != null) {
                        Properties props = model.getProject().getProperties();
                        if (props == null) {
                            props = model.getFactory().createProperties();
                            model.getProject().setProperties(props);
                        }
                        props.setProperty("netbeans.hint.deploy.server", serverType);
                    } else {
                        Properties props = model.getProject().getProperties();
                        if (props != null) {
                            props.setProperty("netbeans.hint.deploy.server", null);
                        }
                    }
                }
            }));
            ((AuxiliaryProperties)this.prj.getLookup().lookup(AuxiliaryProperties.class)).put("netbeans.deployment.server.id", newOne, false);
        }
    }
}

