/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.newproject.archetype;

import java.util.Map;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.maven.api.archetype.Archetype;
import org.netbeans.modules.maven.j2ee.newproject.archetype.BaseJ2eeArchetypeProvider;

public class J2eeArchetypeFactory {
    private static J2eeArchetypeFactory instance;
    private final WebArchetypes webArchetypes = new WebArchetypes();
    private final EjbArchetypes ejbArchetypes = new EjbArchetypes();
    private final AppClientArchetypes appClientArchetypes = new AppClientArchetypes();
    private final EarArchetypes earArchetypes = new EarArchetypes();
    private final EaArchetypes eaArchetypes = new EaArchetypes();

    private J2eeArchetypeFactory() {
    }

    public static J2eeArchetypeFactory getInstance() {
        if (instance == null) {
            instance = new J2eeArchetypeFactory();
        }
        return instance;
    }

    private BaseJ2eeArchetypeProvider getProvider(J2eeModule.Type projectType) {
        if (J2eeModule.Type.WAR.equals(projectType)) {
            return this.webArchetypes;
        }
        if (J2eeModule.Type.EJB.equals(projectType)) {
            return this.ejbArchetypes;
        }
        if (J2eeModule.Type.CAR.equals(projectType)) {
            return this.appClientArchetypes;
        }
        if (J2eeModule.Type.EAR.equals(projectType)) {
            return this.earArchetypes;
        }
        if (J2eeModule.Type.RAR.equals(projectType)) {
            return this.eaArchetypes;
        }
        throw new IllegalArgumentException("J2ee project type isn't correct !");
    }

    public Archetype findArchetypeFor(J2eeModule.Type projectType, Profile profile) {
        return this.getProvider(projectType).getArchetypeFor(profile);
    }

    public Archetype getAnyArchetypeFor(J2eeModule.Type projectType) {
        return this.getProvider(projectType).getAnyArchetype();
    }

    public Map<Profile, Archetype> getArchetypeMap(J2eeModule.Type projectType) {
        return this.getProvider(projectType).getArchetypeMap();
    }

    private class WebArchetypes
    extends BaseJ2eeArchetypeProvider {
        private WebArchetypes() {
        }

        @Override
        protected void setUpProjectArchetypes() {
            this.addMojoArchetype(Profile.JAVA_EE_6_WEB, "1.5", "webapp-javaee6");
            this.addMojoArchetype(Profile.JAVA_EE_5, "1.3", "webapp-jee5");
            this.addMojoArchetype(Profile.J2EE_14, "1.3", "webapp-j2ee14");
            this.addMojoArchetype(Profile.JAVA_EE_6_FULL, "1.5", "webapp-javaee6");
        }
    }

    private class EjbArchetypes
    extends BaseJ2eeArchetypeProvider {
        private EjbArchetypes() {
        }

        @Override
        protected void setUpProjectArchetypes() {
            this.addMojoArchetype(Profile.JAVA_EE_6_FULL, "1.5", "ejb-javaee6");
            this.addMojoArchetype(Profile.JAVA_EE_5, "1.3", "ejb-jee5");
            this.addMojoArchetype(Profile.J2EE_14, "1.3", "ejb-j2ee14");
        }
    }

    private class EarArchetypes
    extends BaseJ2eeArchetypeProvider {
        private EarArchetypes() {
        }

        @Override
        protected void setUpProjectArchetypes() {
            this.addMojoArchetype(Profile.JAVA_EE_6_FULL, "1.5", "ear-javaee6");
            this.addMojoArchetype(Profile.JAVA_EE_5, "1.4", "ear-jee5");
            this.addMojoArchetype(Profile.J2EE_14, "1.4", "ear-j2ee14");
        }
    }

    private class EaArchetypes
    extends BaseJ2eeArchetypeProvider {
        private EaArchetypes() {
        }

        @Override
        protected void setUpProjectArchetypes() {
            this.addMojoArchetype(Profile.JAVA_EE_6_FULL, "1.1", "pom-root");
        }
    }

    private class AppClientArchetypes
    extends BaseJ2eeArchetypeProvider {
        private AppClientArchetypes() {
        }

        @Override
        protected void setUpProjectArchetypes() {
            this.addMojoArchetype(Profile.JAVA_EE_6_FULL, "1.0", "appclient-javaee6");
            this.addMojoArchetype(Profile.JAVA_EE_5, "1.0", "appclient-jee5");
            this.addMojoArchetype(Profile.J2EE_14, "1.0", "appclient-jee5");
        }
    }
}

