/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.utils;

import java.io.IOException;
import java.util.Collections;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.maven.j2ee.web.WebModuleImpl;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Properties;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

public class MavenProjectSupport {
    private MavenProjectSupport() {
    }

    public static void storeSettingsToPom(Project project, String name, String value) {
        MavenProjectSupport.storeSettingsToPom(project.getProjectDirectory(), name, value);
    }

    public static void storeSettingsToPom(FileObject projectFile, final String name, final String value) {
        ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                Properties props = model.getProject().getProperties();
                if (props == null) {
                    props = model.getFactory().createProperties();
                    model.getProject().setProperties(props);
                }
                props.setProperty(name, value);
            }
        };
        final FileObject pom = projectFile.getFileObject("pom.xml");
        try {
            pom.getFileSystem().runAtomicAction(new FileSystem.AtomicAction((ModelOperation)operation){
                final /* synthetic */ ModelOperation val$operation;
                {
                    this.val$operation = modelOperation;
                }

                public void run() throws IOException {
                    Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(this.val$operation));
                }
            });
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void createDDIfRequired(Project project) {
        MavenProjectSupport.createDDIfRequired(project, null);
    }

    public static void createDDIfRequired(Project project, String serverID) {
        if (serverID == null) {
            serverID = MavenProjectSupport.readServerID(project);
        }
        if (serverID != null && serverID.contains("WebLogic")) {
            MavenProjectSupport.createDD(project);
        }
    }

    private static String readServerID(Project project) {
        AuxiliaryProperties props = (AuxiliaryProperties)project.getLookup().lookup(AuxiliaryProperties.class);
        return props.get("netbeans.hint.deploy.server", false);
    }

    private static void createDD(Project project) {
        WebModuleProviderImpl webModule = (WebModuleProviderImpl)((Object)project.getLookup().lookup(WebModuleProviderImpl.class));
        if (webModule != null) {
            WebModuleImpl webModuleImpl = webModule.getWebModuleImplementation();
            try {
                FileObject webXml;
                FileObject webInf = webModuleImpl.getWebInf();
                if (webInf == null) {
                    webInf = webModuleImpl.createWebInf();
                }
                if ((webXml = webModuleImpl.getDeploymentDescriptor()) == null) {
                    AuxiliaryProperties props = (AuxiliaryProperties)project.getLookup().lookup(AuxiliaryProperties.class);
                    String j2eeVersion = props.get("netbeans.hint.j2eeVersion", false);
                    webXml = DDHelper.createWebXml((Profile)Profile.fromPropertiesString((String)j2eeVersion), (FileObject)webInf);
                }
                assert (webXml != null);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

