/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.web;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.dd.spi.MetadataUnit;
import org.netbeans.modules.j2ee.dd.spi.web.WebAppMetadataModelFactory;
import org.netbeans.modules.j2ee.dd.spi.webservices.WebservicesMetadataModelFactory;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleImplementation2;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.web.spi.webmodule.WebModuleImplementation2;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class WebModuleImpl
implements WebModuleImplementation2,
J2eeModuleImplementation2 {
    private Project project;
    private WebModuleProviderImpl provider;
    private MetadataModel<WebAppMetadata> webAppMetadataModel;
    private MetadataModel<WebAppMetadata> webAppAnnMetadataModel;
    private MetadataModel<WebservicesMetadata> webservicesMetadataModel;
    private boolean inplace = false;
    private NbMavenProject mavenproject;
    public static final String WEB_INF = "WEB-INF";

    public WebModuleImpl(Project proj, WebModuleProviderImpl prov) {
        this.project = proj;
        this.mavenproject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        this.provider = prov;
    }

    public FileObject getWebInf() {
        FileObject root = this.getDocumentBase();
        if (root != null) {
            return root.getFileObject(WEB_INF);
        }
        return null;
    }

    public FileObject createWebInf() throws IOException {
        FileObject root = this.getDocumentBase();
        if (root != null) {
            return root.createFolder(WEB_INF);
        }
        return null;
    }

    public void setWarInplace(boolean inplace) {
        this.inplace = inplace;
    }

    public Profile getJ2eeProfile() {
        Profile propProfile = this.getPropertyJ2eeProfile();
        Profile descriptorProfile = this.getDescriptorJ2eeProfile();
        if (descriptorProfile != null) {
            if (descriptorProfile.equals(Profile.JAVA_EE_6_WEB) && propProfile != null && propProfile.equals(Profile.JAVA_EE_6_FULL)) {
                return propProfile;
            }
            return descriptorProfile;
        }
        if (propProfile != null) {
            return propProfile;
        }
        return Profile.JAVA_EE_5;
    }

    public Profile getPropertyJ2eeProfile() {
        String version;
        AuxiliaryProperties prop = (AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class);
        if (prop != null && (version = prop.get("netbeans.hint.j2eeVersion", true)) != null) {
            return Profile.fromPropertiesString((String)version);
        }
        return null;
    }

    public Profile getDescriptorJ2eeProfile() {
        DDProvider prov = DDProvider.getDefault();
        FileObject dd = this.getDeploymentDescriptor();
        if (dd != null) {
            try {
                WebApp wa = prov.getDDRoot(dd);
                String waVersion = wa.getVersion();
                if ("2.4".equals(waVersion)) {
                    return Profile.J2EE_14;
                }
                if ("2.5".equals(waVersion)) {
                    return Profile.JAVA_EE_5;
                }
                if ("3.0".equals(waVersion)) {
                    return Profile.JAVA_EE_6_WEB;
                }
            }
            catch (IOException exc) {
                ErrorManager.getDefault().notify((Throwable)exc);
            }
            return null;
        }
        return Profile.JAVA_EE_6_WEB;
    }

    public FileObject getDocumentBase() {
        Sources srcs = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] grp = srcs.getSourceGroups("doc_root");
        if (grp.length > 0) {
            return grp[0].getRootFolder();
        }
        return null;
    }

    File getDDFile(String path) {
        String webxmlDefined = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-war-plugin", (String)"webXml", (String)"war");
        if (webxmlDefined != null) {
            // empty if block
        }
        URI dir = this.mavenproject.getWebAppDirectory();
        File fil = new File(new File(dir), path);
        fil = FileUtil.normalizeFile((File)fil);
        return fil;
    }

    public FileObject getDeploymentDescriptor() {
        File dd = this.getDDFile("WEB-INF/web.xml");
        if (dd != null) {
            return FileUtil.toFileObject((File)dd);
        }
        return null;
    }

    public String getContextPath() {
        Profile prof = this.getJ2eeProfile();
        if (this.getDeploymentDescriptor() != null || prof == Profile.JAVA_EE_6_FULL || prof == Profile.JAVA_EE_6_WEB) {
            try {
                String path = this.provider.getConfigSupport().getWebContextRoot();
                if (path != null) {
                    return path;
                }
            }
            catch (ConfigurationException e) {
                // empty catch block
            }
        }
        String toRet = "/" + this.mavenproject.getMavenProject().getArtifactId();
        return toRet;
    }

    public void setContextPath(String newPath) {
        Profile prof = this.getJ2eeProfile();
        if (this.getDeploymentDescriptor() != null || prof == Profile.JAVA_EE_6_FULL || prof == Profile.JAVA_EE_6_WEB) {
            try {
                this.provider.getConfigSupport().setWebContextRoot(newPath);
            }
            catch (ConfigurationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public boolean isValid() {
        return true;
    }

    public String getModuleVersion() {
        WebApp wapp = this.getWebApp();
        String version = null;
        if (wapp != null) {
            version = wapp.getVersion();
        }
        if (version == null) {
            version = "3.0";
        }
        return version;
    }

    public J2eeModule.Type getModuleType() {
        return J2eeModule.Type.WAR;
    }

    public String getUrl() {
        String toRet = "/" + this.mavenproject.getMavenProject().getBuild().getFinalName();
        return toRet;
    }

    public FileObject getArchive() throws IOException {
        MavenProject proj = this.mavenproject.getMavenProject();
        String loc = proj.getBuild().getDirectory();
        String finalName = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-war-plugin", (String)"warName", (String)"war");
        if (finalName == null) {
            finalName = proj.getBuild().getFinalName();
        }
        File fil = FileUtil.normalizeFile((File)new File(loc, finalName + ".war"));
        return FileUtil.toFileObject((File)fil);
    }

    public Iterator getArchiveContents() throws IOException {
        FileObject fo = this.getContentDirectory();
        if (fo != null) {
            return new ContentIterator(fo);
        }
        return null;
    }

    public FileObject getContentDirectory() throws IOException {
        FileObject fo;
        if (this.inplace) {
            fo = this.getDocumentBase();
        } else {
            MavenProject proj = this.mavenproject.getMavenProject();
            String loc = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-war-plugin", (String)"webappDirectory", (String)"war");
            if (loc == null) {
                String finalName = proj.getBuild().getFinalName();
                loc = proj.getBuild().getDirectory() + File.separator + finalName;
            }
            File fil = FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (String)loc);
            fo = FileUtil.toFileObject((File)fil);
        }
        if (fo != null) {
            fo.refresh();
        }
        return fo;
    }

    private WebApp getWebApp() {
        try {
            FileObject deploymentDescriptor = this.getDeploymentDescriptor();
            if (deploymentDescriptor != null) {
                return DDProvider.getDefault().getDDRoot(deploymentDescriptor);
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().log(e.getLocalizedMessage());
        }
        return null;
    }

    public FileObject[] getJavaSources() {
        Sources srcs = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] gr = srcs.getSourceGroups("java");
        ArrayList<FileObject> toRet = new ArrayList<FileObject>();
        if (gr != null) {
            for (int i = 0; i < gr.length; ++i) {
                toRet.add(gr[i].getRootFolder());
            }
        }
        return toRet.toArray(new FileObject[toRet.size()]);
    }

    public File getResourceDirectory() {
        File toRet = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "src" + File.separator + "main" + File.separator + "setup");
        return toRet;
    }

    public File getDeploymentConfigurationFile(String name) {
        if (name == null) {
            return null;
        }
        if ("web.xml".equals(name)) {
            name = "WEB-INF/web.xml";
        } else {
            String path = this.provider.getConfigSupport().getContentRelativePath(name);
            if (path != null) {
                name = path;
            }
        }
        return this.getDDFile(name);
    }

    public void addPropertyChangeListener(PropertyChangeListener arg0) {
    }

    public void removePropertyChangeListener(PropertyChangeListener arg0) {
    }

    public <T> MetadataModel<T> getMetadataModel(Class<T> type) {
        if (type == WebAppMetadata.class) {
            MetadataModel<WebAppMetadata> model = this.getAnnotationMetadataModel();
            return model;
        }
        if (type == WebservicesMetadata.class) {
            MetadataModel<WebservicesMetadata> model = this.getWebservicesMetadataModel();
            return model;
        }
        return null;
    }

    public synchronized MetadataModel<WebAppMetadata> getMetadataModel() {
        if (this.webAppMetadataModel == null) {
            FileObject ddFO = this.getDeploymentDescriptor();
            File ddFile = ddFO != null ? FileUtil.toFile((FileObject)ddFO) : null;
            ProjectSourcesClassPathProvider cpProvider = (ProjectSourcesClassPathProvider)this.project.getLookup().lookup(ProjectSourcesClassPathProvider.class);
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/source"), (File)ddFile);
            this.webAppMetadataModel = WebAppMetadataModelFactory.createMetadataModel((MetadataUnit)metadataUnit, (boolean)true);
        }
        return this.webAppMetadataModel;
    }

    private synchronized MetadataModel<WebservicesMetadata> getWebservicesMetadataModel() {
        if (this.webservicesMetadataModel == null) {
            FileObject ddFO = this.getWebServicesDeploymentDescriptor();
            File ddFile = ddFO != null ? FileUtil.toFile((FileObject)ddFO) : null;
            ProjectSourcesClassPathProvider cpProvider = (ProjectSourcesClassPathProvider)this.project.getLookup().lookup(ProjectSourcesClassPathProvider.class);
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/source"), (File)ddFile);
            this.webservicesMetadataModel = WebservicesMetadataModelFactory.createMetadataModel((MetadataUnit)metadataUnit);
        }
        return this.webservicesMetadataModel;
    }

    private FileObject getWebServicesDeploymentDescriptor() {
        FileObject root = this.getDocumentBase();
        if (root != null) {
            return root.getFileObject("WEB-INF/webservices.xml");
        }
        return null;
    }

    public synchronized MetadataModel<WebAppMetadata> getAnnotationMetadataModel() {
        if (this.webAppAnnMetadataModel == null) {
            FileObject ddFO = this.getDeploymentDescriptor();
            File ddFile = ddFO != null ? FileUtil.toFile((FileObject)ddFO) : null;
            ProjectSourcesClassPathProvider cpProvider = (ProjectSourcesClassPathProvider)this.project.getLookup().lookup(ProjectSourcesClassPathProvider.class);
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)cpProvider.getProjectSourcesClassPath("classpath/source"), (File)ddFile);
            this.webAppAnnMetadataModel = WebAppMetadataModelFactory.createMetadataModel((MetadataUnit)metadataUnit, (boolean)false);
        }
        return this.webAppAnnMetadataModel;
    }

    private static final class FSRootRE
    implements J2eeModule.RootedEntry {
        private FileObject f;
        private FileObject root;

        FSRootRE(FileObject rt, FileObject fo) {
            this.f = fo;
            this.root = rt;
        }

        public FileObject getFileObject() {
            return this.f;
        }

        public String getRelativePath() {
            return FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.f);
        }
    }

    private static final class ContentIterator
    implements Iterator {
        private ArrayList<FileObject> ch = new ArrayList();
        private FileObject root;

        private ContentIterator(FileObject f) {
            this.ch.add(f);
            this.root = f;
        }

        @Override
        public boolean hasNext() {
            return !this.ch.isEmpty();
        }

        public Object next() {
            FileObject f = this.ch.get(0);
            this.ch.remove(0);
            if (f.isFolder()) {
                f.refresh();
                FileObject[] chArr = f.getChildren();
                for (int i = 0; i < chArr.length; ++i) {
                    this.ch.add(chArr[i]);
                }
            }
            return new FSRootRE(this.root, f);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

