/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.tag;

import java.io.EOFException;
import java.io.File;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.tag.TagBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;

public class TagCommand
extends BasicCommand {
    private EventManager eventManager;
    private boolean checkThatUnmodified;
    private boolean deleteTag;
    private boolean makeBranchTag;
    private boolean overrideExistingTag;
    private boolean matchHeadIfRevisionNotFound;
    private String tag;
    private String tagByDate;
    private String tagByRevision;

    public Builder createBuilder(EventManager eventManager) {
        return new TagBuilder(eventManager, this.getLocalDirectory());
    }

    public boolean doesCheckThatUnmodified() {
        return this.checkThatUnmodified;
    }

    public boolean isCheckThatUnmodified() {
        return this.checkThatUnmodified;
    }

    public void setCheckThatUnmodified(boolean checkThatUnmodified) {
        this.checkThatUnmodified = checkThatUnmodified;
    }

    public boolean doesDeleteTag() {
        return this.deleteTag;
    }

    public boolean isDeleteTag() {
        return this.deleteTag;
    }

    public void setDeleteTag(boolean deleteTag) {
        this.deleteTag = deleteTag;
    }

    public boolean doesMakeBranchTag() {
        return this.makeBranchTag;
    }

    public boolean isMakeBranchTag() {
        return this.makeBranchTag;
    }

    public void setMakeBranchTag(boolean makeBranchTag) {
        this.makeBranchTag = makeBranchTag;
    }

    public boolean doesOverrideExistingTag() {
        return this.overrideExistingTag;
    }

    public boolean isOverrideExistingTag() {
        return this.overrideExistingTag;
    }

    public void setOverrideExistingTag(boolean overrideExistingTag) {
        this.overrideExistingTag = overrideExistingTag;
    }

    public boolean isMatchHeadIfRevisionNotFound() {
        return this.matchHeadIfRevisionNotFound;
    }

    public void setMatchHeadIfRevisionNotFound(boolean matchHeadIfRevisionNotFound) {
        this.matchHeadIfRevisionNotFound = matchHeadIfRevisionNotFound;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag2) {
        this.tag = tag2;
    }

    public String getTagByDate() {
        return this.tagByDate;
    }

    public void setTagByDate(String tagDate) {
        this.tagByDate = tagDate;
    }

    public String getTagByRevision() {
        return this.tagByRevision;
    }

    public void setTagByRevision(String tagRevision) {
        this.tagByRevision = tagRevision;
    }

    public void execute(ClientServices client, EventManager eventManager) throws CommandException, AuthenticationException {
        client.ensureConnection();
        this.eventManager = eventManager;
        super.execute(client, eventManager);
        try {
            this.requests.add(1, new ArgumentRequest(this.getTag()));
            if (this.checkThatUnmodified) {
                this.requests.add(1, new ArgumentRequest("-c"));
            }
            if (this.overrideExistingTag) {
                this.requests.add(1, new ArgumentRequest("-F"));
            }
            if (this.matchHeadIfRevisionNotFound) {
                this.requests.add(1, new ArgumentRequest("-f"));
            }
            if (this.makeBranchTag) {
                this.requests.add(1, new ArgumentRequest("-b"));
            }
            if (this.deleteTag) {
                this.requests.add(1, new ArgumentRequest("-d"));
            }
            if (this.tagByDate != null && this.tagByDate.length() > 0) {
                this.requests.add(1, new ArgumentRequest("-D"));
                this.requests.add(2, new ArgumentRequest(this.getTagByDate()));
            }
            if (this.tagByRevision != null && this.tagByRevision.length() > 0) {
                this.requests.add(1, new ArgumentRequest("-r"));
                this.requests.add(2, new ArgumentRequest(this.getTagByRevision()));
            }
            this.addRequestForWorkingDirectory(client);
            this.addArgumentRequests();
            this.addRequest(CommandRequest.TAG);
            client.processRequests(this.requests);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (EOFException ex) {
            throw new CommandException(ex, CommandException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (Exception ex) {
            throw new CommandException(ex, ex.getLocalizedMessage());
        }
        finally {
            this.requests.clear();
        }
    }

    public void commandTerminated(TerminationEvent e) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public String getCVSCommand() {
        File[] files;
        StringBuffer toReturn = new StringBuffer("tag ");
        toReturn.append(this.getCVSArguments());
        if (this.getTag() != null) {
            toReturn.append(this.getTag());
            toReturn.append(" ");
        }
        if ((files = this.getFiles()) != null) {
            for (int index = 0; index < files.length; ++index) {
                toReturn.append(files[index].getName());
                toReturn.append(' ');
            }
        }
        return toReturn.toString();
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'l') {
            this.setRecursive(false);
        } else if (opt == 'c') {
            this.setCheckThatUnmodified(true);
        } else if (opt == 'd') {
            this.setDeleteTag(true);
        } else if (opt == 'F') {
            this.setOverrideExistingTag(true);
        } else if (opt == 'f') {
            this.setMatchHeadIfRevisionNotFound(true);
        } else if (opt == 'b') {
            this.setMakeBranchTag(true);
        } else if (opt == 'D') {
            this.setTagByDate(optArg.trim());
        } else if (opt == 'r') {
            this.setTagByRevision(optArg.trim());
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "RlcFfbdD:r:";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setCheckThatUnmodified(false);
        this.setDeleteTag(false);
        this.setMakeBranchTag(false);
        this.setOverrideExistingTag(false);
        this.setMatchHeadIfRevisionNotFound(false);
    }

    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer();
        if (!this.isRecursive()) {
            toReturn.append("-l ");
        }
        if (this.isCheckThatUnmodified()) {
            toReturn.append("-c ");
        }
        if (this.isOverrideExistingTag()) {
            toReturn.append("-F ");
        }
        if (this.isMatchHeadIfRevisionNotFound()) {
            toReturn.append("-f ");
        }
        if (this.isMakeBranchTag()) {
            toReturn.append("-b ");
        }
        if (this.isDeleteTag()) {
            toReturn.append("-d ");
        }
        if (this.getTagByRevision() != null && this.getTagByRevision().length() > 0) {
            toReturn.append("-r ");
            toReturn.append(this.getTagByRevision());
            toReturn.append(" ");
        }
        if (this.getTagByDate() != null && this.getTagByDate().length() > 0) {
            toReturn.append("-D ");
            toReturn.append(this.getTagByDate());
            toReturn.append(" ");
        }
        return toReturn.toString();
    }
}

