/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.FileStatusCache;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.GitRepositories;
import org.netbeans.modules.git.ui.history.SearchHistoryAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.util.DelayScanRegistry;
import org.netbeans.modules.versioning.util.FileUtils;
import org.netbeans.modules.versioning.util.SearchHistorySupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class FilesystemInterceptor
extends VCSInterceptor {
    private final FileStatusCache cache;
    private final Set<File> filesToRefresh = new HashSet<File>();
    private final Map<File, Set<File>> lockedRepositories = new HashMap<File, Set<File>>(5);
    private RequestProcessor.Task refreshTask;
    private RequestProcessor.Task lockedRepositoryRefreshTask;
    private static final RequestProcessor rp = new RequestProcessor("GitRefresh", 1, true);
    private final GitFolderEventsHandler gitFolderEventsHandler;
    private static boolean AUTOMATIC_REFRESH_ENABLED = !"true".equals(System.getProperty("versioning.git.autoRefreshDisabled", "false"));
    private static final String INDEX_FILE_NAME = "index";
    private static final String HEAD_FILE_NAME = "HEAD";
    private static final Logger LOG = Logger.getLogger(FilesystemInterceptor.class.getName());
    private final Map<File, Long> createdFolders = new LinkedHashMap<File, Long>(){

        @Override
        public Long put(File key, Long value) {
            long t = System.currentTimeMillis();
            Iterator it = this.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                if ((Long)e.getValue() >= t - 600000L) continue;
                it.remove();
            }
            return super.put(key, value);
        }
    };

    public FilesystemInterceptor() {
        this.cache = Git.getInstance().getFileStatusCache();
        this.refreshTask = rp.create((Runnable)new RefreshTask());
        this.lockedRepositoryRefreshTask = rp.create((Runnable)new LockedRepositoryRefreshTask());
        this.gitFolderEventsHandler = new GitFolderEventsHandler();
    }

    public long refreshRecursively(File dir, long lastTimeStamp, List<? super File> children) {
        long retval = -1L;
        if (".git".equals(dir.getName())) {
            Git.STATUS_LOG.log(Level.FINER, "Interceptor.refreshRecursively: {0}", dir.getAbsolutePath());
            children.clear();
            retval = this.gitFolderEventsHandler.refreshAdminFolder(dir);
        }
        return retval;
    }

    public boolean beforeCreate(File file, boolean isDirectory) {
        LOG.log(Level.FINE, "beforeCreate {0} - {1}", new Object[]{file, isDirectory});
        if (GitUtils.isPartOfGitMetadata(file)) {
            return false;
        }
        if (!isDirectory && !file.exists()) {
            Git git = Git.getInstance();
            File root = git.getRepositoryRoot(file);
            if (root == null) {
                return false;
            }
            try {
                git.getClient(root).reset(new File[]{file}, HEAD_FILE_NAME, true, ProgressMonitor.NULL_PROGRESS_MONITOR);
            }
            catch (GitException ex) {
                LOG.log(Level.INFO, "beforeCreate(): File: {0} {1}", new Object[]{file.getAbsolutePath(), ex.toString()});
            }
            LOG.log(Level.FINER, "beforeCreate(): finished: {0}", file);
        }
        return false;
    }

    public void afterCreate(File file) {
        LOG.log(Level.FINE, "afterCreate {0}", file);
        this.addToCreated(file);
        if (!this.cache.getStatus(file).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            this.reScheduleRefresh(800, Collections.singleton(file));
        }
    }

    public boolean beforeDelete(File file) {
        LOG.log(Level.FINE, "beforeDelete {0}", file);
        if (file == null) {
            return false;
        }
        if (GitUtils.isPartOfGitMetadata(file)) {
            return false;
        }
        return !this.cache.getStatus(file).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED);
    }

    public void doDelete(File file) throws IOException {
        LOG.log(Level.FINE, "doDelete {0}", file);
        if (file == null) {
            return;
        }
        Git git = Git.getInstance();
        File root = git.getRepositoryRoot(file);
        try {
            if (GitUtils.getGitFolderForRoot(root).exists()) {
                git.getClient(root).remove(new File[]{file}, false, ProgressMonitor.NULL_PROGRESS_MONITOR);
            } else if (file.exists()) {
                file.delete();
            }
            if (file.equals(root)) {
                this.refreshMetadataTimestamp(root);
            }
        }
        catch (GitException e) {
            IOException ex = new IOException();
            Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(FilesystemInterceptor.class, (String)"MSG_DeleteFailed", (Object[])new Object[]{file, e.getLocalizedMessage()}));
            ex.initCause(e);
            throw ex;
        }
    }

    public void afterDelete(File file) {
        LOG.log(Level.FINE, "afterDelete {0}", file);
        if (file == null) {
            return;
        }
        if (!this.cache.getStatus(file).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            this.reScheduleRefresh(800, Collections.singleton(file));
        }
    }

    public boolean beforeMove(File from, File to) {
        LOG.log(Level.FINE, "beforeMove {0} -> {1}", new Object[]{from, to});
        if (from == null || to == null || to.exists()) {
            return true;
        }
        Git hg = Git.getInstance();
        return hg.isManaged(from) && hg.isManaged(to);
    }

    public void doMove(File from, File to) throws IOException {
        LOG.log(Level.FINE, "doMove {0} -> {1}", new Object[]{from, to});
        if (from == null || to == null || to.exists()) {
            return;
        }
        Git git = Git.getInstance();
        File root = git.getRepositoryRoot(from);
        File dstRoot = git.getRepositoryRoot(to);
        try {
            if (root != null && root.equals(dstRoot) && !this.cache.getStatus(to).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
                git.getClient(root).rename(from, to, false, ProgressMonitor.NULL_PROGRESS_MONITOR);
            } else {
                boolean result = from.renameTo(to);
                if (!result) {
                    throw new IOException(NbBundle.getMessage(FilesystemInterceptor.class, (String)"MSG_MoveFailed", (Object[])new Object[]{from, to, ""}));
                }
                if (root != null) {
                    git.getClient(root).remove(new File[]{from}, true, ProgressMonitor.NULL_PROGRESS_MONITOR);
                }
            }
        }
        catch (GitException e) {
            IOException ex = new IOException();
            Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(FilesystemInterceptor.class, (String)"MSG_MoveFailed", (Object[])new Object[]{from, to, e.getLocalizedMessage()}));
            ex.initCause(e);
            throw ex;
        }
    }

    public void afterMove(File from, File to) {
        LOG.log(Level.FINE, "afterMove {0} -> {1}", new Object[]{from, to});
        if (from == null || to == null || !to.exists()) {
            return;
        }
        if (!this.cache.getStatus(from).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            this.reScheduleRefresh(800, Collections.singleton(from));
        }
        this.addToCreated(to);
        if (!this.cache.getStatus(to).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            this.reScheduleRefresh(800, Collections.singleton(to));
        }
    }

    public boolean beforeCopy(File from, File to) {
        LOG.log(Level.FINE, "beforeCopy {0}->{1}", new Object[]{from, to});
        if (from == null || to == null || to.exists()) {
            return true;
        }
        Git git = Git.getInstance();
        return git.isManaged(from) && git.isManaged(to);
    }

    public void doCopy(File from, File to) throws IOException {
        LOG.log(Level.FINE, "doCopy {0}->{1}", new Object[]{from, to});
        if (from == null || to == null || to.exists()) {
            return;
        }
        Git git = Git.getInstance();
        File root = git.getRepositoryRoot(from);
        File dstRoot = git.getRepositoryRoot(to);
        if (from.isDirectory()) {
            FileUtils.copyDirFiles((File)from, (File)to);
        } else {
            FileUtils.copyFile((File)from, (File)to);
        }
        if (root == null || this.cache.getStatus(to).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            return;
        }
        try {
            if (root.equals(dstRoot)) {
                git.getClient(root).copyAfter(from, to, ProgressMonitor.NULL_PROGRESS_MONITOR);
            }
        }
        catch (GitException e) {
            IOException ex = new IOException();
            Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(FilesystemInterceptor.class, (String)"MSG_CopyFailed", (Object[])new Object[]{from, to, e.getLocalizedMessage()}));
            ex.initCause(e);
            throw ex;
        }
    }

    public void afterCopy(File from, File to) {
        LOG.log(Level.FINE, "afterCopy {0}->{1}", new Object[]{from, to});
        if (to == null) {
            return;
        }
        this.addToCreated(to);
        if (!this.cache.getStatus(to).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            this.reScheduleRefresh(800, Collections.singleton(to));
        }
    }

    public void afterChange(File file) {
        if (file.isDirectory()) {
            return;
        }
        LOG.log(Level.FINE, "afterChange {0}", new Object[]{file});
        if (!this.cache.getStatus(file).containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            this.reScheduleRefresh(800, Collections.singleton(file));
        }
    }

    public boolean isMutable(File file) {
        return GitUtils.isPartOfGitMetadata(file) || super.isMutable(file);
    }

    public Object getAttribute(File file, String attrName) {
        if ("ProvidedExtensions.SearchHistorySupport".equals(attrName)) {
            return new GitSearchHistorySupport(file);
        }
        return super.getAttribute(file, attrName);
    }

    void pingRepositoryRootFor(File file) {
        if (!AUTOMATIC_REFRESH_ENABLED) {
            return;
        }
        this.gitFolderEventsHandler.initializeFor(file);
    }

    Set<File> getSeenRoots(File repositoryRoot) {
        return this.gitFolderEventsHandler.getSeenRoots(repositoryRoot);
    }

    void refreshMetadataTimestamp(final File repository) {
        assert (repository != null);
        if (repository == null) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            Git.getInstance().getRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    FilesystemInterceptor.this.gitFolderEventsHandler.refreshIndexFileTimestamp(repository);
                }
            });
        } else {
            this.gitFolderEventsHandler.refreshIndexFileTimestamp(repository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToCreated(File createdFile) {
        if (!GitModuleConfig.getDefault().getAutoIgnoreFiles() || !createdFile.isDirectory()) {
            return;
        }
        Map<File, Long> map = this.createdFolders;
        synchronized (map) {
            for (File f : this.createdFolders.keySet()) {
                if (!Utils.isAncestorOrEqual((File)f, (File)createdFile)) continue;
                return;
            }
            this.createdFolders.put(createdFile, createdFile.lastModified());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<File> getCreatedFolders() {
        Map<File, Long> map = this.createdFolders;
        synchronized (map) {
            return new HashSet<File>(this.createdFolders.keySet());
        }
    }

    private Collection<File> checkLockedRepositories(Collection<File> additionalFilesToRefresh, boolean keepCached) {
        LinkedList<File> retval = new LinkedList<File>();
        Map<File, Set<File>> sortedFiles = this.sortByRepository(additionalFilesToRefresh);
        for (Map.Entry<File, Set<File>> e : sortedFiles.entrySet()) {
            Set<File> alreadyPlanned = this.lockedRepositories.get(e.getKey());
            if (alreadyPlanned == null) {
                alreadyPlanned = new HashSet<File>();
                this.lockedRepositories.put(e.getKey(), alreadyPlanned);
            }
            alreadyPlanned.addAll((Collection<File>)e.getValue());
        }
        Iterator<Map.Entry<File, Set<File>>> it = this.lockedRepositories.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<File, Set<File>> entry = it.next();
            File repository = entry.getKey();
            if (!repository.exists()) {
                it.remove();
                continue;
            }
            if (GitUtils.isRepositoryLocked(repository)) {
                Git.STATUS_LOG.log(Level.FINE, "checkLockedRepositories(): Repository {0} locked, status refresh delayed", repository);
                continue;
            }
            retval.addAll((Collection<File>)entry.getValue());
            if (keepCached) continue;
            it.remove();
        }
        return retval;
    }

    private Map<File, Set<File>> sortByRepository(Collection<File> files) {
        HashMap<File, Set<File>> sorted = new HashMap<File, Set<File>>(5);
        for (File f : files) {
            File repository = Git.getInstance().getRepositoryRoot(f);
            if (repository == null) continue;
            HashSet<File> repoFiles = (HashSet<File>)sorted.get(repository);
            if (repoFiles == null) {
                repoFiles = new HashSet<File>();
                sorted.put(repository, repoFiles);
            }
            repoFiles.add(f);
        }
        return sorted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reScheduleRefresh(int delayMillis, Set<File> filesToRefresh) {
        boolean changed;
        HashSet<File> filteredFiles = new HashSet<File>(filesToRefresh);
        Iterator it = filteredFiles.iterator();
        while (it.hasNext()) {
            if (!GitUtils.isPartOfGitMetadata((File)it.next())) continue;
            it.remove();
        }
        Set<File> set = this.filesToRefresh;
        synchronized (set) {
            changed = this.filesToRefresh.addAll(filteredFiles);
        }
        if (changed) {
            Git.STATUS_LOG.log(Level.FINE, "reScheduleRefresh: adding {0}", filteredFiles);
            this.refreshTask.schedule(delayMillis);
        }
    }

    public class GitSearchHistorySupport
    extends SearchHistorySupport {
        public GitSearchHistorySupport(File file) {
            super(file);
        }

        protected boolean searchHistoryImpl(int line) throws IOException {
            assert (line < 0) : "Search History a for specific not supported yet!";
            File file = this.getFile();
            SearchHistoryAction.openSearch(Git.getInstance().getRepositoryRoot(file), new File[]{file}, file.getName());
            return true;
        }
    }

    private class GitFolderEventsHandler {
        private final HashMap<File, Set<File>> seenRoots = new HashMap();
        private final HashMap<File, GitFolderTimestamps> timestamps = new HashMap(5);
        private final HashMap<File, FileChangeListener> gitFolderRLs = new HashMap(5);
        private final HashSet<File> filesToInitialize = new HashSet();
        private final RequestProcessor.Task initializingTask = FilesystemInterceptor.access$1300().create(new Runnable(){

            @Override
            public void run() {
                GitFolderEventsHandler.this.initializeFiles();
            }
        });
        private final HashSet<File> refreshedRepositories = new HashSet(5);
        private final RequestProcessor.Task refreshOpenFilesTask = FilesystemInterceptor.access$1300().create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashSet repositories;
                HashSet hashSet = GitFolderEventsHandler.this.refreshedRepositories;
                synchronized (hashSet) {
                    repositories = new HashSet(GitFolderEventsHandler.this.refreshedRepositories);
                    GitFolderEventsHandler.this.refreshedRepositories.clear();
                }
                Set openFiles = Utils.getOpenFiles();
                Iterator it = openFiles.iterator();
                while (it.hasNext()) {
                    File file = (File)it.next();
                    if (repositories.contains(Git.getInstance().getRepositoryRoot(file))) continue;
                    it.remove();
                }
                if (!openFiles.isEmpty()) {
                    Git.getInstance().headChanged(openFiles);
                }
            }
        });
        private final GitRepositories gitRepositories = GitRepositories.getInstance();

        private GitFolderEventsHandler() {
        }

        public void initializeFor(File file) {
            if (this.addFileToInitialize(file)) {
                this.initializingTask.schedule(500);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<File> getSeenRoots(File repositoryRoot) {
            Set<File> seenRootsForRepository;
            HashSet<File> retval = new HashSet<File>();
            Set<File> set = seenRootsForRepository = this.getSeenRootsForRepository(repositoryRoot);
            synchronized (set) {
                retval.addAll(seenRootsForRepository);
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addSeenRoot(File repositoryRoot, File rootToAdd) {
            Set<File> seenRootsForRepository;
            boolean added = false;
            Set<File> set = seenRootsForRepository = this.getSeenRootsForRepository(repositoryRoot);
            synchronized (set) {
                if (!seenRootsForRepository.contains(repositoryRoot)) {
                    added = !GitUtils.prepareRootFiles(repositoryRoot, seenRootsForRepository, rootToAdd = FileUtil.normalizeFile((File)rootToAdd));
                }
            }
            return added;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<File> getSeenRootsForRepository(File repositoryRoot) {
            HashMap<File, Set<File>> hashMap = this.seenRoots;
            synchronized (hashMap) {
                Set<File> seenRootsForRepository = this.seenRoots.get(repositoryRoot);
                if (seenRootsForRepository == null) {
                    seenRootsForRepository = new HashSet<File>();
                    this.seenRoots.put(repositoryRoot, seenRootsForRepository);
                }
                return seenRootsForRepository;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addFileToInitialize(File file) {
            HashSet<File> hashSet = this.filesToInitialize;
            synchronized (hashSet) {
                return this.filesToInitialize.add(file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File getFileToInitialize() {
            File nextFile = null;
            HashSet<File> hashSet = this.filesToInitialize;
            synchronized (hashSet) {
                Iterator<File> iterator = this.filesToInitialize.iterator();
                if (iterator.hasNext()) {
                    nextFile = iterator.next();
                    iterator.remove();
                }
            }
            return nextFile;
        }

        private GitFolderTimestamps scanGitFolderTimestamps(File gitFolder) {
            File indexFile = new File(gitFolder, FilesystemInterceptor.INDEX_FILE_NAME);
            File headFile = new File(gitFolder, FilesystemInterceptor.HEAD_FILE_NAME);
            GitBranch activeBranch = null;
            RepositoryInfo info = RepositoryInfo.getInstance(gitFolder.getParentFile());
            if (info != null) {
                info.refresh();
                activeBranch = info.getActiveBranch();
            }
            File refFile = headFile;
            if (activeBranch != null && !"(no branch)".equals(activeBranch.getName())) {
                refFile = new File(gitFolder, ("refs/heads/" + activeBranch.getName()).replace("/", File.separator));
            }
            return new GitFolderTimestamps(indexFile, headFile, refFile, gitFolder);
        }

        public void refreshIndexFileTimestamp(File repository) {
            this.refreshIndexFileTimestamp(this.scanGitFolderTimestamps(GitUtils.getGitFolderForRoot(repository)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshIndexFileTimestamp(GitFolderTimestamps newTimestamps) {
            if (Utils.isAncestorOrEqual((File)new File(System.getProperty("java.io.tmpdir")), (File)newTimestamps.getIndexFile())) {
                return;
            }
            final File gitFolder = newTimestamps.getGitFolder();
            boolean exists = newTimestamps.repositoryExists();
            HashMap<File, GitFolderTimestamps> hashMap = this.timestamps;
            synchronized (hashMap) {
                if (exists && !newTimestamps.isNewer(this.timestamps.get(gitFolder))) {
                    return;
                }
            }
            boolean add = false;
            boolean remove = false;
            HashMap<File, GitFolderTimestamps> hashMap2 = this.timestamps;
            synchronized (hashMap2) {
                FileChangeListener fList;
                this.timestamps.remove(gitFolder);
                FileChangeListener list = this.gitFolderRLs.remove(gitFolder);
                if (exists) {
                    this.timestamps.put(gitFolder, newTimestamps);
                    if (list == null) {
                        fList = list = new FileChangeAdapter();
                        rp.post(new Runnable(){

                            @Override
                            public void run() {
                                FileUtil.addRecursiveListener((FileChangeListener)fList, (File)gitFolder);
                            }
                        });
                    }
                    this.gitFolderRLs.put(gitFolder, list);
                    add = true;
                } else {
                    if (list != null) {
                        fList = list;
                        rp.post(new Runnable(){

                            @Override
                            public void run() {
                                FileUtil.removeRecursiveListener((FileChangeListener)fList, (File)gitFolder);
                                Git.getInstance().versionedFilesChanged();
                            }
                        });
                    }
                    Git.STATUS_LOG.log(Level.FINE, "refreshAdminFolderTimestamp: {0} no longer exists", gitFolder.getAbsolutePath());
                    remove = true;
                }
                if (remove) {
                    this.gitRepositories.remove(gitFolder.getParentFile());
                } else if (add) {
                    File repository = gitFolder.getParentFile();
                    if (!repository.equals(Git.getInstance().getRepositoryRoot(repository))) {
                        Git.getInstance().versionedFilesChanged();
                    }
                    this.gitRepositories.add(repository);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeFiles() {
            File file = null;
            while ((file = this.getFileToInitialize()) != null) {
                Git.STATUS_LOG.log(Level.FINEST, "GitFolderEventsHandler.initializeFiles: {0}", file.getAbsolutePath());
                File repositoryRoot = Git.getInstance().getRepositoryRoot(file);
                if (repositoryRoot == null || !this.addSeenRoot(repositoryRoot, file)) continue;
                Git.STATUS_LOG.log(Level.FINE, "initializeFiles: planning a scan for {0} - {1}", new Object[]{repositoryRoot.getAbsolutePath(), file.getAbsolutePath()});
                FilesystemInterceptor.this.reScheduleRefresh(4000, Collections.singleton(file));
                File gitFolder = GitUtils.getGitFolderForRoot(repositoryRoot);
                boolean refreshNeeded = false;
                HashMap<File, GitFolderTimestamps> hashMap = this.timestamps;
                synchronized (hashMap) {
                    if (!this.timestamps.containsKey(gitFolder) && new File(gitFolder, FilesystemInterceptor.INDEX_FILE_NAME).canRead()) {
                        this.timestamps.put(gitFolder, null);
                        refreshNeeded = true;
                    }
                }
                if (!refreshNeeded) continue;
                this.refreshIndexFileTimestamp(this.scanGitFolderTimestamps(gitFolder));
            }
            Git.STATUS_LOG.log(Level.FINEST, "GitFolderEventsHandler.initializeFiles: finished");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long refreshAdminFolder(File gitFolder) {
            long lastModified = 0L;
            if (AUTOMATIC_REFRESH_ENABLED && !"false".equals(System.getProperty("versioning.git.handleExternalEvents", "true"))) {
                GitFolderTimestamps cached;
                gitFolder = FileUtil.normalizeFile((File)gitFolder);
                Git.STATUS_LOG.log(Level.FINER, "refreshAdminFolder: special FS event handling for {0}", gitFolder.getAbsolutePath());
                boolean refreshNeeded = false;
                HashMap<File, GitFolderTimestamps> hashMap = this.timestamps;
                synchronized (hashMap) {
                    cached = this.timestamps.get(gitFolder);
                }
                if (cached == null || !cached.repositoryExists() || cached.isOutdated()) {
                    this.refreshIndexFileTimestamp(this.scanGitFolderTimestamps(gitFolder));
                    refreshNeeded = true;
                }
                if (refreshNeeded) {
                    File repository = gitFolder.getParentFile();
                    RepositoryInfo.refreshAsync(repository);
                    Git.STATUS_LOG.log(Level.FINE, "refreshAdminFolder: planning repository scan for {0}", repository.getAbsolutePath());
                    FilesystemInterceptor.this.reScheduleRefresh(3000, this.getSeenRoots(repository));
                    this.refreshOpenFiles(repository);
                }
            }
            return lastModified;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshOpenFiles(File repository) {
            boolean refreshPlanned;
            HashSet<File> hashSet = this.refreshedRepositories;
            synchronized (hashSet) {
                refreshPlanned = !this.refreshedRepositories.add(repository);
            }
            if (refreshPlanned) {
                this.refreshOpenFilesTask.schedule(3000);
            }
        }
    }

    private static class GitFolderTimestamps {
        private final File indexFile;
        private final long indexFileTS;
        private final File headFile;
        private final long headFileTS;
        private final File refFile;
        private final long refFileTS;
        private final File gitFolder;

        public GitFolderTimestamps(File indexFile, File headFile, File refFile, File gitFolder) {
            this.indexFile = indexFile;
            this.indexFileTS = indexFile.lastModified();
            this.headFile = headFile;
            this.headFileTS = headFile.lastModified();
            this.refFile = refFile;
            this.refFileTS = refFile.lastModified();
            this.gitFolder = gitFolder;
        }

        private File getIndexFile() {
            return this.indexFile;
        }

        private boolean isNewer(GitFolderTimestamps other) {
            boolean newer = true;
            if (other != null) {
                newer = this.indexFileTS > other.indexFileTS || this.headFileTS > other.headFileTS;
            }
            return newer;
        }

        private File getGitFolder() {
            return this.gitFolder;
        }

        private boolean repositoryExists() {
            return this.indexFileTS > 0L || this.gitFolder.exists();
        }

        private boolean isOutdated() {
            boolean upToDate;
            boolean bl = upToDate = this.indexFileTS >= this.indexFile.lastModified();
            if (upToDate) {
                boolean bl2 = upToDate = this.headFileTS >= this.headFile.lastModified();
            }
            if (upToDate) {
                upToDate = this.refFileTS >= this.refFile.lastModified();
            }
            return !upToDate;
        }
    }

    private class LockedRepositoryRefreshTask
    implements Runnable {
        private LockedRepositoryRefreshTask() {
        }

        @Override
        public void run() {
            if (!FilesystemInterceptor.this.checkLockedRepositories(Collections.emptySet(), true).isEmpty()) {
                FilesystemInterceptor.this.refreshTask.schedule(0);
            } else if (!FilesystemInterceptor.this.lockedRepositories.isEmpty()) {
                FilesystemInterceptor.this.lockedRepositoryRefreshTask.schedule(5000);
            }
        }
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashSet<File> files;
            Thread.interrupted();
            if (DelayScanRegistry.getInstance().isDelayed(FilesystemInterceptor.this.refreshTask, Git.STATUS_LOG, "GitInterceptor.refreshTask")) {
                return;
            }
            Set set = FilesystemInterceptor.this.filesToRefresh;
            synchronized (set) {
                files = new HashSet(FilesystemInterceptor.this.filesToRefresh);
                FilesystemInterceptor.this.filesToRefresh.clear();
            }
            if (!"false".equals(System.getProperty("versioning.git.delayStatusForLockedRepositories"))) {
                files = FilesystemInterceptor.this.checkLockedRepositories(files, false);
            }
            if (!files.isEmpty()) {
                FilesystemInterceptor.this.cache.refreshAllRoots(files);
            }
            if (!FilesystemInterceptor.this.lockedRepositories.isEmpty()) {
                FilesystemInterceptor.this.lockedRepositoryRefreshTask.schedule(5000);
            }
        }
    }
}

