/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.blame;

import java.io.File;
import java.util.logging.Level;
import org.netbeans.libs.git.GitLineDetails;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitUser;
import org.netbeans.modules.git.ui.blame.AnnotationBar;
import org.openide.util.NbBundle;

public class AnnotateLine {
    private final GitUser author;
    private final String authorShort;
    private final GitUser committer;
    private final GitRevisionInfo revision;
    private final File file;
    private final String content;
    private final int lineNum;
    private boolean canBeRolledBack = true;
    private static final String fakeItem = NbBundle.getMessage(AnnotateLine.class, (String)"MSG_AnnotateAction.lineDetail.unknown");

    AnnotateLine(GitLineDetails lineDetails, int lineNumber) {
        if (lineDetails == null) {
            this.revision = null;
            this.author = null;
            this.authorShort = fakeItem;
            this.committer = null;
            this.content = fakeItem;
            this.file = null;
        } else {
            this.revision = lineDetails.getRevisionInfo();
            this.author = lineDetails.getAuthor() == null ? lineDetails.getCommitter() : lineDetails.getAuthor();
            this.authorShort = this.getAuthorShort(this.author);
            this.committer = lineDetails.getCommitter();
            String cont = lineDetails.getContent().replace("\r", "").replace("\n", "");
            if (cont.length() != lineDetails.getContent().length()) {
                AnnotationBar.LOG.log(Level.FINE, "AnnotateLine: line content contains '\\r' or '\\n': {0}:{1}", new Object[]{lineDetails.getSourceFile(), lineNumber});
            }
            this.content = cont;
            this.file = lineDetails.getSourceFile();
        }
        this.lineNum = lineNumber;
    }

    public GitUser getAuthor() {
        return this.author;
    }

    public File getFile() {
        return this.file;
    }

    public GitRevisionInfo getRevisionInfo() {
        return this.revision;
    }

    public String getContent() {
        return this.content;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public boolean canBeRolledBack() {
        return this.canBeRolledBack;
    }

    public void setCanBeRolledBack(boolean canBeRolledBack) {
        this.canBeRolledBack = canBeRolledBack;
    }

    public String getAuthorShort() {
        return this.authorShort;
    }

    private String getAuthorShort(GitUser author) {
        int pos;
        if (author == null) {
            return fakeItem;
        }
        String shortened = null;
        String email = author.getEmailAddress();
        if (email != null && (pos = email.indexOf("@")) > -1) {
            shortened = email.substring(0, pos);
        }
        if (shortened == null) {
            shortened = author.toString().substring(0, 10) + "...";
        }
        return shortened;
    }
}

