/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.branch;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.ui.branch.CreateBranchPanel;
import org.netbeans.modules.git.ui.repository.RevisionDialogController;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CreateBranch
implements DocumentListener {
    private CreateBranchPanel panel;
    private RevisionDialogController revisionPicker;
    private JButton okButton;
    private DialogDescriptor dd;
    private boolean revisionValid = true;
    private Boolean nameValid = false;
    private final RequestProcessor.Task branchCheckTask;
    private String branchName;
    private final File repository;
    private final Icon ICON_ERROR = new ImageIcon(this.getClass().getResource("/org/netbeans/modules/git/resources/icons/info.png"));

    CreateBranch(File repository, String initialRevision) {
        this.repository = repository;
        this.branchCheckTask = Git.getInstance().getRequestProcessor(repository).create((Runnable)new BranchNameCheckWorker());
        this.revisionPicker = new RevisionDialogController(repository, new File[]{repository}, initialRevision);
        this.panel = new CreateBranchPanel(this.revisionPicker.getPanel());
    }

    String getRevision() {
        return this.revisionPicker.getRevision();
    }

    String getBranchName() {
        return this.panel.branchNameField.getText();
    }

    boolean show() {
        this.okButton = new JButton(NbBundle.getMessage(CreateBranch.class, (String)"LBL_CreateBranch.OKButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)this.okButton.getText());
        this.dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(CreateBranch.class, (String)"LBL_CreateBranch.title"), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, new HelpCtx(CreateBranch.class), null);
        this.validate();
        this.revisionPicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "RevisionDialogController.valid") {
                    CreateBranch.this.setRevisionValid(Boolean.TRUE.equals(evt.getNewValue()));
                }
            }
        });
        this.panel.branchNameField.getDocument().addDocumentListener(this);
        Dialog d = DialogDisplayer.getDefault().createDialog(this.dd);
        d.setVisible(true);
        return this.okButton == this.dd.getValue();
    }

    private void setRevisionValid(boolean flag) {
        this.revisionValid = flag;
        if (!flag) {
            this.setErrorMessage(NbBundle.getMessage(CreateBranch.class, (String)"MSG_CreateBranch.errorRevision"));
        }
        this.validate();
    }

    private void validate() {
        boolean flag = this.revisionValid & Boolean.TRUE.equals(this.nameValid);
        if (this.revisionValid && Boolean.FALSE.equals(this.nameValid)) {
            if (this.panel.branchNameField.getText().isEmpty()) {
                this.setErrorMessage(NbBundle.getMessage(CreateBranch.class, (String)"MSG_CreateBranch.errorBranchNameEmpty"));
            } else {
                this.setErrorMessage(NbBundle.getMessage(CreateBranch.class, (String)"MSG_CreateBranch.errorBranchExists"));
            }
        }
        if (flag) {
            this.setErrorMessage(null);
        }
        this.okButton.setEnabled(flag);
        this.dd.setValid(flag);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateName();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateName();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void validateName() {
        this.nameValid = false;
        this.branchName = this.panel.branchNameField.getText();
        if (!this.branchName.isEmpty()) {
            this.nameValid = null;
            this.branchCheckTask.cancel();
            this.branchCheckTask.schedule(500);
        }
        this.validate();
    }

    private void setErrorMessage(String message) {
        this.panel.lblError.setText(message);
        if (message == null || message.isEmpty()) {
            this.panel.lblError.setIcon(null);
        } else {
            this.panel.lblError.setIcon(this.ICON_ERROR);
        }
    }

    private class BranchNameCheckWorker
    implements Runnable {
        private BranchNameCheckWorker() {
        }

        @Override
        public void run() {
            final String branchName = CreateBranch.this.branchName;
            try {
                GitClient client = Git.getInstance().getClient(CreateBranch.this.repository);
                final Map branches = client.getBranches(false, ProgressMonitor.NULL_PROGRESS_MONITOR);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (branchName.equals(((CreateBranch)CreateBranch.this).panel.branchNameField.getText())) {
                            CreateBranch.this.nameValid = !branches.containsKey(branchName);
                            CreateBranch.this.validate();
                        }
                    }
                });
            }
            catch (GitException ex) {
                GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
            }
        }
    }
}

