/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.branch;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.branch.CreateBranch;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.util.NbBundle;

public class CreateBranchAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(CreateBranchAction.class.getName());

    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        this.createBranch(repository, info.getActiveBranch().getName().equals("(no branch)") ? "HEAD" : info.getActiveBranch().getName());
    }

    public void createBranch(File repository, String preselectedRevision) {
        final CreateBranch createBranch = new CreateBranch(repository, preselectedRevision);
        if (createBranch.show()) {
            GitProgressSupport supp = new GitProgressSupport(){

                @Override
                protected void perform() {
                    try {
                        GitClient client = this.getClient();
                        String revision = createBranch.getRevision();
                        LOG.log(Level.FINE, "Creating a branch: {0}", revision);
                        GitBranch branch = client.createBranch(createBranch.getBranchName(), createBranch.getRevision(), (ProgressMonitor)this);
                        this.log(revision, branch);
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                }

                private void log(String revision, GitBranch branch) {
                    OutputLogger logger = this.getLogger();
                    logger.output(NbBundle.getMessage(CreateBranchAction.class, (String)"MSG_CreateBranchAction.branchCreated", (Object[])new Object[]{branch.getName(), revision, branch.getId()}));
                }
            };
            supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(CreateBranchAction.class, (String)"LBL_CreateBranchAction.progressName"));
        }
    }
}

