/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.checkout;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.checkout.AbstractCheckoutRevision;
import org.netbeans.modules.git.ui.checkout.CheckoutRevisionAction;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.netbeans.modules.git.utils.GitUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public abstract class AbstractCheckoutAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(CheckoutRevisionAction.class.getName());

    protected final void checkoutRevision(final File repository, final AbstractCheckoutRevision checkout, String progressLabelKey, HelpCtx helpCtx) {
        if (checkout.show(helpCtx)) {
            GitProgressSupport supp = new GitProgressSupport(){
                private String revision;
                private final Collection<File> notifiedFiles = new HashSet<File>();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void perform() {
                    Set<File> seenRoots = Git.getInstance().getSeenRoots(repository);
                    final HashSet<String> seenPaths = new HashSet<String>(GitUtils.getRelativePaths(repository, seenRoots.toArray(new File[seenRoots.size()])));
                    try {
                        GitClient client = this.getClient();
                        this.revision = checkout.getRevision();
                        if (checkout.isCreateBranchSelected()) {
                            this.revision = checkout.getBranchName();
                            LOG.log(Level.FINE, "Creating branch: {0}:{1}", new Object[]{this.revision, checkout.getRevision()});
                            GitBranch branch = client.createBranch(this.revision, checkout.getRevision(), (ProgressMonitor)this);
                            this.log(checkout.getRevision(), branch);
                        }
                        client.addNotificationListener((NotificationListener)new FileListener(){

                            public void notifyFile(File file, String relativePathToRoot) {
                                if (this.isUnderRoots(relativePathToRoot)) {
                                    notifiedFiles.add(file);
                                }
                            }

                            private boolean isUnderRoots(String relativePathToRoot) {
                                boolean underRoot;
                                boolean bl = underRoot = seenPaths.isEmpty() || seenPaths.contains(relativePathToRoot);
                                if (!underRoot) {
                                    for (String path : seenPaths) {
                                        if (!relativePathToRoot.startsWith(path + "/")) continue;
                                        underRoot = true;
                                        break;
                                    }
                                }
                                return underRoot;
                            }
                        });
                        client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(new File[]{repository}));
                        LOG.log(Level.FINE, "Checking out commit: {0}", this.revision);
                        try {
                            client.checkoutRevision(this.revision, true, (ProgressMonitor)this);
                        }
                        catch (GitException.CheckoutConflictException ex) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.FINE, "Conflicts during checkout: {0} - {1}", new Object[]{repository, Arrays.asList(ex.getConflicts())});
                            }
                            File[] conflicts = this.getFilesInConflict(ex.getConflicts());
                            this.resolveConflicts(conflicts);
                        }
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                    finally {
                        if (!this.notifiedFiles.isEmpty()) {
                            this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                            Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, this.notifiedFiles));
                            GitUtils.headChanged(repository);
                        }
                    }
                }

                private void log(String revision, GitBranch branch) {
                    OutputLogger logger = this.getLogger();
                    logger.output(NbBundle.getMessage(CheckoutRevisionAction.class, (String)"MSG_CheckoutRevisionAction.branchCreated", (Object[])new Object[]{branch.getName(), revision, branch.getId()}));
                }

                private void resolveConflicts(File[] conflicts) throws GitException {
                    JButton merge = new JButton();
                    Mnemonics.setLocalizedText((AbstractButton)merge, (String)NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction.mergeButton.text"));
                    merge.setToolTipText(NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction.mergeButton.TTtext"));
                    merge.setEnabled(false);
                    JButton revert = new JButton();
                    Mnemonics.setLocalizedText((AbstractButton)revert, (String)NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction.revertButton.text"));
                    revert.setToolTipText(NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction.revertButton.TTtext"));
                    JButton review = new JButton();
                    Mnemonics.setLocalizedText((AbstractButton)review, (String)NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction.reviewButton.text"));
                    review.setToolTipText(NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction.reviewButton.TTtext"));
                    Object o = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(CheckoutRevisionAction.class, (String)"MSG_CheckoutRevisionAction.checkoutConflicts"), NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction.checkoutConflicts"), 2, 3, new Object[]{merge, revert, review, NotifyDescriptor.CANCEL_OPTION}, (Object)merge));
                    if (o != merge) {
                        if (o == revert) {
                            GitClient client = this.getClient();
                            LOG.log(Level.FINE, "Checking out paths from HEAD");
                            client.checkout(conflicts, "HEAD", true, (ProgressMonitor)this);
                            LOG.log(Level.FINE, "Cleanup new files");
                            client.clean(conflicts, (ProgressMonitor)this);
                            LOG.log(Level.FINE, "Checking out branch: {0}, second shot", this.revision);
                            client.checkoutRevision(this.revision, true, (ProgressMonitor)this);
                            this.notifiedFiles.addAll(Arrays.asList(conflicts));
                        } else if (o == review) {
                            this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                            GitUtils.openInVersioningView(Arrays.asList(conflicts), repository, this);
                        }
                    }
                }

                private File[] getFilesInConflict(String[] conflicts) {
                    ArrayList<File> files = new ArrayList<File>(conflicts.length);
                    for (String path : conflicts) {
                        files.add(new File(repository, path));
                    }
                    return files.toArray(new File[files.size()]);
                }
            };
            supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(CheckoutRevisionAction.class, (String)progressLabelKey));
        }
    }
}

