/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.checkout;

import java.io.File;
import org.netbeans.modules.git.ui.checkout.AbstractCheckoutAction;
import org.netbeans.modules.git.ui.checkout.AbstractCheckoutRevision;
import org.netbeans.modules.git.ui.checkout.CheckoutRevisionAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.repository.RevisionDialogController;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SwitchBranchAction
extends AbstractCheckoutAction {
    @Override
    protected void performAction(File repository, File[] roots, VCSContext context) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        this.checkoutRevision(repository, info.getActiveBranch().getName().equals("(no branch)") ? "HEAD" : info.getActiveBranch().getName());
    }

    public void checkoutRevision(File repository, String preselectedRevision) {
        this.checkoutRevision(repository, new SwitchBranch(repository, RepositoryInfo.getInstance(repository), preselectedRevision), "LBL_SwitchBranchAction.progressName", new HelpCtx(SwitchBranchAction.class));
    }

    private static class SwitchBranch
    extends AbstractCheckoutRevision {
        public SwitchBranch(File repository, RepositoryInfo info, String initialRevision) {
            super(info, new RevisionDialogController(repository, new File[]{repository}, info.getBranches()));
            this.panel.jLabel1.setText(NbBundle.getMessage(CheckoutRevisionAction.class, (String)"SwitchBranch.jLabel1.text"));
        }

        @Override
        protected String getOkButtonLabel() {
            return NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_SwitchBranch.OKButton.text");
        }

        @Override
        protected String getDialogTitle() {
            return NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_SwitchBranch.title");
        }
    }
}

