/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.commit;

import java.io.File;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.versioning.util.common.VCSCommitOptions;
import org.netbeans.modules.versioning.util.common.VCSFileNode;

public class GitFileNode
extends VCSFileNode<FileInformation> {
    public GitFileNode(File root, File file) {
        super(root, file);
    }

    public FileInformation getInformation() {
        return Git.getInstance().getFileStatusCache().getStatus(this.getFile());
    }

    public VCSCommitOptions getDefaultCommitOption(boolean withExclusions) {
        if (withExclusions && GitModuleConfig.getDefault().isExcludedFromCommit(this.getFile().getAbsolutePath())) {
            return VCSCommitOptions.EXCLUDE;
        }
        if (this.getInformation().containsStatus(FileInformation.STATUS_REMOVED)) {
            return VCSCommitOptions.COMMIT_REMOVE;
        }
        if (this.getInformation().containsStatus(FileInformation.Status.NEW_INDEX_WORKING_TREE)) {
            return GitModuleConfig.getDefault().getExludeNewFiles() ? VCSCommitOptions.EXCLUDE : VCSCommitOptions.COMMIT;
        }
        return VCSCommitOptions.COMMIT;
    }
}

