/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.fetch;

import java.util.Map;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.output.OutputLogger;
import org.openide.util.NbBundle;

abstract class GetRemoteChangesAction
extends SingleRepositoryAction {
    GetRemoteChangesAction() {
    }

    protected void log(Map<String, GitTransportUpdate> updates, OutputLogger logger) {
        if (updates.isEmpty()) {
            logger.output(NbBundle.getMessage(GetRemoteChangesAction.class, (String)"MSG_GetRemoteChangesAction.updates.noChange"));
        } else {
            for (Map.Entry<String, GitTransportUpdate> e : updates.entrySet()) {
                GitTransportUpdate update = e.getValue();
                if (update.getType() == GitTransportUpdate.Type.BRANCH) {
                    logger.output(NbBundle.getMessage(GetRemoteChangesAction.class, (String)"MSG_GetRemoteChangesAction.updates.updateBranch", (Object[])new Object[]{update.getLocalName(), update.getOldObjectId(), update.getNewObjectId(), update.getResult()}));
                    continue;
                }
                logger.output(NbBundle.getMessage(GetRemoteChangesAction.class, (String)"MSG_GetRemoteChangesAction.updates.updateTag", (Object[])new Object[]{update.getLocalName(), update.getResult()}));
            }
        }
    }
}

