/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openide.util.NbBundle;

class Divider
extends JPanel {
    public static final int DIVIDER_CLICKED = 1;
    public static final int DOWN = 0;
    public static final int UP = 1;
    private Color bkg;
    private Color sbkg;
    private Color arrowColor;
    private Color selectedArrowColor;
    private ActionListener listener;
    private int arrowDirection;

    public Divider(ActionListener listener) {
        this.listener = listener;
        this.enableEvents(509L);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.bkg = UIManager.getColor("NbExplorerView.background");
            this.setBackground(this.bkg);
        } else {
            this.bkg = this.getBackground();
        }
        this.sbkg = UIManager.getColor("TextField.selectionBackground");
        this.selectedArrowColor = UIManager.getColor("TextField.selectionForeground");
        this.arrowColor = UIManager.getColor("TextField.inactiveForeground");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(Divider.class, (String)"ACSN_Divider"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Divider.class, (String)"ACSD_Divider"));
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(Integer.MAX_VALUE, 6);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, 6);
    }

    public void setArrowDirection(int direction) {
        this.arrowDirection = direction;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.getID() == 504) {
            this.setBackground(this.sbkg);
            this.repaint();
        }
        if (e.getID() == 505) {
            this.setBackground(this.bkg);
            this.repaint();
        }
        if (e.getID() == 500) {
            this.listener.actionPerformed(new ActionEvent(this, 1, ""));
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension dim = this.getSize();
        if (this.getBackground().equals(this.bkg)) {
            g.setColor(this.arrowColor);
        } else {
            g.setColor(this.selectedArrowColor);
        }
        int mid = dim.width / 2;
        if (this.arrowDirection == 0) {
            g.drawLine(mid - 4, 1, mid + 4, 1);
            g.drawLine(mid - 3, 2, mid + 3, 2);
            g.drawLine(mid - 2, 3, mid + 2, 3);
            g.drawLine(mid - 1, 4, mid + 1, 4);
        } else if (this.arrowDirection == 1) {
            g.drawLine(mid - 4, 4, mid + 4, 4);
            g.drawLine(mid - 3, 3, mid + 3, 3);
            g.drawLine(mid - 2, 2, mid + 2, 2);
            g.drawLine(mid - 1, 1, mid + 1, 1);
        }
    }
}

