/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import org.netbeans.modules.git.ui.history.RepositoryRevision;
import org.netbeans.modules.git.ui.history.RevisionNodeChildren;
import org.netbeans.modules.git.ui.history.SearchHistoryPanel;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

class RevisionNode
extends AbstractNode {
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_DATE = "date";
    static final String COLUMN_NAME_USERNAME = "username";
    static final String COLUMN_NAME_MESSAGE = "message";
    private RepositoryRevision.Event event;
    private RepositoryRevision container;
    private String path;

    public RevisionNode(RepositoryRevision container, SearchHistoryPanel master) {
        super((Children)new RevisionNodeChildren(container, master), Lookups.fixed((Object[])new Object[]{master, container}));
        String name;
        this.container = container;
        this.event = null;
        this.path = null;
        String rev = container.getLog().getRevision();
        String string = name = rev.length() > 7 ? rev.substring(0, 7) : rev;
        if (master.isShowInfo()) {
            name = name + NbBundle.getMessage(RevisionNode.class, (String)"LBL_NumberOfChangedPaths", (Object)container.getEvents().size());
        }
        this.setName(name);
        this.initProperties();
    }

    public RevisionNode(RepositoryRevision.Event revision, SearchHistoryPanel master) {
        super(Children.LEAF, Lookups.fixed((Object[])new Object[]{master, revision}));
        this.path = revision.getPath();
        this.event = revision;
        this.setName(revision.getName());
        this.initProperties();
    }

    RepositoryRevision.Event getRevision() {
        return this.event;
    }

    RepositoryRevision getContainer() {
        return this.container;
    }

    RepositoryRevision.Event getEvent() {
        return this.event;
    }

    public String getShortDescription() {
        return this.path;
    }

    public Action[] getActions(boolean context) {
        return null;
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.put((Node.Property)new DateProperty());
        ps.put((Node.Property)new UsernameProperty());
        ps.put((Node.Property)new MessageProperty());
        sheet.put(ps);
        this.setSheet(sheet);
    }

    private static class RevisionPropertyEditor
    extends PropertyEditorSupport {
        private static final JLabel renderer = new JLabel();

        public RevisionPropertyEditor(Object value) {
            this.setValue(value);
        }

        @Override
        public void paintValue(Graphics gfx, Rectangle box) {
            renderer.setForeground(gfx.getColor());
            Object val = this.getValue();
            if (val instanceof Date) {
                val = DateFormat.getDateTimeInstance().format((Date)val);
            }
            renderer.setText(val.toString());
            renderer.setBounds(box);
            renderer.paint(gfx);
        }

        @Override
        public boolean isPaintable() {
            return true;
        }

        static {
            renderer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }
    }

    private class MessageProperty
    extends CommitNodeProperty {
        public MessageProperty() {
            super(RevisionNode.COLUMN_NAME_MESSAGE, String.class, RevisionNode.COLUMN_NAME_MESSAGE, RevisionNode.COLUMN_NAME_MESSAGE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.event == null) {
                return RevisionNode.this.container.getLog().getFullMessage();
            }
            return "";
        }
    }

    private class DateProperty
    extends CommitNodeProperty {
        public DateProperty() {
            super(RevisionNode.COLUMN_NAME_DATE, String.class, RevisionNode.COLUMN_NAME_DATE, RevisionNode.COLUMN_NAME_DATE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.event == null) {
                return new Date(RevisionNode.this.container.getLog().getCommitTime());
            }
            return "";
        }

        public Class getValueType() {
            return Date.class;
        }
    }

    private class UsernameProperty
    extends CommitNodeProperty {
        public UsernameProperty() {
            super(RevisionNode.COLUMN_NAME_USERNAME, String.class, RevisionNode.COLUMN_NAME_USERNAME, RevisionNode.COLUMN_NAME_USERNAME);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.event == null) {
                return RevisionNode.this.container.getLog().getAuthor();
            }
            return "";
        }
    }

    private abstract class CommitNodeProperty<T>
    extends PropertySupport.ReadOnly<T> {
        protected CommitNodeProperty(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public String toString() {
            try {
                return this.getValue().toString();
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return e.getLocalizedMessage();
            }
        }

        public PropertyEditor getPropertyEditor() {
            try {
                return new RevisionPropertyEditor(this.getValue());
            }
            catch (Exception e) {
                return super.getPropertyEditor();
            }
        }
    }
}

