/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.git.GitModuleConfig;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class SearchCriteriaPanel
extends JPanel {
    private JLabel commitMessageLabel;
    private JLabel fromInfoLabel;
    private JLabel fromLabel;
    private JLabel limitLabel;
    final JCheckBox showMergesChkBox = new JCheckBox();
    private JTextField tfCommitMessage;
    final JTextField tfFrom = new JTextField();
    final JTextField tfLimit = new JTextField();
    final JTextField tfTo = new JTextField();
    private JTextField tfUsername;
    private JLabel toInfoLabel;
    private JLabel toLabel;
    private JLabel usernameLabel;

    public SearchCriteriaPanel() {
        this.initComponents();
    }

    public String getFrom() {
        String s = this.tfFrom.getText().trim();
        if (s.isEmpty()) {
            return null;
        }
        return s;
    }

    public String getTo() {
        String s = this.tfTo.getText().trim();
        if (s.isEmpty()) {
            return null;
        }
        return s;
    }

    public int getLimit() {
        String s = this.tfLimit.getText().trim();
        Integer retval = -1;
        try {
            retval = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            retval = -1;
        }
        if (retval <= 0) {
            retval = -1;
        }
        return retval;
    }

    public String getCommitMessage() {
        String s = this.tfCommitMessage.getText().trim();
        return s.isEmpty() ? null : s;
    }

    public String getUsername() {
        String s = this.tfUsername.getText().trim();
        return s.isEmpty() ? null : s;
    }

    boolean isShowMerges() {
        return this.showMergesChkBox.isSelected();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchCriteriaPanel.this.tfCommitMessage.requestFocusInWindow();
            }
        });
    }

    private void initComponents() {
        this.commitMessageLabel = new JLabel();
        this.tfCommitMessage = new JTextField();
        this.usernameLabel = new JLabel();
        this.tfUsername = new JTextField();
        this.fromLabel = new JLabel();
        this.fromInfoLabel = new JLabel();
        this.toLabel = new JLabel();
        this.toInfoLabel = new JLabel();
        this.limitLabel = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(8, 12, 0, 11));
        this.setLayout(new GridBagLayout());
        this.commitMessageLabel.setLabelFor(this.tfCommitMessage);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/git/ui/history/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.commitMessageLabel, (String)bundle.getString("CTL_UseCommitMessage"));
        this.commitMessageLabel.setToolTipText(bundle.getString("TT_CommitMessage"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        this.add((Component)this.commitMessageLabel, gridBagConstraints);
        this.tfCommitMessage.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.tfCommitMessage, gridBagConstraints);
        this.usernameLabel.setLabelFor(this.tfUsername);
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)bundle.getString("CTL_UseUsername"));
        this.usernameLabel.setToolTipText(bundle.getString("TT_Username"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.usernameLabel, gridBagConstraints);
        this.tfUsername.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 4, 0, 0);
        this.add((Component)this.tfUsername, gridBagConstraints);
        this.fromLabel.setLabelFor(this.tfFrom);
        Mnemonics.setLocalizedText((JLabel)this.fromLabel, (String)bundle.getString("CTL_UseFrom"));
        this.fromLabel.setToolTipText(bundle.getString("TT_From"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.fromLabel, gridBagConstraints);
        this.tfFrom.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.tfFrom, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.fromInfoLabel, (String)bundle.getString("CTL_FromToHint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 2, 0, 4);
        this.add((Component)this.fromInfoLabel, gridBagConstraints);
        this.toLabel.setLabelFor(this.tfTo);
        Mnemonics.setLocalizedText((JLabel)this.toLabel, (String)bundle.getString("CTL_UseTo"));
        this.toLabel.setToolTipText(bundle.getString("TT_To"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.toLabel, gridBagConstraints);
        this.tfTo.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.tfTo, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.toInfoLabel, (String)bundle.getString("CTL_FromToHint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(3, 2, 0, 4);
        this.add((Component)this.toInfoLabel, gridBagConstraints);
        this.limitLabel.setLabelFor(this.tfLimit);
        Mnemonics.setLocalizedText((JLabel)this.limitLabel, (String)bundle.getString("CTL_UseLimit"));
        this.limitLabel.setToolTipText(bundle.getString("TT_Limit"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 21;
        this.add((Component)this.limitLabel, gridBagConstraints);
        this.tfLimit.setColumns(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.tfLimit, gridBagConstraints);
        this.showMergesChkBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.showMergesChkBox, (String)NbBundle.getMessage(SearchCriteriaPanel.class, (String)"CTL_ShowMerge"));
        this.showMergesChkBox.setToolTipText(NbBundle.getMessage(SearchCriteriaPanel.class, (String)"TT_ShowMerges"));
        this.showMergesChkBox.setHorizontalTextPosition(4);
        this.showMergesChkBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                SearchCriteriaPanel.this.showMergesChkBoxStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.add((Component)this.showMergesChkBox, gridBagConstraints);
    }

    private void showMergesChkBoxStateChanged(ChangeEvent evt) {
        GitModuleConfig.getDefault().setShowHistoryMerges(this.showMergesChkBox.isSelected());
    }
}

