/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.status;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.EnumSet;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.ui.actions.AddAction;
import org.netbeans.modules.git.ui.checkout.CheckoutPathsAction;
import org.netbeans.modules.git.ui.checkout.RevertChangesAction;
import org.netbeans.modules.git.ui.commit.CommitAction;
import org.netbeans.modules.git.ui.commit.GitFileNode;
import org.netbeans.modules.git.ui.conflicts.ResolveConflictsAction;
import org.netbeans.modules.git.ui.diff.DiffAction;
import org.netbeans.modules.git.ui.status.GitStatusNode;
import org.netbeans.modules.git.ui.status.VersioningPanelController;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.OpenInEditorAction;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.status.VCSStatusNode;
import org.netbeans.modules.versioning.util.status.VCSStatusTable;
import org.netbeans.modules.versioning.util.status.VCSStatusTableModel;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

class GitStatusTable
extends VCSStatusTable<GitStatusNode> {
    private final VersioningPanelController.ModeKeeper modeKeeper;

    public GitStatusTable(VCSStatusTableModel<GitStatusNode> model, VersioningPanelController.ModeKeeper modeKeeper) {
        super(model);
        this.modeKeeper = modeKeeper;
        this.setDefaultRenderer(new SyncTableCellRenderer());
    }

    protected void setModelProperties() {
        Node.Property[] properties = new Node.Property[]{new VCSStatusTable.ColumnDescriptor("name", String.class, VCSStatusNode.NameProperty.DISPLAY_NAME, VCSStatusNode.NameProperty.DESCRIPTION), new VCSStatusTable.ColumnDescriptor("gitstatus", String.class, GitStatusNode.GitStatusProperty.DISPLAY_NAME, GitStatusNode.GitStatusProperty.DESCRIPTION), new VCSStatusTable.ColumnDescriptor("path", String.class, VCSStatusNode.PathProperty.DISPLAY_NAME, VCSStatusNode.PathProperty.DESCRIPTION)};
        this.tableModel.setProperties(properties);
    }

    protected JPopupMenu getPopup() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = menu.add((Action)new OpenInEditorAction(this.getSelectedFiles()));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        menu.addSeparator();
        item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(CommitAction.class), NbBundle.getMessage(CommitAction.class, (String)"LBL_CommitAction.popupName")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(DiffAction.class), NbBundle.getMessage(DiffAction.class, (String)"LBL_DiffAction_PopupName")){

            public void actionPerformed(ActionEvent e) {
                GitStatusTable.this.modeKeeper.storeMode();
                super.actionPerformed(e);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        GitStatusNode[] selectedNodes = (GitStatusNode[])this.getSelectedNodes();
        boolean displayAdd = false;
        for (GitStatusNode node : selectedNodes) {
            if (!((GitFileNode)node.getFileNode()).getInformation().containsStatus(EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.IN_CONFLICT, FileInformation.Status.MODIFIED_INDEX_WORKING_TREE))) continue;
            displayAdd = true;
        }
        if (displayAdd) {
            item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(AddAction.class), NbBundle.getMessage(AddAction.class, (String)"LBL_AddAction.popupName")));
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        }
        item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(RevertChangesAction.class), NbBundle.getMessage(CheckoutPathsAction.class, (String)"LBL_RevertChangesAction_PopupName")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        item = menu.add((Action)new SystemActionBridge((Action)SystemAction.get(CheckoutPathsAction.class), NbBundle.getMessage(CheckoutPathsAction.class, (String)"LBL_CheckoutPathsAction_PopupName")));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        ResolveConflictsAction a = (ResolveConflictsAction)SystemAction.get(ResolveConflictsAction.class);
        if (a.isEnabled()) {
            menu.addSeparator();
            item = menu.add((Action)new SystemActionBridge((Action)((Object)a), NbBundle.getMessage(ResolveConflictsAction.class, (String)"LBL_ResolveConflictsAction_PopupName")));
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        }
        return menu;
    }

    protected void mouseClicked(VCSStatusNode node) {
        Action action = node.getPreferredAction();
        if (action != null && action.isEnabled()) {
            if (action instanceof DiffAction) {
                this.modeKeeper.storeMode();
            }
            action.actionPerformed(new ActionEvent((Object)this, 1001, node.getFile().getAbsolutePath()));
        }
    }

    private class SyncTableCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private SyncTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer;
            int modelColumnIndex = table.convertColumnIndexToModel(column);
            GitStatusNode node = null;
            if (modelColumnIndex == 0) {
                node = (GitStatusNode)GitStatusTable.this.tableModel.getNode(table.convertRowIndexToModel(row));
                if (!isSelected) {
                    value = node.getHtmlDisplayName();
                }
                if (GitModuleConfig.getDefault().isExcludedFromCommit(node.getFile().getAbsolutePath())) {
                    value = "<s>" + value + "</s>";
                }
                value = "<html>" + value;
            }
            if ((renderer = modelColumnIndex == 2 ? this.pathRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JComponent) {
                if (node == null) {
                    node = (GitStatusNode)GitStatusTable.this.tableModel.getNode(table.convertRowIndexToModel(row));
                }
                String path = node.getFile().getAbsolutePath();
                ((JComponent)renderer).setToolTipText(path);
            }
            return renderer;
        }
    }
}

