/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.model.services;

import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.openide.util.Lookup;

public abstract class CodeModelProblemResolver {
    private static final CodeModelProblemResolver DEFAULT = new Default();

    protected CodeModelProblemResolver() {
    }

    public static ParsingProblemDetector getParsingProblemDetector(CsmProject project) {
        return DEFAULT.createResolver(project);
    }

    public abstract ParsingProblemDetector createResolver(CsmProject var1);

    private static final class Default
    extends CodeModelProblemResolver {
        private final Lookup.Result<CodeModelProblemResolver> res = Lookup.getDefault().lookupResult(CodeModelProblemResolver.class);

        Default() {
        }

        @Override
        public ParsingProblemDetector createResolver(CsmProject project) {
            for (CodeModelProblemResolver service : this.res.allInstances()) {
                ParsingProblemDetector createResolver = service.createResolver(project);
                if (createResolver == null) continue;
                return createResolver;
            }
            return null;
        }
    }

    public static interface ParsingProblemDetector {
        public void start();

        public void switchToDeterminate(int var1);

        public void finish();

        public String nextCsmFile(CsmFile var1, int var2, int var3);

        public String getRemainingTime();
    }
}

