/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.palette;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public final class ImportPaletteFolderPanel
extends JPanel {
    private static String s_lastSelection = "";
    private File m_folder = null;
    private String m_lastValue = "";
    private ButtonGroup buttonGroup1;
    private JTextField displayNameTextField;
    private JTextField folderTextField;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public ImportPaletteFolderPanel() {
        this.initComponents();
        this.folderTextField.setText(s_lastSelection);
    }

    public File getFolder() {
        return new File(this.folderTextField.getText());
    }

    public String getDisplayName() {
        String dName = this.displayNameTextField.getText();
        return dName.length() > 0 ? dName : this.folderTextField.getText();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.displayNameTextField = new JTextField();
        this.folderTextField = new JTextField();
        this.jButton1 = new JButton();
        this.jLabel1.setText("Display name:");
        this.jLabel1.setToolTipText("Display name of the new palette category");
        this.jLabel2.setText("Folder:");
        this.jLabel2.setToolTipText("Folder containing SVG images to import");
        this.jButton1.setText("Browse ...");
        this.jButton1.setToolTipText("Locate the folder");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImportPaletteFolderPanel.this.browseFolder(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(45, 45, 45).addComponent(this.folderTextField, -1, 366, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.displayNameTextField, -1, 350, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jButton1).addComponent(this.folderTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.displayNameTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void browseFolder(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser(this.folderTextField.getText());
        chooser.setFileSelectionMode(1);
        int r = chooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(ImportPaletteFolderPanel.class, (String)"LBL_Select"));
        if (r == 0) {
            File file = chooser.getSelectedFile();
            if (!file.isDirectory()) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ImportPaletteFolderPanel.class, (String)"ERROR_NotDirectory", (Object)file), 2));
                return;
            }
            this.m_folder = file;
            String value = this.m_folder.getAbsoluteFile().toString();
            this.folderTextField.setText(value);
            if (this.m_lastValue.equals(this.displayNameTextField.getText())) {
                this.displayNameTextField.setText(value);
            }
            s_lastSelection = this.m_lastValue = value;
        }
    }
}

