/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.folding;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.cnd.editor.folding.CppFile;
import org.netbeans.modules.cnd.editor.folding.CppFoldManagerBase;
import org.netbeans.modules.cnd.editor.folding.CppMetaModel;
import org.netbeans.modules.cnd.editor.folding.ParsingEvent;
import org.netbeans.modules.cnd.editor.folding.ParsingListener;
import org.netbeans.modules.cnd.editor.parser.CppFoldRecord;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldManagerFactory;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.RequestProcessor;

final class CppFoldManager
extends CppFoldManagerBase
implements Runnable,
ParsingListener {
    private FoldOperation operation;
    private List<BlockFoldInfo> blockFoldInfos = Collections.emptyList();
    private boolean foldIncludesPreset;
    private boolean foldCommentPreset;
    private boolean foldCodeBlocksPreset;
    private boolean foldInitialCommentsPreset;
    private boolean listeningOnParsing;
    private static RequestProcessor cppFoldsRP;
    private static final Logger log;

    private CppFoldManager() {
    }

    private static synchronized RequestProcessor getCppFoldsRP() {
        if (cppFoldsRP == null) {
            cppFoldsRP = new RequestProcessor("CPP-Folds", 1);
        }
        return cppFoldsRP;
    }

    private String getFilename() {
        FoldHierarchy h = this.operation != null ? this.operation.getHierarchy() : null;
        JTextComponent comp = h != null ? h.getComponent() : null;
        Document doc = comp != null ? comp.getDocument() : null;
        DataObject dob = doc != null ? NbEditorUtilities.getDataObject((Document)doc) : null;
        String path = dob != null ? FileUtil.getFileDisplayName((FileObject)dob.getPrimaryFile()) : null;
        return path;
    }

    private String getShortName() {
        String longname = (String)this.getDocument().getProperty("title");
        int slash = longname.lastIndexOf(File.separatorChar);
        if (slash != -1) {
            return longname.substring(slash + 1);
        }
        return longname;
    }

    private FoldOperation getOperation() {
        return this.operation;
    }

    private void removeFoldNotify(Fold fold) {
        log.log(Level.FINE, "CppFoldManager.removeFoldNotify");
    }

    private synchronized void updateFolds() {
        UpdateFoldsRequest request;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "CFM.updateFolds: Processing {0} [{1}]", new Object[]{this.getShortName(), Thread.currentThread().getName()});
        }
        if ((request = this.collectFoldUpdates()) == null) {
            return;
        }
        Runnable hierarchyUpdate = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!CppFoldManager.this.getOperation().isReleased()) {
                    Document doc = CppFoldManager.this.getDocument();
                    if (!(doc instanceof AbstractDocument)) {
                        return;
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "CFM.updateFolds$X1.run: Processing {0} [{1}]", new Object[]{CppFoldManager.this.getShortName(), Thread.currentThread().getName()});
                    }
                    AbstractDocument adoc = (AbstractDocument)doc;
                    adoc.readLock();
                    try {
                        FoldHierarchy hierarchy = CppFoldManager.this.getOperation().getHierarchy();
                        hierarchy.lock();
                        try {
                            FoldHierarchyTransaction t = CppFoldManager.this.getOperation().openTransaction();
                            try {
                                if (log.isLoggable(Level.FINE)) {
                                    log.log(Level.FINE, "CFM.updateFolds$X1.run: Calling processUpdateFoldRequest for {0} [{1}]", new Object[]{CppFoldManager.this.getShortName(), Thread.currentThread().getName()});
                                }
                                CppFoldManager.this.processUpdateFoldRequest(request, t);
                            }
                            finally {
                                t.commit();
                            }
                        }
                        finally {
                            hierarchy.unlock();
                        }
                    }
                    finally {
                        adoc.readUnlock();
                    }
                }
            }
        };
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "CFM.updateFolds: Starting update for {0} on AWT thread", this.getShortName());
        }
        SwingUtilities.invokeLater(hierarchyUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateFoldsRequest collectFoldUpdates() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "CFM.collectFoldUpdates: Processing {0} [{1}]", new Object[]{this.getShortName(), Thread.currentThread().getName()});
        }
        Document doc = this.getDocument();
        if (this.getOperation().isReleased() || !(doc instanceof AbstractDocument)) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "CFM.collectFoldUpdates: No doc found for {0}", this.getShortName());
            }
            return null;
        }
        CppFile cpf = CppMetaModel.getDefault().get(doc.getProperty("title").toString());
        if (cpf == null) {
            return null;
        }
        cpf.waitScanFinished(1);
        if (cpf.isParsingFailed()) {
            return null;
        }
        UpdateFoldsRequest request = new UpdateFoldsRequest();
        AbstractDocument adoc = (AbstractDocument)doc;
        adoc.readLock();
        try {
            request.addBlockFoldInfo(cpf.getInitialCommentFold());
            for (CppFoldRecord rec : cpf.getIncludesFolds()) {
                request.addBlockFoldInfo(rec);
            }
            for (CppFoldRecord rec : cpf.getBlockFolds()) {
                request.addBlockFoldInfo(rec);
            }
        }
        finally {
            adoc.readUnlock();
        }
        return request;
    }

    private void processUpdateFoldRequest(UpdateFoldsRequest request, FoldHierarchyTransaction transaction) {
        if (request != null && request.isValid()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "CFM.processUpdateFoldRequest: Processing {0} [{1}]", new Object[]{this.getShortName(), Thread.currentThread().getName()});
            }
            LinkedHashMap<BlockFoldInfo, BlockFoldInfo> map = new LinkedHashMap<BlockFoldInfo, BlockFoldInfo>();
            for (BlockFoldInfo info : this.blockFoldInfos) {
                info.recalcHashCode();
                map.put(info, info);
            }
            List<BlockFoldInfo> infoList = request.getBlockFoldInfos();
            for (BlockFoldInfo blockFoldInfo : infoList) {
                blockFoldInfo.recalcHashCode();
                BlockFoldInfo orig = (BlockFoldInfo)map.get(blockFoldInfo);
                if (orig == null || blockFoldInfo.isUpdateRequired(orig)) {
                    if (orig != null) {
                        orig.removeFromHierarchy(transaction);
                        map.remove(blockFoldInfo);
                    }
                    try {
                        blockFoldInfo.addToHierarchy(transaction);
                    }
                    catch (BadLocationException e) {}
                    continue;
                }
                map.remove(blockFoldInfo);
                blockFoldInfo.fold = orig.fold;
            }
            for (Map.Entry entry : map.entrySet()) {
                ((BlockFoldInfo)entry.getKey()).removeFromHierarchy(transaction);
            }
            this.blockFoldInfos = infoList;
        }
    }

    Document getDocument() {
        return this.getOperation().getHierarchy().getComponent().getDocument();
    }

    DataObject getDataObject() {
        Document doc = this.getDocument();
        return doc != null ? NbEditorUtilities.getDataObject((Document)doc) : null;
    }

    @Override
    public void run() {
        try {
            if (new File(this.getFilename()).exists()) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "CFM.run: Processing {0} [{1}]", new Object[]{this.getShortName(), Thread.currentThread().getName()});
                }
                if (!this.listeningOnParsing) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "CFM.run: Processing {0} [{1}]", new Object[]{this.getShortName(), Thread.currentThread().getName()});
                    }
                    this.listeningOnParsing = true;
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "CFM.run: Starting WeakParsingListener [{0}]", Thread.currentThread().getName());
                    }
                    new WeakParsingListener(this).startListening();
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "CFM.run: Calling updateFolds [{0}]", Thread.currentThread().getName());
                }
                this.updateFolds();
            }
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Throwable t) {
            ErrorManager.getDefault().notify(t);
        }
    }

    public void init(FoldOperation operation) {
        Preferences prefs;
        String contentType;
        this.operation = operation;
        BaseKit kit = Utilities.getKit((JTextComponent)operation.getHierarchy().getComponent());
        if (kit instanceof NbEditorKit && (contentType = ((NbEditorKit)kit).getContentType()) != null && (prefs = (Preferences)MimeLookup.getLookup((String)contentType).lookup(Preferences.class)) != null) {
            this.foldInitialCommentsPreset = prefs.getBoolean("code-folding-collapse-initial-comment", false);
            this.foldIncludesPreset = prefs.getBoolean("code-folding-collapse-import", false);
            this.foldCodeBlocksPreset = prefs.getBoolean("code-folding-collapse-method", false);
            this.foldCommentPreset = prefs.getBoolean("code-folding-collapse-javadoc", false);
        }
    }

    public void initFolds(FoldHierarchyTransaction transaction) {
        if (this.getFilename() != null && this.getFilename().length() > 0) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "CFM.initFolds: Posting for {0} on Cpp Folds RP [{1}]", new Object[]{this.getShortName(), Thread.currentThread().getName()});
            }
            CppFoldManager.getCppFoldsRP().post((Runnable)this, 1000, 1);
        }
    }

    private void scheduleParsing(Document doc) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "TitleProperty: {0}", doc.getProperty("title"));
        }
        if (doc.getProperty("title") != null) {
            CppMetaModel.getDefault().scheduleParsing(doc);
        }
    }

    public void insertUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "FoldManager.insertUpdate: {0}", evt.getDocument().toString());
        }
        this.scheduleParsing(evt.getDocument());
    }

    public void removeUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
        log.log(Level.FINE, "FoldManager.removeUpdate");
        this.scheduleParsing(evt.getDocument());
    }

    public void changedUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
        log.log(Level.FINE, "FoldManager.changeUpdate");
    }

    private void removeFoldInfo(Fold fold) {
        Iterator<BlockFoldInfo> iter = this.blockFoldInfos.iterator();
        while (iter.hasNext()) {
            if (iter.next().fold != fold) continue;
            iter.remove();
            break;
        }
    }

    public void removeEmptyNotify(Fold emptyFold) {
        this.removeFoldNotify(emptyFold);
        this.removeFoldInfo(emptyFold);
    }

    public void removeDamagedNotify(Fold damagedFold) {
        this.removeFoldNotify(damagedFold);
        this.removeFoldInfo(damagedFold);
    }

    public void expandNotify(Fold expandedFold) {
    }

    public void release() {
    }

    @Override
    public void objectParsed(ParsingEvent evt) {
        FileObject primaryFile;
        DataObject dob = (DataObject)evt.getSource();
        String path = this.getFilename();
        if (dob != null && (primaryFile = dob.getPrimaryFile()) != null) {
            String pfile = FileUtil.getFileDisplayName((FileObject)primaryFile);
            if (pfile.equals(path)) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "CFM.objectParsed: Calling updateFolds for {0}", this.getShortName());
                }
                this.updateFolds();
            } else {
                log.log(Level.FINE, "CFM.objectParsed: Skipping updateFolds");
            }
        }
    }

    static {
        log = Logger.getLogger(CppFoldManager.class.getName());
    }

    public static final class Factory
    implements FoldManagerFactory {
        public FoldManager createFoldManager() {
            return new CppFoldManager();
        }
    }

    private static final class WeakParsingListener
    implements ParsingListener {
        private WeakReference<ParsingListener> ref;

        WeakParsingListener(ParsingListener listener) {
            this.ref = new WeakReference<ParsingListener>(listener);
        }

        public void startListening() {
            CppMetaModel.getDefault().addParsingListener(this);
        }

        @Override
        public void objectParsed(ParsingEvent evt) {
            ParsingListener listener = (ParsingListener)this.ref.get();
            if (listener != null) {
                listener.objectParsed(evt);
            } else {
                CppMetaModel.getDefault().removeParsingListener(this);
            }
        }
    }

    private final class BlockFoldInfo {
        private Fold fold = null;
        private final CppFoldManagerBase.FoldTemplate template;
        private int hash = 0;
        private final boolean collapse;
        private final int startOffset;
        private final int endOffset;

        public BlockFoldInfo(CppFoldRecord fi) throws BadLocationException {
            this.startOffset = fi.getStartOffset();
            this.endOffset = fi.getEndOffset();
            switch (fi.getType()) {
                case 1: {
                    this.template = CppFoldManagerBase.INITIAL_COMMENT_FOLD_TEMPLATE;
                    this.collapse = CppFoldManager.this.foldInitialCommentsPreset;
                    break;
                }
                case 4: {
                    this.template = CppFoldManagerBase.INCLUDES_FOLD_TEMPLATE;
                    this.collapse = CppFoldManager.this.foldIncludesPreset;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    this.template = CppFoldManagerBase.CODE_BLOCK_FOLD_TEMPLATE;
                    this.collapse = CppFoldManager.this.foldCodeBlocksPreset;
                    break;
                }
                case 2: {
                    this.template = CppFoldManagerBase.COMMENT_FOLD_TEMPLATE;
                    this.collapse = CppFoldManager.this.foldCommentPreset;
                    break;
                }
                case 3: {
                    this.template = CppFoldManagerBase.LINE_COMMENT_FOLD_TEMPLATE;
                    this.collapse = false;
                    break;
                }
                case 5: {
                    this.template = CppFoldManagerBase.IFDEF_FOLD_TEMPLATE;
                    this.collapse = false;
                    break;
                }
                default: {
                    assert (false) : "unsupported block type " + fi;
                    this.collapse = false;
                    this.template = null;
                }
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BlockFoldInfo)) {
                return false;
            }
            BlockFoldInfo other = (BlockFoldInfo)obj;
            return this.template == other.template && this.getRealStartOffset() == other.getRealStartOffset();
        }

        private void recalcHashCode() {
            this.hash = 0;
            this.hashCode();
        }

        public int hashCode() {
            if (this.hash == 0) {
                int aHash = 7;
                aHash = 59 * aHash + (this.template != null ? this.template.hashCode() : 0);
                this.hash = aHash = 59 * aHash + this.getRealStartOffset();
            }
            return this.hash;
        }

        public boolean isUpdateRequired(BlockFoldInfo orig) {
            assert (this.equals(orig)) : "only equal orig can be here";
            return orig.fold == null || this.getRealEndOffset() != orig.getRealEndOffset();
        }

        private int getRealStartOffset() {
            if (this.fold != null) {
                return this.fold.getStartOffset();
            }
            return this.startOffset;
        }

        private int getRealEndOffset() {
            if (this.fold != null) {
                return this.fold.getEndOffset();
            }
            return this.endOffset;
        }

        public void addToHierarchy(FoldHierarchyTransaction transaction) throws BadLocationException {
            if (FoldOperation.isBoundsValid((int)this.startOffset, (int)this.endOffset, (int)this.template.getStartGuardedLength(), (int)this.template.getEndGuardedLength())) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "CFM.BlockFoldInfo.updateHierarchy: Creating fold at ({0}, {1})", new Object[]{this.startOffset, this.endOffset});
                }
                this.fold = CppFoldManager.this.getOperation().addToHierarchy(this.template.getType(), this.template.getDescription(), this.collapse, this.startOffset, this.endOffset, this.template.getStartGuardedLength(), this.template.getEndGuardedLength(), (Object)this, transaction);
            }
        }

        public void removeFromHierarchy(FoldHierarchyTransaction transaction) {
            FoldOperation fo;
            if (this.fold != null && (fo = CppFoldManager.this.getOperation()).isAddedOrBlocked(this.fold)) {
                fo.removeFromHierarchy(this.fold, transaction);
            }
        }

        public String toString() {
            return "BlockFoldInfo:" + this.template.getType() + " at[" + this.getRealStartOffset() + "," + this.getRealEndOffset() + "]";
        }
    }

    private final class UpdateFoldsRequest {
        private final Document creationTimeDoc;
        private final List<BlockFoldInfo> blockFoldInfos = new LinkedList<BlockFoldInfo>();

        UpdateFoldsRequest() {
            this.creationTimeDoc = CppFoldManager.this.getDocument();
        }

        boolean isValid() {
            return this.creationTimeDoc != null && this.creationTimeDoc == CppFoldManager.this.getDocument();
        }

        List<BlockFoldInfo> getBlockFoldInfos() {
            return this.blockFoldInfos;
        }

        void addBlockFoldInfo(CppFoldRecord foldRecord) {
            block3: {
                if (foldRecord != null) {
                    try {
                        this.blockFoldInfos.add(new BlockFoldInfo(foldRecord));
                    }
                    catch (BadLocationException ex) {
                        if (!log.isLoggable(Level.FINE)) break block3;
                        log.log(Level.FINE, "CFM.addBlockFoldInfo: Got BadLocationException\n    {0}", ex.getMessage());
                    }
                }
            }
        }
    }
}

