/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import java.awt.Component;
import java.beans.DesignMode;
import java.beans.beancontext.BeanContextChildComponentProxy;
import java.util.prefs.Preferences;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Session;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.DebuggerEngineProvider;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class JavaEngineProvider
extends DebuggerEngineProvider {
    private DebuggerEngine.Destructor desctuctor;
    private Session session;
    private RequestProcessor jpdaRP = new RequestProcessor("JPDA Debugger", 5);

    public JavaEngineProvider(ContextProvider contextProvider) {
        this.session = (Session)contextProvider.lookupFirst(null, Session.class);
    }

    public String[] getLanguages() {
        return new String[]{"Java"};
    }

    public String getEngineTypeID() {
        return "netbeans-JPDASession/Java";
    }

    public Object[] getServices() {
        Object[] components = JavaEngineProvider.getUIComponentProxies();
        Object[] services = new Object[components.length + 1];
        System.arraycopy(components, 0, services, 0, components.length);
        services[components.length] = this.jpdaRP;
        return services;
    }

    static Object[] getUIComponentProxies() {
        class ComponentProxy
        implements BeanContextChildComponentProxy,
        DesignMode {
            private String name;
            private boolean openByDefault;

            ComponentProxy(String name, boolean openByDefault) {
                this.name = name;
                this.openByDefault = openByDefault;
            }

            @Override
            public Component getComponent() {
                return WindowManager.getDefault().findTopComponent(this.name);
            }

            @Override
            public boolean isDesignTime() {
                return this.openByDefault;
            }

            @Override
            public void setDesignTime(boolean designTime) {
                throw new UnsupportedOperationException("Not supported.");
            }
        }
        class WatchesComponentProxy
        extends ComponentProxy {
            WatchesComponentProxy(String name, boolean openByDefault) {
                super(name, openByDefault);
            }

            @Override
            public boolean isDesignTime() {
                Preferences preferences = NbPreferences.forModule(ContextProvider.class).node("variables_view");
                return !preferences.getBoolean("show_watches", true);
            }
        }
        return new Object[]{new ComponentProxy("localsView", true), new WatchesComponentProxy("watchesView", true), new ComponentProxy("breakpointsView", true), new ComponentProxy("debugging", true), new ComponentProxy("evaluator", false), new ComponentProxy("resultsView", false), new ComponentProxy("callstackView", false), new ComponentProxy("sessionsView", false), new ComponentProxy("sources", false), new ComponentProxy("threadsView", false), new ComponentProxy("classes", false)};
    }

    public void setDestructor(DebuggerEngine.Destructor desctuctor) {
        this.desctuctor = desctuctor;
    }

    public DebuggerEngine.Destructor getDestructor() {
        return this.desctuctor;
    }

    public Session getSession() {
        return this.session;
    }

    RequestProcessor getRequestProcessor() {
        return this.jpdaRP;
    }
}

