/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.openide.util.Exceptions;

public class SourcePath {
    private ContextProvider lookupProvider;
    private SourcePathProvider contextProvider;
    private JPDADebugger debugger;

    public SourcePath(ContextProvider lookupProvider) {
        this.lookupProvider = lookupProvider;
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
    }

    public SourcePathProvider getContext() {
        if (this.contextProvider == null) {
            List l = this.lookupProvider.lookup(null, SourcePathProvider.class);
            this.contextProvider = (SourcePathProvider)l.get(0);
            int k = l.size();
            for (int i = 1; i < k; ++i) {
                this.contextProvider = new CompoundContextProvider((SourcePathProvider)l.get(i), this.contextProvider);
            }
        }
        return this.contextProvider;
    }

    public String getRelativePath(String url, char directorySeparator, boolean includeExtension) {
        return this.getContext().getRelativePath(url, directorySeparator, includeExtension);
    }

    public String getSourceRoot(String url) {
        return this.getContext().getSourceRoot(url);
    }

    public String getURL(String relativePath, boolean global) {
        String url = this.getContext().getURL(relativePath, global);
        if (url != null) {
            try {
                new URL(url);
            }
            catch (MalformedURLException muex) {
                Logger.getLogger(SourcePath.class.getName()).log(Level.WARNING, "Malformed URL '" + url + "' produced by " + this.getContext(), muex);
                return null;
            }
        }
        return url;
    }

    public String getURL(StackFrame sf, String stratumn) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper, ObjectCollectedExceptionWrapper {
        try {
            return this.getURL(SourcePath.convertSlash(LocationWrapper.sourcePath(StackFrameWrapper.location(sf), stratumn)), true);
        }
        catch (AbsentInformationException e) {
            return this.getURL(SourcePath.convertClassNameToRelativePath(ReferenceTypeWrapper.name(LocationWrapper.declaringType(StackFrameWrapper.location(sf)))), true);
        }
    }

    public String getURL(Location loc, String stratumn) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ObjectCollectedExceptionWrapper {
        try {
            return this.getURL(SourcePath.convertSlash(LocationWrapper.sourcePath(loc, stratumn)), true);
        }
        catch (AbsentInformationException e) {
            return this.getURL(SourcePath.convertClassNameToRelativePath(ReferenceTypeWrapper.name(LocationWrapper.declaringType(loc))), true);
        }
    }

    public String[] getSourceRoots() {
        return this.getContext().getSourceRoots();
    }

    public void setSourceRoots(String[] sourceRoots) {
        this.getContext().setSourceRoots(sourceRoots);
    }

    public String[] getOriginalSourceRoots() {
        return this.getContext().getOriginalSourceRoots();
    }

    public String[] getProjectSourceRoots() {
        try {
            Method getProjectSourceRootsMethod = this.getContext().getClass().getMethod("getProjectSourceRoots", new Class[0]);
            String[] projectSourceRoots = (String[])getProjectSourceRootsMethod.invoke((Object)this.getContext(), new Object[0]);
            return projectSourceRoots;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new String[0];
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getContext().addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getContext().removePropertyChangeListener(l);
    }

    private static String convertSlash(String original) {
        return original.replace(File.separatorChar, '/');
    }

    public static String convertClassNameToRelativePath(String className) {
        int i = className.indexOf(36);
        if (i > 0) {
            className = className.substring(0, i);
        }
        String sourceName = className.replace('.', '/') + ".java";
        return sourceName;
    }

    private static class CompoundContextProvider
    extends SourcePathProvider {
        private SourcePathProvider cp1;
        private SourcePathProvider cp2;

        CompoundContextProvider(SourcePathProvider cp1, SourcePathProvider cp2) {
            this.cp1 = cp1;
            this.cp2 = cp2;
        }

        public String getURL(String relativePath, boolean global) {
            String p1 = this.cp1.getURL(relativePath, global);
            if (p1 != null) {
                try {
                    new URL(p1);
                    return p1;
                }
                catch (MalformedURLException muex) {
                    Logger.getLogger(SourcePath.class.getName()).log(Level.WARNING, "Malformed URL '" + p1 + "' produced by " + this.cp1, muex);
                }
            }
            if ((p1 = this.cp2.getURL(relativePath, global)) != null) {
                try {
                    new URL(p1);
                }
                catch (MalformedURLException muex) {
                    Logger.getLogger(SourcePath.class.getName()).log(Level.WARNING, "Malformed URL '" + p1 + "' produced by " + this.cp2, muex);
                    p1 = null;
                }
            }
            return p1;
        }

        public String getRelativePath(String url, char directorySeparator, boolean includeExtension) {
            String p1 = this.cp1.getRelativePath(url, directorySeparator, includeExtension);
            if (p1 != null) {
                return p1;
            }
            return this.cp2.getRelativePath(url, directorySeparator, includeExtension);
        }

        public String getSourceRoot(String url) {
            String sourceRoot = this.cp1.getSourceRoot(url);
            if (sourceRoot == null) {
                sourceRoot = this.cp2.getSourceRoot(url);
            }
            return sourceRoot;
        }

        public String[] getSourceRoots() {
            String[] fs1 = this.cp1.getSourceRoots();
            String[] fs2 = this.cp2.getSourceRoots();
            String[] fs = new String[fs1.length + fs2.length];
            System.arraycopy(fs1, 0, fs, 0, fs1.length);
            System.arraycopy(fs2, 0, fs, fs1.length, fs2.length);
            return fs;
        }

        public String[] getOriginalSourceRoots() {
            String[] fs1 = this.cp1.getOriginalSourceRoots();
            String[] fs2 = this.cp2.getOriginalSourceRoots();
            String[] fs = new String[fs1.length + fs2.length];
            System.arraycopy(fs1, 0, fs, 0, fs1.length);
            System.arraycopy(fs2, 0, fs, fs1.length, fs2.length);
            return fs;
        }

        public String[] getProjectSourceRoots() {
            String[] projectSourceRoots2;
            String[] projectSourceRoots1;
            Method getProjectSourceRootsMethod;
            try {
                getProjectSourceRootsMethod = this.cp1.getClass().getMethod("getProjectSourceRoots", new Class[0]);
                projectSourceRoots1 = (String[])getProjectSourceRootsMethod.invoke((Object)this.cp1, new Object[0]);
            }
            catch (Exception ex) {
                projectSourceRoots1 = new String[]{};
            }
            try {
                getProjectSourceRootsMethod = this.cp2.getClass().getMethod("getProjectSourceRoots", new Class[0]);
                projectSourceRoots2 = (String[])getProjectSourceRootsMethod.invoke((Object)this.cp2, new Object[0]);
            }
            catch (Exception ex) {
                projectSourceRoots2 = new String[]{};
            }
            if (projectSourceRoots1.length == 0) {
                return projectSourceRoots2;
            }
            if (projectSourceRoots2.length == 0) {
                return projectSourceRoots1;
            }
            String[] projectSourceRoots = new String[projectSourceRoots1.length + projectSourceRoots2.length];
            System.arraycopy(projectSourceRoots1, 0, projectSourceRoots, 0, projectSourceRoots1.length);
            System.arraycopy(projectSourceRoots2, 0, projectSourceRoots, projectSourceRoots1.length, projectSourceRoots2.length);
            return projectSourceRoots;
        }

        public void setSourceRoots(String[] sourceRoots) {
            this.cp1.setSourceRoots(sourceRoots);
            this.cp2.setSourceRoots(sourceRoots);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.cp1.addPropertyChangeListener(l);
            this.cp2.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.cp1.removePropertyChangeListener(l);
            this.cp2.removePropertyChangeListener(l);
        }

        public String toString() {
            return "CompoundContextProvider[" + this.cp1.toString() + ", " + this.cp2.toString() + "]";
        }
    }
}

