/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.EventRequest;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.UnsupportedOperationExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.event.ClassPrepareEventWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.ClassPrepareRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.ClassUnloadRequestWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;

public class ClassBreakpointImpl
extends ClassBasedBreakpoint {
    private ClassLoadUnloadBreakpoint breakpoint;

    public ClassBreakpointImpl(ClassLoadUnloadBreakpoint breakpoint, JPDADebuggerImpl debugger, Session session) {
        super((JPDABreakpoint)breakpoint, debugger, session);
        this.breakpoint = breakpoint;
        this.set();
    }

    @Override
    protected void setRequests() {
        this.setClassRequests(this.breakpoint.getClassFilters(), this.breakpoint.getClassExclusionFilters(), this.breakpoint.getBreakpointType(), false);
    }

    @Override
    protected EventRequest createEventRequest(EventRequest oldRequest) throws VMDisconnectedExceptionWrapper, InternalExceptionWrapper {
        if (oldRequest instanceof ClassPrepareRequest) {
            int i;
            ClassPrepareRequest cpr = EventRequestManagerWrapper.createClassPrepareRequest(this.getEventRequestManager());
            String[] classFilters = this.breakpoint.getClassFilters();
            int k = classFilters.length;
            for (i = 0; i < k; ++i) {
                ClassPrepareRequestWrapper.addClassFilter(cpr, classFilters[i]);
            }
            String[] classExclusionFilters = this.breakpoint.getClassExclusionFilters();
            k = classExclusionFilters.length;
            for (i = 0; i < k; ++i) {
                ClassPrepareRequestWrapper.addClassExclusionFilter(cpr, classExclusionFilters[i]);
            }
            return cpr;
        }
        if (oldRequest instanceof ClassUnloadRequest) {
            int i;
            ClassUnloadRequest cur = EventRequestManagerWrapper.createClassUnloadRequest(this.getEventRequestManager());
            String[] classFilters = this.breakpoint.getClassFilters();
            int k = classFilters.length;
            for (i = 0; i < k; ++i) {
                ClassUnloadRequestWrapper.addClassFilter(cur, classFilters[i]);
            }
            String[] classExclusionFilters = this.breakpoint.getClassExclusionFilters();
            k = classExclusionFilters.length;
            for (i = 0; i < k; ++i) {
                ClassUnloadRequestWrapper.addClassExclusionFilter(cur, classExclusionFilters[i]);
            }
            return cur;
        }
        return null;
    }

    @Override
    public boolean exec(Event event) {
        if (event instanceof ClassPrepareEvent) {
            try {
                ThreadReference thread = ClassPrepareEventWrapper.thread((ClassPrepareEvent)event);
                ReferenceType type = ClassPrepareEventWrapper.referenceType((ClassPrepareEvent)event);
                try {
                    return this.perform(event, thread, type, ReferenceTypeWrapper.classObject(type));
                }
                catch (UnsupportedOperationExceptionWrapper ex) {
                    return this.perform(event, thread, type, null);
                }
            }
            catch (InternalExceptionWrapper e) {
                return false;
            }
            catch (VMDisconnectedExceptionWrapper e) {
                return false;
            }
            catch (ObjectCollectedExceptionWrapper e) {
                return false;
            }
        }
        return this.perform(event, null, null, null);
    }

    @Override
    public boolean processCondition(Event event) {
        return true;
    }
}

