/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.multiview;

import java.awt.EventQueue;
import java.io.Serializable;
import java.util.Collections;
import java.util.logging.Logger;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.design.multiview.ShowComponentCookie;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.DataEditorSupport;
import org.openide.util.Exceptions;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public class MultiViewSupport
implements OpenCookie,
EditCookie {
    static final long serialVersionUID = 1L;
    private DataObject dataObject;
    private Service service;
    public static String SOURCE_UNSAFE_CLOSE = "SOURCE_UNSAFE_CLOSE";
    public static final String DESIGN_VIEW_ID = "webservice-designview";
    public static final String SOURCE_VIEW_ID = "webservice-sourceview";
    static Logger l = Logger.getLogger(MultiViewSupport.class.getName());

    public MultiViewSupport() {
    }

    public MultiViewSupport(Service service, DataObject dataObject) {
        this.dataObject = dataObject;
        this.service = service;
        this.initWsdlDO();
    }

    public void open() {
        this.view(View.DESIGN, new Object[0]);
    }

    public void edit() {
        this.view(View.SOURCE, new Object[0]);
    }

    public void preview() {
        this.view(View.PREVIEW, new Object[0]);
    }

    DataObject getDataObject() {
        return this.dataObject;
    }

    private DataEditorSupport getEditorSupport() {
        return (DataEditorSupport)this.dataObject.getLookup().lookup(DataEditorSupport.class);
    }

    Service getService() {
        return this.service;
    }

    FileObject getImplementationBean() {
        return this.getDataObject().getPrimaryFile();
    }

    public CloneableTopComponent createMultiView() {
        CloneableTopComponent cloneableTopComponent = MultiViews.createCloneableMultiView((String)"text/x-jaxws", (Serializable)this.dataObject);
        String string = this.getDataObject().getNodeDelegate().getDisplayName();
        cloneableTopComponent.setDisplayName(string);
        cloneableTopComponent.setName(string);
        return cloneableTopComponent;
    }

    public void view(final View view, final Object ... objectArray) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultiViewSupport.this.viewInSwingThread(view, objectArray);
                }
            });
        } else {
            this.viewInSwingThread(view, objectArray);
        }
    }

    private void viewInSwingThread(View view, Object ... objectArray) {
        TopComponent topComponent;
        ShowComponentCookie showComponentCookie;
        this.getEditorSupport().open();
        switch (view) {
            case SOURCE: {
                MultiViewSupport.requestMultiviewActive(SOURCE_VIEW_ID);
                break;
            }
            case DESIGN: {
                MultiViewSupport.requestMultiviewActive(DESIGN_VIEW_ID);
                break;
            }
            case PREVIEW: {
                MultiViewSupport.requestMultiviewActive("webservice-wsdlpreview");
            }
        }
        if (objectArray != null && objectArray.length > 0 && (showComponentCookie = (ShowComponentCookie)(topComponent = TopComponent.getRegistry().getActivated()).getLookup().lookup(ShowComponentCookie.class)) != null) {
            showComponentCookie.show(objectArray[0]);
        }
    }

    private static void requestMultiviewActive(String string) {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
        if (multiViewHandler != null) {
            MultiViewPerspective[] multiViewPerspectiveArray;
            for (MultiViewPerspective multiViewPerspective : multiViewPerspectiveArray = multiViewHandler.getPerspectives()) {
                if (!multiViewPerspective.preferredID().equals(string)) continue;
                multiViewHandler.requestActive(multiViewPerspective);
            }
        }
    }

    public static int getNumberOfClones(TopComponent topComponent) {
        if (!(topComponent instanceof CloneableTopComponent)) {
            return -1;
        }
        return Collections.list(((CloneableTopComponent)topComponent).getReference().getComponents()).size();
    }

    private void initWsdlDO() {
        JAXWSSupport jAXWSSupport;
        FileObject fileObject;
        if (this.service == null) {
            return;
        }
        DataObject dataObject = null;
        FileObject fileObject2 = null;
        FileObject fileObject3 = this.getImplementationBean();
        String string = this.service.getLocalWsdlFile();
        if (string != null && (fileObject2 = (fileObject = (jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)fileObject3)).getLocalWsdlFolderForService(this.service.getName(), false)).getFileObject(string)) != null) {
            try {
                dataObject = DataObject.find((FileObject)fileObject2);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
        }
    }

    public static enum View {
        SOURCE,
        DESIGN,
        PREVIEW;

    }
}

