/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.EventQueue;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JToolBar;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.api.visual.model.ObjectSceneEventType;
import org.netbeans.api.visual.model.ObjectSceneListener;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.javamodel.ServiceChangeListener;
import org.netbeans.modules.websvc.design.javamodel.ServiceModel;
import org.netbeans.modules.websvc.design.view.DesignViewPopupProvider;
import org.netbeans.modules.websvc.design.view.actions.AddOperationAction;
import org.netbeans.modules.websvc.design.view.actions.RemoveOperationAction;
import org.netbeans.modules.websvc.design.view.widget.ButtonWidget;
import org.netbeans.modules.websvc.design.view.widget.FlushableWidget;
import org.netbeans.modules.websvc.design.view.widget.ImageLabelWidget;
import org.netbeans.modules.websvc.design.view.widget.ObjectSceneAdapter;
import org.netbeans.modules.websvc.design.view.widget.OperationWidget;
import org.openide.util.NbBundle;

public class OperationsWidget
extends FlushableWidget {
    private transient ServiceModel serviceModel;
    private transient Action addAction;
    private transient RemoveOperationAction removeAction;
    private transient Widget buttons;
    private transient ImageLabelWidget headerLabelWidget;
    private ObjectSceneListener operationSelectionListener;

    public OperationsWidget(ObjectScene objectScene, final Service service, final ServiceModel serviceModel) {
        super(objectScene, 12, BORDER_COLOR);
        this.serviceModel = serviceModel;
        serviceModel.addServiceChangeListener(new ServiceChangeListener(){

            @Override
            public void propertyChanged(String string, String string2, String string3) {
            }

            @Override
            public void operationAdded(final MethodModel methodModel) {
                if (!EventQueue.isDispatchThread()) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OperationWidget operationWidget = new OperationWidget(OperationsWidget.this.getObjectScene(), serviceModel, service, methodModel);
                            OperationsWidget.this.getContentWidget().addChild((Widget)operationWidget);
                            OperationsWidget.this.updateHeaderLabel();
                            OperationsWidget.this.getScene().validate();
                        }
                    });
                } else {
                    OperationWidget operationWidget = new OperationWidget(OperationsWidget.this.getObjectScene(), serviceModel, service, methodModel);
                    OperationsWidget.this.getContentWidget().addChild((Widget)operationWidget);
                    OperationsWidget.this.updateHeaderLabel();
                    OperationsWidget.this.getScene().validate();
                }
            }

            @Override
            public void operationRemoved(MethodModel methodModel) {
                final Widget widget = OperationsWidget.this.getObjectScene().findWidget((Object)methodModel);
                if (widget != null) {
                    if (!EventQueue.isDispatchThread()) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                OperationsWidget.this.getContentWidget().removeChild(widget);
                                OperationsWidget.this.updateHeaderLabel();
                                OperationsWidget.this.getScene().validate();
                            }
                        });
                    } else {
                        OperationsWidget.this.getContentWidget().removeChild(widget);
                        OperationsWidget.this.updateHeaderLabel();
                        OperationsWidget.this.getScene().validate();
                    }
                }
            }

            @Override
            public void operationChanged(final MethodModel methodModel, final MethodModel methodModel2) {
                if (!EventQueue.isDispatchThread()) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.operationRemoved(methodModel);
                            this.operationAdded(methodModel2);
                        }
                    });
                } else {
                    this.operationRemoved(methodModel);
                    this.operationAdded(methodModel2);
                }
            }
        });
        this.addAction = new AddOperationAction(service, serviceModel.getImplementationClass());
        this.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)new DesignViewPopupProvider(new Action[]{this.addAction})));
        this.createContent(service);
    }

    private void createContent(Service service) {
        if (this.serviceModel == null) {
            return;
        }
        this.headerLabelWidget = new ImageLabelWidget(this.getScene(), null, NbBundle.getMessage(OperationWidget.class, (String)"LBL_Operations"));
        this.headerLabelWidget.setLabelFont(this.getScene().getFont().deriveFont(1));
        this.getHeaderWidget().addChild((Widget)this.headerLabelWidget);
        this.getHeaderWidget().addChild(new Widget(this.getScene()), (Object)1);
        this.updateHeaderLabel();
        this.buttons = new Widget(this.getScene());
        this.buttons.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)8));
        ButtonWidget buttonWidget = new ButtonWidget(this.getScene(), this.addAction);
        buttonWidget.setOpaque(true);
        buttonWidget.setRoundedBorder(ButtonWidget.BORDER_RADIUS, 4, 0, null);
        this.removeAction = new RemoveOperationAction(service);
        ButtonWidget buttonWidget2 = new ButtonWidget(this.getScene(), this.removeAction);
        buttonWidget2.setOpaque(true);
        buttonWidget2.setRoundedBorder(ButtonWidget.BORDER_RADIUS, 4, 0, null);
        this.buttons.addChild((Widget)buttonWidget);
        this.buttons.addChild((Widget)buttonWidget2);
        this.buttons.addChild((Widget)this.getExpanderWidget());
        this.getHeaderWidget().addChild(this.buttons);
        this.getContentWidget().setBorder(BorderFactory.createEmptyBorder((int)12));
        if (this.serviceModel.getOperations() != null) {
            for (MethodModel methodModel : this.serviceModel.getOperations()) {
                OperationWidget operationWidget = new OperationWidget(this.getObjectScene(), this.serviceModel, service, methodModel);
                this.getContentWidget().addChild((Widget)operationWidget);
            }
        }
    }

    private void updateHeaderLabel() {
        int n = this.serviceModel.getOperations() == null ? 0 : this.serviceModel.getOperations().size();
        this.headerLabelWidget.setComment("(" + n + ")");
    }

    @Override
    public Object hashKey() {
        return this.serviceModel;
    }

    @Override
    protected void notifyAdded() {
        super.notifyAdded();
        this.operationSelectionListener = new ObjectSceneAdapter(){

            @Override
            public void selectionChanged(ObjectSceneEvent objectSceneEvent, Set<Object> set, Set<Object> set2) {
                HashSet<MethodModel> hashSet = new HashSet<MethodModel>();
                if (set2 != null) {
                    for (Object object : set2) {
                        if (!(object instanceof MethodModel)) continue;
                        hashSet.add((MethodModel)object);
                    }
                }
                OperationsWidget.this.removeAction.setWorkingSet(hashSet);
            }
        };
        this.getObjectScene().addObjectSceneListener(this.operationSelectionListener, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_SELECTION_CHANGED});
    }

    @Override
    protected void notifyRemoved() {
        super.notifyRemoved();
        if (this.operationSelectionListener != null) {
            this.getObjectScene().removeObjectSceneListener(this.operationSelectionListener, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_SELECTION_CHANGED});
            this.operationSelectionListener = null;
        }
    }

    public void addToolbarActions(JToolBar jToolBar) {
        jToolBar.add(this.addAction);
    }
}

