/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import org.netbeans.modules.cnd.debugger.common2.debugger.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.spi.debugger.ui.BreakpointAnnotation;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.util.Utilities;

public class DebuggerAnnotation
extends BreakpointAnnotation
implements PropertyChangeListener {
    public static final String TYPE_CURRENT_PC = "CurrentPC";
    public static final String TYPE_CALLSITE = "CallSite";
    public static final String TYPE_BPT = "Breakpoint";
    public static final String TYPE_BPTX_COMPLEX = "Cond";
    public static final String TYPE_BPTX_BROKEN = "_broken";
    public static final String TYPE_BPTX_DISABLED = "Disabled";
    private final Listener owner;
    private Line line;
    private String type;
    private final long addr;
    private String shortDescription = null;
    private final NativeBreakpoint breakpoint;

    public DebuggerAnnotation(Listener owner, String type, Line line, long addr, boolean isCurrent, NativeBreakpoint breakpoint) {
        this.addr = addr;
        this.owner = owner;
        this.type = type;
        this.line = line;
        this.breakpoint = breakpoint;
        this.ourAttach(line, isCurrent);
    }

    public DebuggerAnnotation(Listener owner, String type, Line line, boolean isCurrent) {
        this(owner, type, line, 0L, isCurrent, null);
    }

    public NativeBreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String pName = e.getPropertyName();
        if (pName == "lineNumber" && this.owner != null) {
            this.owner.annotationMoved();
        }
    }

    public void setAnnotationType(String newType) {
        String oldType = this.type;
        if (IpeUtils.sameString(oldType, newType)) {
            return;
        }
        this.type = newType;
        this.firePropertyChange("annotationType", oldType, newType);
    }

    public void setLine(Line newLine, boolean isCurrent) {
        if (this.line == newLine) {
            if (this.line == null) {
                this.ourDetach();
            }
            return;
        }
        if (newLine != null) {
            this.ourAttach(newLine, isCurrent);
        } else {
            this.ourDetach();
        }
        this.line = newLine;
    }

    public void attach(boolean isCurrent) {
        this.ourAttach(this.line, isCurrent);
    }

    private void ourAttach(Line line, boolean isCurrent) {
        if (!isCurrent) {
            return;
        }
        if (line != null) {
            this.attach((Annotatable)line);
            line.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private void ourDetach() {
        if (this.line != null) {
            this.line.removePropertyChangeListener((PropertyChangeListener)this);
            super.detach();
        }
    }

    public String getAnnotationType() {
        return this.type;
    }

    public long getAddr() {
        return this.addr;
    }

    public Line getLine() {
        return this.line;
    }

    public String getFilename() {
        if (this.line == null) {
            return null;
        }
        return EditorBridge.filenameFor(this.line);
    }

    public int getLineNo() {
        if (this.line == null) {
            return 0;
        }
        int lineNo = this.line.getLineNumber();
        return ++lineNo;
    }

    public boolean matchesLine(String src, int ln) {
        if (this.line == null) {
            return false;
        }
        String fileName = EditorBridge.filenameFor(this.line);
        if (Utilities.isWindows()) {
            fileName = fileName.replace("\\", "/");
        }
        return src.equals(fileName) && this.getLineNo() == ln;
    }

    public boolean fileIsNewerThan(Date timeStamp) {
        if (this.line == null) {
            return true;
        }
        Date fileTime = EditorBridge.lastModified(this.line);
        boolean after = fileTime.after(timeStamp);
        return after;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getShortDescription() {
        if (this.shortDescription != null) {
            return this.shortDescription;
        }
        if (this.type == TYPE_CURRENT_PC) {
            return Catalog.get("TOOLTIP_CURRENT_PC");
        }
        if (this.type == TYPE_CALLSITE) {
            return Catalog.get("TOOLTIP_CALLSITE");
        }
        if (this.type.contains(TYPE_BPT)) {
            return Catalog.get("TOOLTIP_BREAKPOINT");
        }
        return Catalog.get("TOOLTIP_ANNOTATION");
    }

    public void enableInstBpt(NativeBreakpoint bpt) {
        NativeDebugger debugger = DebuggerManager.get().currentDebugger();
        if (debugger != null) {
            debugger.InstBptEnabled(this.addr, bpt);
        }
    }

    public void disableInstBpt(NativeBreakpoint bpt) {
        NativeDebugger debugger = DebuggerManager.get().currentDebugger();
        if (debugger != null) {
            debugger.InstBptDisabled(this.addr, bpt);
        }
    }

    public void addInstBpt(NativeBreakpoint bpt) {
        NativeDebugger debugger = DebuggerManager.get().currentDebugger();
        if (debugger != null) {
            debugger.InstBptAdded(this.addr, bpt);
        }
    }

    public void removeInstBpt(NativeBreakpoint bpt) {
        NativeDebugger debugger = DebuggerManager.get().currentDebugger();
        if (debugger != null) {
            debugger.InstBptRemoved(this.addr, bpt);
        }
    }

    public static interface Listener {
        public void annotationMoved();
    }
}

