/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class VariablesViewButtons {
    public static final String PREFERENCES_NAME = "variables_view";
    public static final String SHOW_AUTOS = "show_autos";
    private static JToggleButton showAutosToggle = null;

    public static synchronized JToggleButton createShowAutosButton() {
        if (showAutosToggle != null) {
            return showAutosToggle;
        }
        showAutosToggle = VariablesViewButtons.createToggleButton(SHOW_AUTOS, "org/netbeans/modules/cnd/debugger/common2/icons/autos.png", NbBundle.getMessage(VariablesViewButtons.class, (String)"Hint_Show_Autos"));
        showAutosToggle.addActionListener(new ShowAutosActionListener(showAutosToggle));
        return showAutosToggle;
    }

    private static JToggleButton createToggleButton(String id, String iconPath, String tooltip) {
        ImageIcon icon = ImageUtilities.loadImageIcon((String)iconPath, (boolean)false);
        boolean isSelected = VariablesViewButtons.isButtonSelected(id);
        JToggleButton toggleButton = new JToggleButton(icon, isSelected);
        Dimension size = new Dimension(icon.getIconWidth() + 8, icon.getIconHeight() + 8);
        toggleButton.setPreferredSize(size);
        toggleButton.setMargin(new Insets(1, 1, 1, 1));
        toggleButton.setToolTipText(tooltip);
        toggleButton.setFocusable(false);
        toggleButton.setEnabled(!DebuggerManager.isStandalone());
        return toggleButton;
    }

    public static boolean isShowAutos() {
        if (DebuggerManager.isStandalone()) {
            return false;
        }
        Preferences preferences = NbPreferences.forModule(VariablesViewButtons.class).node(PREFERENCES_NAME);
        return preferences.getBoolean(SHOW_AUTOS, false);
    }

    private static boolean isButtonSelected(String name) {
        if (name.equals(SHOW_AUTOS)) {
            return VariablesViewButtons.isShowAutos();
        }
        return false;
    }

    private static void setButtonSelected(String name, boolean selected) {
        Preferences preferences = NbPreferences.forModule(VariablesViewButtons.class).node(PREFERENCES_NAME);
        preferences.putBoolean(name, selected);
    }

    private static class ShowAutosActionListener
    implements ActionListener {
        private JToggleButton button;

        ShowAutosActionListener(JToggleButton toggleButton) {
            this.button = toggleButton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isSelected = this.button.isSelected();
            VariablesViewButtons.setButtonSelected(VariablesViewButtons.SHOW_AUTOS, isSelected);
        }
    }
}

